/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import net.imglib2.blocks.Convert;
import net.imglib2.blocks.PrimitiveTypeProperties;
import net.imglib2.converter.Converter;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;

class ConvertImpl {
    ConvertImpl() {
    }

    static class ConvertGeneric<A extends NativeType<A>, B extends NativeType<B>>
    implements Convert {
        private final Supplier<Converter<A, B>> converterSupplier;
        private final Converter<A, B> converter;
        private final Function<Object, A> srcWrapper;
        private final Function<Object, B> destWrapper;

        public ConvertGeneric(A srcType, B destType, Supplier<Converter<A, B>> converterSupplier) {
            this.converterSupplier = converterSupplier;
            this.converter = converterSupplier.get();
            this.srcWrapper = ConvertGeneric.wrapperForType(srcType);
            this.destWrapper = ConvertGeneric.wrapperForType(destType);
        }

        @Override
        public void convert(Object src, Object dest, int length) {
            NativeType in = (NativeType)this.srcWrapper.apply(src);
            NativeType out = (NativeType)this.destWrapper.apply(dest);
            for (int i = 0; i < length; ++i) {
                in.index().set(i);
                out.index().set(i);
                this.converter.convert(in, out);
            }
        }

        private ConvertGeneric(ConvertGeneric<A, B> convert) {
            this.converterSupplier = convert.converterSupplier;
            this.converter = this.converterSupplier.get();
            this.srcWrapper = convert.srcWrapper;
            this.destWrapper = convert.destWrapper;
        }

        @Override
        public Convert newInstance() {
            return new ConvertGeneric<A, B>(this);
        }

        static <T extends NativeType<T>, A extends ArrayDataAccess<A>> Function<Object, T> wrapperForType(T type) {
            NativeTypeFactory nativeTypeFactory = type.getNativeTypeFactory();
            PrimitiveTypeProperties<?, ?> props = PrimitiveTypeProperties.get(nativeTypeFactory.getPrimitiveType());
            return array -> {
                ArrayImg img = new ArrayImg((DataAccess)props.wrap(array), new long[]{1L}, type.getEntitiesPerPixel());
                Object t = nativeTypeFactory.createLinkedType(img);
                t.updateContainer(null);
                return t;
            };
        }
    }

    static class Convert_UnsignedByteType_FloatType
    implements Convert {
        private final Supplier<Converter<UnsignedByteType, FloatType>> converterSupplier;
        private final Converter<UnsignedByteType, FloatType> converter;

        public Convert_UnsignedByteType_FloatType(Supplier<Converter<UnsignedByteType, FloatType>> converterSupplier) {
            this.converterSupplier = converterSupplier;
            this.converter = converterSupplier.get();
        }

        @Override
        public void convert(Object src, Object dest, int length) {
            UnsignedByteType in = new UnsignedByteType(new ByteArray((byte[])src));
            FloatType out = new FloatType(new FloatArray((float[])dest));
            for (int i = 0; i < length; ++i) {
                in.index().set(i);
                out.index().set(i);
                this.converter.convert(in, out);
            }
        }

        private Convert_UnsignedByteType_FloatType(Convert_UnsignedByteType_FloatType convert) {
            this.converterSupplier = convert.converterSupplier;
            this.converter = this.converterSupplier.get();
        }

        @Override
        public Convert newInstance() {
            return new Convert_UnsignedByteType_FloatType(this);
        }
    }

    static class Convert_UnsignedShortType_FloatType
    implements Convert {
        private final Supplier<Converter<UnsignedShortType, FloatType>> converterSupplier;
        private final Converter<UnsignedShortType, FloatType> converter;

        public Convert_UnsignedShortType_FloatType(Supplier<Converter<UnsignedShortType, FloatType>> converterSupplier) {
            this.converterSupplier = converterSupplier;
            this.converter = converterSupplier.get();
        }

        @Override
        public void convert(Object src, Object dest, int length) {
            UnsignedShortType in = new UnsignedShortType(new ShortArray((short[])src));
            FloatType out = new FloatType(new FloatArray((float[])dest));
            for (int i = 0; i < length; ++i) {
                in.index().set(i);
                out.index().set(i);
                this.converter.convert(in, out);
            }
        }

        private Convert_UnsignedShortType_FloatType(Convert_UnsignedShortType_FloatType convert) {
            this.converterSupplier = convert.converterSupplier;
            this.converter = this.converterSupplier.get();
        }

        @Override
        public Convert newInstance() {
            return new Convert_UnsignedShortType_FloatType(this);
        }
    }
}

