/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Bucketable;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Bucket {
    public static final int MIN_BUCKET_SIZE = 4096;
    private int bucket_side;
    private TreeMap<Integer, Displayable> map = null;
    private ArrayList<Bucket> children = null;
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private boolean empty = true;

    public Bucket(int x, int y, int w, int h, int bucket_side) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.bucket_side = bucket_side;
        Utils.showStatus("Creating bucket " + x + ',' + y + ',' + w + ',' + h, false);
    }

    public String toString() {
        return "Bucket: " + this.x + ",  " + this.y + ", " + this.w + ", " + this.h;
    }

    final synchronized void populate(Bucketable container, Layer layer, HashMap<Displayable, HashSet<Bucket>> db_map) {
        if (null != this.map) {
            this.map.clear();
        }
        this.children = null;
        HashMap<Integer, Displayable> list = new HashMap<Integer, Displayable>();
        int i = 0;
        HashMap<Displayable, Area> areas = new HashMap<Displayable, Area>();
        for (Displayable displayable : container.getDisplayableList()) {
            list.put(i, displayable);
            ++i;
            Area a = displayable.getAreaForBucket(layer);
            if (null == a) continue;
            areas.put(displayable, a);
        }
        this.populate(container, db_map, this.w + this.w, this.h + this.h, this.w, this.h, list, areas);
    }

    private final boolean populate(Bucketable container, HashMap<Displayable, HashSet<Bucket>> db_map, int parent_w, int parent_h, int max_width, int max_height, HashMap<Integer, Displayable> parent_list, HashMap<Displayable, Area> areas) {
        if (this.w <= this.bucket_side || this.h <= this.bucket_side) {
            this.map = new TreeMap();
            for (Map.Entry<Integer, Displayable> e : parent_list.entrySet()) {
                Displayable d = e.getValue();
                Area a = areas.get(d);
                if (null == a || !a.intersects(this.x, this.y, this.w, this.h)) continue;
                this.map.put(e.getKey(), d);
                this.putToBucketMap(d, db_map);
            }
            this.empty = this.map.isEmpty();
        } else {
            int side_w;
            this.children = new ArrayList(4);
            int side_h = side_w = (int)Math.pow(2.0, (int)Math.floor(Math.log(Math.max(this.w, this.h)) / Math.log(2.0)) - 1);
            if (side_w > max_width) {
                side_w = max_width;
            }
            if (side_h > max_height) {
                side_h = max_height;
            }
            HashMap<Integer, Displayable> local_list = new HashMap<Integer, Displayable>();
            for (Map.Entry<Integer, Displayable> e : parent_list.entrySet()) {
                Displayable d = e.getValue();
                Area a = areas.get(d);
                if (null == a || !a.intersects(this.x, this.y, this.w, this.h)) continue;
                local_list.put(e.getKey(), d);
            }
            for (int x = 0; x < parent_w; x += side_w) {
                if (this.x + x >= max_width) continue;
                int width = side_w;
                if (this.x + x + side_w > max_width) {
                    width = max_width - this.x - x;
                }
                for (int y = 0; y < parent_h; y += side_h) {
                    Bucket bu;
                    if (this.y + y >= max_height) continue;
                    int height = side_h;
                    if (this.y + y + side_h > max_height) {
                        height = max_height - this.y - y;
                    }
                    if ((bu = new Bucket(this.x + x, this.y + y, width, height, this.bucket_side)).populate(container, db_map, width, height, max_width, max_height, local_list, areas)) {
                        this.empty = false;
                    }
                    this.children.add(bu);
                }
            }
        }
        return !this.empty;
    }

    private final boolean intersects(Rectangle r) {
        if (r.width <= 0 || r.height <= 0 || this.w <= 0 || this.h <= 0) {
            return false;
        }
        int rw = r.x + r.width;
        int rh = r.y + r.height;
        int tw = this.w + this.x;
        int th = this.h + this.y;
        return !(rw >= r.x && rw <= this.x || rh >= r.y && rh <= this.y || tw >= this.x && tw <= r.x || th >= this.y && th <= r.y);
    }

    private final boolean contains(double px, double py) {
        return px >= (double)this.x && py >= (double)this.y && px <= (double)(this.x + this.w) && py <= (double)(this.y + this.h);
    }

    final synchronized Collection<Displayable> find(Rectangle srcRect, Layer layer, boolean visible_only) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.find(accum, srcRect, layer, visible_only);
        return accum.values();
    }

    private void find(TreeMap<Integer, Displayable> accum, Rectangle srcRect, Layer layer, boolean visible_only) {
        if (this.empty || !this.intersects(srcRect)) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.find(accum, srcRect, layer, visible_only);
            }
        } else {
            Area asrc = new Area(srcRect);
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Area a;
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || null == (a = d.getAreaForBucket(layer)) || !M.intersects(asrc, a)) continue;
                accum.put(entry.getKey(), d);
            }
        }
    }

    final synchronized Collection<Displayable> roughlyFind(Rectangle srcRect, Layer layer, boolean visible_only) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.roughlyFind(accum, srcRect, layer, visible_only);
        return accum.values();
    }

    private void roughlyFind(TreeMap<Integer, Displayable> accum, Rectangle srcRect, Layer layer, boolean visible_only) {
        if (this.empty || !this.intersects(srcRect)) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.roughlyFind(accum, srcRect, layer, visible_only);
            }
        } else {
            Rectangle BOX = new Rectangle(this.x, this.y, this.w, this.h);
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || !d.isRoughlyInside(layer, BOX)) continue;
                accum.put(entry.getKey(), d);
            }
        }
    }

    final synchronized Collection<Displayable> find(Class<?> c, Rectangle srcRect, Layer layer, boolean visible_only, boolean instance_of) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.find(accum, c, srcRect, layer, visible_only, instance_of);
        return accum.values();
    }

    private void find(TreeMap<Integer, Displayable> accum, Class<?> c, Rectangle srcRect, Layer layer, boolean visible_only, boolean instance_of) {
        if (this.empty || !this.intersects(srcRect)) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.find(accum, c, srcRect, layer, visible_only, instance_of);
            }
        } else {
            Area asrc = new Area(srcRect);
            if (instance_of) {
                for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                    Area a;
                    Displayable d = entry.getValue();
                    if (visible_only && !d.isVisible() || !c.isAssignableFrom(d.getClass()) || null == (a = d.getAreaForBucket(layer)) || !M.intersects(asrc, a)) continue;
                    accum.put(entry.getKey(), d);
                }
            } else {
                for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                    Area a;
                    Displayable d = entry.getValue();
                    if (visible_only && !d.isVisible() || d.getClass() != c || null == (a = d.getAreaForBucket(layer)) || !M.intersects(asrc, a)) continue;
                    accum.put(entry.getKey(), d);
                }
            }
        }
    }

    final synchronized Collection<Displayable> find(double px, double py, Layer layer, boolean visible_only) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.find(accum, px, py, layer, visible_only);
        return accum.values();
    }

    private void find(TreeMap<Integer, Displayable> accum, double px, double py, Layer layer, boolean visible_only) {
        if (this.empty || !this.contains(px, py)) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.find(accum, px, py, layer, visible_only);
            }
        } else {
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || !d.contains(layer, px, py)) continue;
                accum.put(entry.getKey(), d);
            }
        }
    }

    final synchronized Collection<Displayable> find(Class<?> c, double px, double py, Layer layer, boolean visible_only, boolean instance_of) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.find(accum, c, px, py, layer, visible_only, instance_of);
        return accum.values();
    }

    private void find(TreeMap<Integer, Displayable> accum, Class<?> c, double px, double py, Layer layer, boolean visible_only, boolean instance_of) {
        if (this.empty || !this.contains(px, py)) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.find(accum, c, px, py, layer, visible_only, instance_of);
            }
        } else if (instance_of) {
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || !c.isAssignableFrom(d.getClass()) || !d.contains(layer, px, py)) continue;
                accum.put(entry.getKey(), d);
            }
        } else {
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || d.getClass() != c || !d.contains(layer, px, py)) continue;
                accum.put(entry.getKey(), d);
            }
        }
    }

    final synchronized Collection<Displayable> find(Area area, Layer layer, boolean visible_only) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.find(accum, area, layer, visible_only);
        return accum.values();
    }

    private void find(TreeMap<Integer, Displayable> accum, Area area, Layer layer, boolean visible_only) {
        if (this.empty || !this.intersects(area.getBounds())) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.find(accum, area, layer, visible_only);
            }
        } else {
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || !d.intersects(layer, area)) continue;
                accum.put(entry.getKey(), d);
            }
        }
    }

    final synchronized Collection<Displayable> find(Class<?> c, Area area, Layer layer, boolean visible_only, boolean instance_of) {
        TreeMap<Integer, Displayable> accum = new TreeMap<Integer, Displayable>();
        this.find(accum, c, area, layer, visible_only, instance_of);
        return accum.values();
    }

    private void find(TreeMap<Integer, Displayable> accum, Class<?> c, Area area, Layer layer, boolean visible_only, boolean instance_of) {
        if (this.empty || !this.intersects(area.getBounds())) {
            return;
        }
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.find(accum, c, area, layer, visible_only, instance_of);
            }
        } else if (instance_of) {
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || !c.isAssignableFrom(d.getClass()) || !d.intersects(layer, area)) continue;
                accum.put(entry.getKey(), d);
            }
        } else {
            for (Map.Entry<Integer, Displayable> entry : this.map.entrySet()) {
                Displayable d = entry.getValue();
                if (visible_only && !d.isVisible() || d.getClass() != c || !d.intersects(layer, area)) continue;
                accum.put(entry.getKey(), d);
            }
        }
    }

    final synchronized void updateRange(Bucketable container, Displayable d, int old_i, int new_i) {
        HashMap<Displayable, Integer> stack_indices = new HashMap<Displayable, Integer>();
        ArrayList<? extends Displayable> dlist = container.getDisplayableList();
        for (int i = old_i; i <= new_i; ++i) {
            stack_indices.put(dlist.get(i), i);
        }
        this.updateRange(container, old_i, new_i, stack_indices);
    }

    private final void updateRange(Bucketable container, int first, int last, HashMap<Displayable, Integer> new_stack_indices) {
        block4: {
            block3: {
                if (null == this.children) break block3;
                for (Bucket bu : this.children) {
                    bu.updateRange(container, first, last, new_stack_indices);
                }
                break block4;
            }
            if (null == this.map) break block4;
            ArrayList<Displayable> a = new ArrayList<Displayable>(last - first + 1);
            for (int i = first; i <= last; ++i) {
                Displayable d = this.map.remove(i);
                if (null == d) continue;
                a.add(d);
            }
            for (Displayable d : a) {
                this.map.put(new_stack_indices.get(d), d);
            }
        }
    }

    final synchronized void updatePosition(Displayable d, Layer layer, HashMap<Displayable, HashSet<Bucket>> db_map) {
        HashSet<Bucket> hs = db_map.get(d);
        Area a = d.getAreaForBucket(layer);
        int stack_index = d.getBucketable().getDisplayableList().indexOf(d);
        if (null != hs) {
            Iterator<Bucket> it = hs.iterator();
            while (it.hasNext()) {
                Bucket bu = it.next();
                if (null != a && a.intersects(bu.x, bu.y, bu.w, bu.h)) continue;
                bu.map.remove(stack_index);
                it.remove();
            }
        }
        if (null != a) {
            this.put(stack_index, d, layer, a, db_map);
        }
    }

    final synchronized void put(int stack_index, Displayable d, Layer layer, HashMap<Displayable, HashSet<Bucket>> db_map) {
        this.put(stack_index, d, layer, d.getAreaForBucket(layer), db_map);
    }

    final synchronized void put(int stack_index, Displayable d, Layer layer, Area a, HashMap<Displayable, HashSet<Bucket>> db_map) {
        if (null == a) {
            return;
        }
        this.putIn(stack_index, d, a, db_map);
    }

    private final void putIn(int stack_index, Displayable d, Area a, HashMap<Displayable, HashSet<Bucket>> db_map) {
        if (!a.intersects(this.x, this.y, this.w, this.h)) {
            return;
        }
        this.empty = false;
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.putIn(stack_index, d, a, db_map);
            }
        } else if (null != this.map) {
            this.map.put(stack_index, d);
            this.putToBucketMap(d, db_map);
        }
    }

    private final void putToBucketMap(Displayable d, HashMap<Displayable, HashSet<Bucket>> db_map) {
        HashSet<Bucket> list = db_map.get(d);
        if (null == list) {
            list = new HashSet();
            db_map.put(d, list);
            list.add(this);
        } else {
            list.add(this);
        }
    }

    private final boolean remove2(Displayable d, int old_stack_index, HashMap<Displayable, Integer> new_stack_indices) {
        boolean success = true;
        if (null != this.children) {
            this.empty = true;
            for (Bucket bu : this.children) {
                if (bu.remove2(d, old_stack_index, new_stack_indices)) continue;
                this.empty = false;
                success = false;
            }
            return success;
        }
        if (null != this.map) {
            this.reindex(new_stack_indices);
        }
        return success;
    }

    final synchronized boolean remove(Displayable d, int old_stack_index, HashMap<Displayable, Integer> new_stack_indices) {
        return this.remove2(d, old_stack_index, new_stack_indices);
    }

    private final boolean removeAll2(Collection<Integer> old_stack_indices, HashMap<Displayable, Integer> new_stack_indices) {
        if (null != this.children) {
            this.empty = true;
            for (Bucket bu : this.children) {
                if (bu.removeAll2(old_stack_indices, new_stack_indices)) continue;
                this.empty = false;
            }
        } else if (null != this.map) {
            this.reindex(new_stack_indices);
            return this.map.isEmpty();
        }
        return true;
    }

    final synchronized void removeAll(Collection<Integer> old_stack_indices, HashMap<Displayable, Integer> new_stack_indices) {
        this.removeAll2(old_stack_indices, new_stack_indices);
    }

    final void reindex(HashMap<Displayable, Integer> new_stack_indices) {
        block5: {
            block4: {
                if (null == new_stack_indices) {
                    return;
                }
                if (null == this.children) break block4;
                for (Bucket bu : this.children) {
                    bu.reindex(new_stack_indices);
                }
                break block5;
            }
            if (null == this.map) break block5;
            HashSet<Displayable> hs = new HashSet<Displayable>(this.map.values());
            this.map.clear();
            for (Displayable d : hs) {
                Integer i = new_stack_indices.get(d);
                if (null == i) {
                    Utils.log2("WARNING: Bucket.reindex could not find an index for " + d);
                    continue;
                }
                this.map.put(i, d);
            }
        }
    }

    public synchronized void paint(Graphics2D g, Rectangle srcRect, double mag, Color color) {
        if (null == this.map) {
            for (Bucket bu : this.children) {
                bu.paint(g, srcRect, mag, color);
            }
            return;
        }
        Graphics2D g2d = g;
        Stroke original_stroke = g2d.getStroke();
        AffineTransform original = g2d.getTransform();
        g2d.setTransform(new AffineTransform());
        g2d.setStroke(new BasicStroke(2.0f, 0, 0));
        g.setColor(color);
        g.drawRect((int)((double)(this.x - srcRect.x) * mag), (int)((double)(this.y - srcRect.y) * mag), (int)((double)this.w * mag), (int)((double)this.h * mag));
        g2d.setStroke(original_stroke);
        g2d.drawString(Integer.toString(this.map.size()), (int)((double)(this.x - srcRect.x + this.w / 2) * mag), (int)((double)(this.y - srcRect.y + this.h / 2) * mag));
        g2d.setTransform(original);
    }

    public final boolean isBetter(Rectangle r, Bucketable container) {
        return (float)(r.width * r.height) < (container.getLayerWidth() - (float)this.bucket_side) * (container.getLayerHeight() - (float)this.bucket_side);
    }

    private final ArrayList<Bucket> getChildren(ArrayList<Bucket> bus) {
        if (null != this.children) {
            for (Bucket bu : this.children) {
                bu.getChildren(bus);
            }
        } else if (null != this.map) {
            bus.add(this);
        }
        return bus;
    }

    public void debug() {
        Utils.log2("total map buckets: " + this.getChildren(new ArrayList<Bucket>()).size());
    }

    public static int getBucketSide(Bucketable container, Layer la) {
        if (null != container.getProject().getProperty("bucket_side")) {
            int size = container.getProject().getProperty("bucket_side", 4096);
            if (size < 4096) {
                Utils.logAll("WARNING: bucket side (" + size + ") is smaller than the recommended minimum of " + 4096 + "\nYou may adjust the bucket side in the 'Project - Properties' popup menu.");
            }
            return size;
        }
        ArrayList<? extends Displayable> col = container.getDisplayableList();
        if (0 == col.size()) {
            return 4096;
        }
        int[] sizes = new int[col.size()];
        int i = 0;
        for (Displayable displayable : col) {
            Area a = displayable.getAreaForBucket(la);
            if (null == a) continue;
            Rectangle r = a.getBounds();
            sizes[i++] = Math.max(r.width, r.height);
        }
        Arrays.sort(sizes);
        int size = 2 * sizes[sizes.length / 2];
        return size > 4096 ? size : 4096;
    }
}

