/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.tree.TemplateThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TrakEM2MLParser {
    TemplateThing root = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrakEM2MLParser(String file_path) {
        InputStream i_stream = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            i_stream = new BufferedInputStream(new FileInputStream(file_path));
            InputSource input_source = new InputSource(i_stream);
            TrakEM2MLHandler handler = new TrakEM2MLHandler();
            parser.parse(input_source, (DefaultHandler)handler);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != i_stream) {
                try {
                    i_stream.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrakEM2MLParser(InputStream xml_stream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            InputSource input_source = new InputSource(xml_stream);
            TrakEM2MLHandler handler = new TrakEM2MLHandler();
            parser.parse(input_source, (DefaultHandler)handler);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != xml_stream) {
                try {
                    xml_stream.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
    }

    public TemplateThing getTemplateRoot() {
        return this.root;
    }

    class TrakEM2MLHandler
    extends DefaultHandler {
        private TemplateThing current_thing = null;
        private ArrayList<TemplateThing> al_open = new ArrayList();

        TrakEM2MLHandler() {
        }

        @Override
        public void startElement(String namespace_URI, String local_name, String qualified_name, Attributes attributes) throws SAXException {
            int size;
            TemplateThing new_thing;
            this.current_thing = new_thing = new TemplateThing(qualified_name);
            if (null == TrakEM2MLParser.this.root) {
                TrakEM2MLParser.this.root = new_thing;
            }
            if ((size = this.al_open.size()) > 0) {
                TemplateThing parent = this.al_open.get(size - 1);
                parent.addChild(new_thing);
            }
            this.al_open.add(new_thing);
        }

        @Override
        public void endElement(String namespace_URI, String local_name, String qualified_name) {
            for (int i = this.al_open.size() - 1; i > -1; --i) {
                TemplateThing tt = this.al_open.get(i);
                if (!tt.getType().equals(qualified_name)) continue;
                this.al_open.remove(tt);
                break;
            }
        }

        @Override
        public void characters(char[] c, int start, int length) {
            String value;
            if (length > 0 && (value = new String(c, start, length).trim()).length() > 0) {
                this.current_thing.setValue(value);
            }
            String type = this.current_thing.getType();
            String line = new String(c);
            if (-1 != line.indexOf("/" + type)) {
                this.endElement(null, null, type);
            }
        }

        @Override
        public void fatalError(SAXParseException e) {
            Utils.log("Fatal error: column=" + e.getColumnNumber() + " line=" + e.getLineNumber());
            TrakEM2MLParser.this.root = null;
        }

        @Override
        public void skippedEntity(String name) {
            Utils.log("SAX Parser has skipped: " + name);
        }

        public void notationDeclaration(String name, String publicId, String systemId) {
            Utils.log("Notation declaration: " + name + ", " + publicId + ", " + systemId);
        }

        @Override
        public void warning(SAXParseException e) {
            Utils.log("SAXParseException : " + e);
        }
    }
}

