/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align.concurrent;

import ij.process.FloatProcessor;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.Filter;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import mpicbg.ij.blockmatching.BlockMatching;
import mpicbg.models.AbstractModel;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.trakem2.align.AlignmentUtils;
import mpicbg.trakem2.align.ElasticLayerAlignment;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.transform.ExportBestFlatImage;
import mpicbg.trakem2.util.Pair;
import mpicbg.trakem2.util.Triple;

public class BlockMatchPairCallable
implements Callable<BlockMatchResults>,
Serializable {
    private final Layer layer1;
    private final Layer layer2;
    private final boolean layer1Fixed;
    private final boolean layer2Fixed;
    private final Filter<Patch> filter;
    private final ElasticLayerAlignment.Param param;
    private final Collection<? extends Point> v1;
    private final Collection<? extends Point> v2;
    private final Rectangle box;
    private final Triple<Integer, Integer, AbstractModel<?>> pair;

    public BlockMatchPairCallable(Triple<Integer, Integer, AbstractModel<?>> pair, List<Layer> layerRange, boolean layer1Fixed, boolean layer2Fixed, Filter<Patch> filter, ElasticLayerAlignment.Param param, Collection<? extends Point> sourcePoints1, Collection<? extends Point> sourcePoints2, Rectangle box) {
        this.pair = pair;
        this.layer1 = layerRange.get((Integer)pair.a);
        this.layer2 = layerRange.get((Integer)pair.b);
        this.layer1Fixed = layer1Fixed;
        this.layer2Fixed = layer2Fixed;
        this.filter = filter;
        this.param = param;
        this.v1 = sourcePoints1;
        this.v2 = sourcePoints2;
        this.box = box;
    }

    @Override
    public BlockMatchResults call() throws Exception {
        ArrayList<PointMatch> pm12 = new ArrayList<PointMatch>();
        ArrayList<PointMatch> pm21 = new ArrayList<PointMatch>();
        System.out.println("BMC rev 0: " + this.pair.a + " " + this.pair.b);
        Pair<FloatProcessor, FloatProcessor> pair1 = this.makeFlatImage(this.layer1, AlignmentUtils.filterPatches(this.layer1, this.filter), this.box, this.param.layerScale);
        Pair<FloatProcessor, FloatProcessor> pair2 = this.makeFlatImage(this.layer2, AlignmentUtils.filterPatches(this.layer2, this.filter), this.box, this.param.layerScale);
        FloatProcessor ip1 = (FloatProcessor)pair1.a;
        FloatProcessor ip1Mask = (FloatProcessor)pair1.b;
        FloatProcessor ip2 = (FloatProcessor)pair2.a;
        FloatProcessor ip2Mask = (FloatProcessor)pair2.b;
        AbstractModel<?> localSmoothnessFilterModel = Util.createModel(this.param.localModelIndex);
        int blockRadius = Math.max(16, mpicbg.util.Util.roundPos((double)(this.param.layerScale * (double)this.param.blockRadius)));
        int searchRadius = (int)Math.round(this.param.layerScale * (double)this.param.searchRadius);
        double localRegionSigma = this.param.layerScale * (double)this.param.localRegionSigma;
        double maxLocalEpsilon = this.param.layerScale * (double)this.param.maxLocalEpsilon;
        if (!this.layer1Fixed) {
            BlockMatching.matchByMaximalPMCC((FloatProcessor)ip1, (FloatProcessor)ip2, (FloatProcessor)ip1Mask, (FloatProcessor)ip2Mask, (double)1.0, (CoordinateTransform)((InvertibleCoordinateTransform)this.pair.c).createInverse(), (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)this.param.minR, (float)this.param.rodR, (float)this.param.maxCurvatureR, this.v1, pm12, (ErrorStatistic)new ErrorStatistic(1));
            if (Thread.interrupted()) {
                throw new InterruptedException("Block matching interrupted.");
            }
            if (this.param.useLocalSmoothnessFilter) {
                localSmoothnessFilterModel.localSmoothnessFilter(pm12, pm12, localRegionSigma, maxLocalEpsilon, (double)this.param.maxLocalTrust);
            }
        }
        if (!this.layer2Fixed) {
            BlockMatching.matchByMaximalPMCC((FloatProcessor)ip2, (FloatProcessor)ip1, (FloatProcessor)ip2Mask, (FloatProcessor)ip1Mask, (double)1.0, (CoordinateTransform)((CoordinateTransform)this.pair.c), (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)this.param.minR, (float)this.param.rodR, (float)this.param.maxCurvatureR, this.v2, pm21, (ErrorStatistic)new ErrorStatistic(1));
            if (Thread.interrupted()) {
                throw new InterruptedException("Block matching interrupted.");
            }
            if (this.param.useLocalSmoothnessFilter) {
                localSmoothnessFilterModel.localSmoothnessFilter(pm21, pm21, localRegionSigma, maxLocalEpsilon, (double)this.param.maxLocalTrust);
            }
        }
        return new BlockMatchResults(this.v1, this.v2, pm12, pm21, this.layer1Fixed, this.layer2Fixed, this.pair);
    }

    private Pair<FloatProcessor, FloatProcessor> makeFlatImage(Layer layer, List<Patch> patches, Rectangle box, double scale) {
        Pair<FloatProcessor, FloatProcessor> pair = new ExportBestFlatImage(patches, box, 0, scale).makeFlatFloatGrayImageAndAlpha();
        float[] alpha = (float[])((FloatProcessor)pair.b).getPixels();
        for (int i = 0; i < alpha.length; ++i) {
            alpha[i] = alpha[i] / 255.0f;
        }
        return pair;
    }

    public static class BlockMatchResults
    implements Serializable {
        public Collection<? extends Point> v1;
        public Collection<? extends Point> v2;
        public final Collection<PointMatch> pm12;
        public final Collection<PointMatch> pm21;
        public final boolean layer1Fixed;
        public final boolean layer2Fixed;
        public final Triple<Integer, Integer, AbstractModel<?>> pair;

        public BlockMatchResults(Collection<? extends Point> v1, Collection<? extends Point> v2, Collection<PointMatch> pm12, Collection<PointMatch> pm21, boolean layer1Fixed, boolean layer2Fixed, Triple<Integer, Integer, AbstractModel<?>> pair) {
            this.v1 = v1;
            this.v2 = v2;
            this.pm12 = pm12;
            this.pm21 = pm21;
            this.layer1Fixed = layer1Fixed;
            this.layer2Fixed = layer2Fixed;
            this.pair = pair;
        }
    }
}

