/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.CacheRemover;
import net.imglib2.cache.img.AccessIo;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;

public class DiskCellCache<A>
implements CacheRemover<Long, Cell<A>, A>,
CacheLoader<Long, Cell<A>> {
    private final Path blockcache;
    private final CellGrid grid;
    private final int n;
    private final Fraction entitiesPerPixel;
    private final AccessIo<A> accessIo;
    private final CacheLoader<Long, Cell<A>> backingLoader;
    static DeleteTempFilesHook deleteTempFilesHook = null;

    public DiskCellCache(Path blockcache, CellGrid grid, CacheLoader<Long, Cell<A>> backingLoader, AccessIo<A> accessIo, Fraction entitiesPerPixel) {
        this.blockcache = blockcache;
        this.grid = grid;
        this.n = grid.numDimensions();
        this.entitiesPerPixel = entitiesPerPixel;
        this.accessIo = accessIo;
        this.backingLoader = backingLoader;
    }

    private String blockname(long index) {
        return String.format("%s/%d", this.blockcache, index);
    }

    @Override
    public Cell<A> get(Long key) throws Exception {
        long index = key;
        String filename = this.blockname(index);
        if (new File(filename).exists()) {
            long[] cellMin = new long[this.n];
            CellGrid.CellDimensionsAndSteps dimsAndSteps = this.grid.getCellDimensions(index, cellMin);
            long numEntities = this.entitiesPerPixel.mulCeil((long)dimsAndSteps.numPixels());
            long bytesize = numEntities * (long)this.accessIo.getBytesPerElement();
            try (RandomAccessFile mmFile = new RandomAccessFile(filename, "r");){
                MappedByteBuffer in = mmFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, bytesize);
                A access = this.accessIo.load(in, (int)numEntities);
                Cell cell = new Cell(dimsAndSteps, cellMin, access);
                return cell;
            }
        }
        return this.backingLoader.get(key);
    }

    @Override
    public A extract(Cell<A> value) {
        return (A)value.getData();
    }

    @Override
    public Cell<A> reconstruct(Long key, A valueData) {
        long index = key;
        long[] cellMin = new long[this.n];
        CellGrid.CellDimensionsAndSteps dimsAndSteps = this.grid.getCellDimensions(index, cellMin);
        return new Cell(dimsAndSteps, cellMin, valueData);
    }

    @Override
    public void onRemoval(Long key, A valueData) {
        long index = key;
        String filename = this.blockname(index);
        long[] cellMin = new long[this.n];
        int[] cellDims = new int[this.n];
        this.grid.getCellDimensions(index, cellMin, cellDims);
        long blocksize = this.entitiesPerPixel.mulCeil(Intervals.numElements((int[])cellDims));
        long bytesize = blocksize * (long)this.accessIo.getBytesPerElement();
        try (RandomAccessFile mmFile = new RandomAccessFile(filename, "rw");){
            MappedByteBuffer out = mmFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, bytesize);
            this.accessIo.save(valueData, out, (int)blocksize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> persist(Long key, A valueData) {
        this.onRemoval(key, valueData);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void invalidate(Long key) {
        try {
            Files.deleteIfExists(Paths.get(this.blockname(key), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateIf(long parallelismThreshold, final Predicate<Long> condition) {
        try {
            Files.walkFileTree(this.blockcache, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        long key = Long.parseLong(file.getFileName().toString());
                        if (condition.test(key)) {
                            Files.delete(file);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        try {
            Files.walkFileTree(this.blockcache, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void addDeleteHook(Path path) {
        if (deleteTempFilesHook == null) {
            deleteTempFilesHook = new DeleteTempFilesHook();
            Runtime.getRuntime().addShutdownHook(deleteTempFilesHook);
        }
        deleteTempFilesHook.add(path);
    }

    public static Path createTempDirectory(Path dir, String prefix, boolean deleteOnExit) throws IOException {
        Path tmp = Files.createTempDirectory(dir, prefix, new FileAttribute[0]);
        if (deleteOnExit) {
            DiskCellCache.addDeleteHook(tmp);
        }
        return tmp;
    }

    public static Path createTempDirectory(String prefix, boolean deleteOnExit) throws IOException {
        Path tmp = Files.createTempDirectory(prefix, new FileAttribute[0]);
        if (deleteOnExit) {
            DiskCellCache.addDeleteHook(tmp);
        }
        return tmp;
    }

    static class DeleteTempFilesHook
    extends Thread {
        private final ArrayList<Path> tempPaths = new ArrayList();

        DeleteTempFilesHook() {
        }

        public void add(Path path) {
            this.tempPaths.add(path);
        }

        @Override
        public void run() {
            for (Path path : this.tempPaths) {
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

