/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import java.util.Random;
import net.imglib2.type.numeric.ARGBType;

public class ColorGenerator {
    private static final int[] PREDEFINED_COLORS = new int[]{ARGBType.rgba((int)255, (int)0, (int)255, (int)255), ARGBType.rgba((int)0, (int)255, (int)0, (int)255), ARGBType.rgba((int)0, (int)0, (int)255, (int)255), ARGBType.rgba((int)255, (int)0, (int)0, (int)255), ARGBType.rgba((int)255, (int)255, (int)0, (int)255), ARGBType.rgba((int)0, (int)255, (int)255, (int)255)};

    public static ARGBType[] getColors(int numChannels) {
        assert (numChannels >= 0);
        if (numChannels <= 0) {
            return new ARGBType[0];
        }
        if (numChannels == 1) {
            return new ARGBType[]{new ARGBType(-1)};
        }
        ARGBType[] colors = new ARGBType[numChannels];
        Random rnd = null;
        for (int c = 0; c < numChannels; ++c) {
            if (c < PREDEFINED_COLORS.length) {
                colors[c] = new ARGBType(PREDEFINED_COLORS[c]);
                continue;
            }
            if (rnd == null) {
                rnd = new Random();
            }
            colors[c] = new ARGBType(ARGBType.rgba((int)(rnd.nextInt(128) << 1), (int)(rnd.nextInt(128) << 1), (int)(rnd.nextInt(128) << 1), (int)255));
        }
        return colors;
    }
}

