/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedLineArrayRetained;
import org.jogamp.java3d.IndexedLineStripArrayRetained;
import org.jogamp.java3d.IndexedPointArrayRetained;
import org.jogamp.java3d.IndexedQuadArrayRetained;
import org.jogamp.java3d.IndexedTriangleArrayRetained;
import org.jogamp.java3d.IndexedTriangleFanArrayRetained;
import org.jogamp.java3d.IndexedTriangleStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineArrayRetained;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.PointArrayRetained;
import org.jogamp.java3d.QuadArrayRetained;
import org.jogamp.java3d.SceneGraphObjectRetained;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TriangleArrayRetained;
import org.jogamp.java3d.TriangleFanArrayRetained;
import org.jogamp.java3d.TriangleStripArrayRetained;
import org.jogamp.vecmath.Point3d;

class Shape3DCompileRetained
extends Shape3DRetained {
    int numShapes = 0;
    ArrayList<ArrayList<Geometry>> geometryInfo = null;
    Object[] srcList = null;

    Shape3DCompileRetained(Shape3DRetained[] shapes, int nShapes, int compileFlags) {
        int i;
        ArrayList[] mergedList = new ArrayList[15];
        ArrayList[] separateList = new ArrayList[15];
        this.numShapes = nShapes;
        this.srcList = new Object[nShapes];
        if (nShapes > 0) {
            this.boundsAutoCompute = shapes[0].boundsAutoCompute;
            this.source = shapes[0].source;
        }
        this.geometryList.remove(0);
        this.boundsAutoCompute = shapes[0].boundsAutoCompute;
        this.isPickable = shapes[0].isPickable;
        this.isCollidable = shapes[0].isCollidable;
        this.appearanceOverrideEnable = shapes[0].appearanceOverrideEnable;
        this.appearance = shapes[0].appearance;
        this.collisionBound = shapes[0].collisionBound;
        this.localBounds = shapes[0].localBounds;
        if ((compileFlags & 2) != 0) {
            this.geometryInfo = new ArrayList();
        }
        for (i = 0; i < nShapes; ++i) {
            int j;
            Shape3DRetained shape = shapes[i];
            ((Shape3D)shape.source).id = i;
            shape.source.retained = this;
            this.srcList[i] = shape.source;
            for (j = 0; j < shape.geometryList.size(); ++j) {
                GeometryArrayRetained geo = (GeometryArrayRetained)shape.geometryList.get(j);
                if (geo == null) continue;
                if (shape.willRemainOpaque(geo.geoType) && geo.isMergeable()) {
                    if (mergedList[geo.geoType] == null) {
                        mergedList[geo.geoType] = new ArrayList();
                    }
                    mergedList[geo.geoType].add(geo);
                    continue;
                }
                if (separateList[geo.geoType] == null) {
                    separateList[geo.geoType] = new ArrayList();
                }
                separateList[geo.geoType].add(geo);
            }
            if ((compileFlags & 2) == 0) continue;
            ArrayList<Geometry> sList = new ArrayList<Geometry>();
            for (j = 0; j < shape.geometryList.size(); ++j) {
                GeometryRetained g = shape.geometryList.get(j);
                if (g != null) {
                    sList.add((Geometry)g.source);
                    continue;
                }
                sList.add(null);
            }
            this.geometryInfo.add(sList);
        }
        block19: for (i = 1; i <= 14; ++i) {
            switch (i) {
                case 1: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new QuadArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 2: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new TriangleArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 3: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new PointArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 4: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new LineArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 5: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new TriangleStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 6: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new TriangleFanArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 7: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new LineStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 8: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedQuadArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 9: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedTriangleArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 10: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedPointArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 11: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedLineArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 12: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedTriangleStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 13: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedTriangleFanArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 14: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedLineStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                }
            }
        }
    }

    private void addMergedList(ArrayList<GeometryArrayRetained> glist, GeometryArrayRetained cgeo) {
        cgeo.setCompiled(glist);
        this.geometryList.add(cgeo);
        cgeo.setSource(((SceneGraphObjectRetained)glist.get((int)0)).source);
    }

    private void addSeparateList(ArrayList<GeometryArrayRetained> glist) {
        if (glist == null) {
            return;
        }
        for (int k = 0; k < glist.size(); ++k) {
            this.geometryList.add(glist.get(k));
        }
    }

    @Override
    Bounds getCollisionBounds(int childIndex) {
        return this.collisionBound;
    }

    @Override
    int numGeometries(int childIndex) {
        return this.geometryInfo.get(childIndex).size();
    }

    @Override
    Geometry getGeometry(int i, int childIndex) {
        return this.geometryInfo.get(childIndex).get(i);
    }

    @Override
    Iterator<Geometry> getAllGeometries(int childIndex) {
        ArrayList<Geometry> geoInfo = this.geometryInfo.get(childIndex);
        Vector<Geometry> geomList = new Vector<Geometry>();
        for (int i = 0; i < geoInfo.size(); ++i) {
            geomList.add(geoInfo.get(i));
        }
        return geomList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bounds getBounds(int childIndex) {
        if (!this.boundsAutoCompute) {
            return super.getBounds();
        }
        ArrayList<Geometry> glist = this.geometryInfo.get(childIndex);
        if (glist == null) {
            return null;
        }
        BoundingBox bbox = new BoundingBox((Bounds)null);
        for (int i = 0; i < glist.size(); ++i) {
            Geometry g = glist.get(i);
            if (g == null) continue;
            GeometryRetained geometry = (GeometryRetained)g.retained;
            if (geometry.geoType == -1) continue;
            geometry.computeBoundingBox();
            BoundingBox boundingBox = geometry.geoBounds;
            synchronized (boundingBox) {
                bbox.combine(geometry.geoBounds);
                continue;
            }
        }
        return bbox;
    }

    @Override
    boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        PickInfo pickInfo = new PickInfo();
        Transform3D localToVworld = path.getTransform();
        if (localToVworld == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        pickInfo.setLocalToVWorldRef(localToVworld);
        Shape3D shape = (Shape3D)path.getObject();
        ArrayList<Geometry> glist = this.geometryInfo.get(shape.id);
        if (dist == null) {
            return this.intersect(pickInfo, pickShape, 0, glist);
        }
        int flags = 16;
        if (this.intersect(pickInfo, pickShape, flags, glist)) {
            dist[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int flags, ArrayList<Geometry> geometryList) {
        Transform3D localToVworld = pickInfo.getLocalToVWorldRef();
        Transform3D t3d = new Transform3D();
        t3d.invert(localToVworld);
        PickShape newPS = pickShape.transform(t3d);
        int geomListSize = geometryList.size();
        if ((flags & 8) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0 && (flags & 0x40) == 0) {
            for (int i = 0; i < geomListSize; ++i) {
                GeometryRetained geometry = (GeometryRetained)geometryList.get((int)i).retained;
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, null, 0, null, null, 0)) continue;
                return true;
            }
        } else {
            double minDist = Double.POSITIVE_INFINITY;
            Point3d closestIPnt = new Point3d();
            Point3d iPnt = new Point3d();
            Point3d iPntVW = new Point3d();
            for (int i = 0; i < geomListSize; ++i) {
                GeometryRetained geometry = (GeometryRetained)geometryList.get((int)i).retained;
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, pickInfo, flags, iPnt, geometry, i)) continue;
                iPntVW.set(iPnt);
                localToVworld.transform(iPntVW);
                double distance = pickShape.distance(iPntVW);
                if (!(minDist > distance)) continue;
                minDist = distance;
                closestIPnt.set(iPnt);
            }
            if (minDist < Double.POSITIVE_INFINITY) {
                if ((flags & 0x10) != 0) {
                    pickInfo.setClosestDistance(minDist);
                }
                if ((flags & 8) != 0) {
                    pickInfo.setClosestIntersectionPoint(closestIPnt);
                }
                return true;
            }
        }
        return false;
    }
}

