/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import ij.ImagePlus;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.ScaleAndTranslation;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.AbstractN5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;

public class ImagePlusMetadataTemplate
extends AbstractN5DatasetMetadata
implements ImageplusMetadata<ImagePlusMetadataTemplate>,
SpatialMetadata {
    public int numDims;
    public int numSpatialDims;
    public int numChannels;
    public int numFrames;
    public int numSlices;
    public String name;
    public double xResolution;
    public double yResolution;
    public double zResolution;
    public double tResolution;
    public double xOrigin;
    public double yOrigin;
    public double zOrigin;
    public double tOrigin;
    public String xUnit;
    public String yUnit;
    public String zUnit;
    public String tUnit;
    public String globalUnit;
    public Map<String, String> otherMetadata;

    public ImagePlusMetadataTemplate() {
        super("", null);
    }

    public ImagePlusMetadataTemplate(String path, ImagePlus imp) {
        this(path, imp, null);
    }

    public ImagePlusMetadataTemplate(String path, DatasetAttributes attributes) {
        this(path, null, attributes);
    }

    public ImagePlusMetadataTemplate(String path, ImagePlus imp, DatasetAttributes attributes) {
        super(path, attributes);
        this.numChannels = imp.getNChannels();
        this.numFrames = imp.getNFrames();
        this.numSlices = imp.getNSlices();
        this.numDims = imp.getNDimensions();
        this.numSpatialDims = this.numSlices > 1 ? 3 : 2;
        this.name = imp.getTitle();
        this.xResolution = imp.getCalibration().pixelWidth;
        this.yResolution = imp.getCalibration().pixelHeight;
        this.zResolution = imp.getCalibration().pixelDepth;
        this.tResolution = imp.getCalibration().frameInterval;
        this.xOrigin = imp.getCalibration().xOrigin;
        this.yOrigin = imp.getCalibration().yOrigin;
        this.zOrigin = imp.getCalibration().zOrigin;
        this.tOrigin = 0.0;
        this.xUnit = imp.getCalibration().getXUnit();
        this.yUnit = imp.getCalibration().getYUnit();
        this.zUnit = imp.getCalibration().getZUnit();
        this.tUnit = imp.getCalibration().getTimeUnit();
        this.globalUnit = imp.getCalibration().getUnit();
        this.otherMetadata = new HashMap<String, String>();
        Properties props = imp.getProperties();
        if (props != null) {
            for (Object k : props.keySet()) {
                this.otherMetadata.put(k.toString(), props.get(k).toString());
            }
        }
    }

    @Override
    public void writeMetadata(ImagePlusMetadataTemplate t, ImagePlus ip) {
        ip.setTitle(t.name);
        ip.setDimensions(this.numChannels, this.numSlices, this.numFrames);
        ip.getCalibration().pixelWidth = t.xResolution;
        ip.getCalibration().pixelDepth = t.yResolution;
        ip.getCalibration().pixelHeight = t.zResolution;
        ip.getCalibration().xOrigin = t.xOrigin;
        ip.getCalibration().yOrigin = t.yOrigin;
        ip.getCalibration().zOrigin = t.zOrigin;
        ip.getCalibration().setXUnit(t.xUnit);
        ip.getCalibration().setYUnit(t.yUnit);
        ip.getCalibration().setZUnit(t.zUnit);
        ip.getCalibration().setUnit(t.globalUnit);
        ip.getCalibration().setTimeUnit(t.tUnit);
        Properties props = ip.getProperties();
        if (t.otherMetadata != null) {
            for (String k : t.otherMetadata.keySet()) {
                props.put(k, t.otherMetadata.get(k));
            }
        }
    }

    @Override
    public ImagePlusMetadataTemplate readMetadata(ImagePlus ip) throws IOException {
        return new ImagePlusMetadataTemplate("", ip, null);
    }

    public static ImagePlusMetadataTemplate readMetadataStatic(ImagePlus ip) throws IOException {
        return new ImagePlusMetadataTemplate("", ip, null);
    }

    public AffineGet spatialTransform() {
        if (this.numSpatialDims == 3) {
            return new ScaleAndTranslation(new double[]{this.xResolution, this.yResolution, this.zResolution}, new double[]{this.xOrigin, this.yOrigin, this.zOrigin});
        }
        return new ScaleAndTranslation(new double[]{this.xResolution, this.yResolution}, new double[]{this.xOrigin, this.yOrigin});
    }

    public String unit() {
        return this.globalUnit;
    }
}

