/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

public enum DataType {
    CHAR,
    UCHAR,
    SHORT,
    USHORT,
    INT,
    UINT,
    FLOAT,
    DOUBLE;


    static DataType parse(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("typeName must not be null.");
        }
        if ("char".equals(typeName)) {
            return CHAR;
        }
        if ("uchar".equals(typeName)) {
            return UCHAR;
        }
        if ("short".equals(typeName)) {
            return SHORT;
        }
        if ("ushort".equals(typeName)) {
            return USHORT;
        }
        if ("int".equals(typeName)) {
            return INT;
        }
        if ("uint".equals(typeName)) {
            return UINT;
        }
        if ("float".equals(typeName)) {
            return FLOAT;
        }
        if ("double".equals(typeName)) {
            return DOUBLE;
        }
        if ("int8".equals(typeName)) {
            return CHAR;
        }
        if ("uint8".equals(typeName)) {
            return UCHAR;
        }
        if ("int16".equals(typeName)) {
            return SHORT;
        }
        if ("uint16".equals(typeName)) {
            return USHORT;
        }
        if ("int32".equals(typeName)) {
            return INT;
        }
        if ("uint32".equals(typeName)) {
            return UINT;
        }
        if ("float32".equals(typeName)) {
            return FLOAT;
        }
        if ("float64".equals(typeName)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a valid PLY data type.");
    }
}

