/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class SequenceView
extends TiledView {
    Sampling _sx;
    float[] _f;
    private Color _color = null;
    private Zero _zero = Zero.ALWAYS;

    public SequenceView(float[] f) {
        this.set(f);
    }

    public SequenceView(Sampling sx, float[] f) {
        this.set(sx, f);
    }

    public void set(float[] f) {
        this.set(new Sampling(f.length), f);
    }

    public void set(Sampling sx, float[] f) {
        Check.argument(sx.getCount() == f.length, "sx count equals length of f");
        this._sx = sx;
        this._f = ArrayMath.copy(f);
        this.updateBestProjectors();
        this.repaint();
    }

    public Sampling getSampling() {
        return this._sx;
    }

    public float[] getFunction() {
        return ArrayMath.copy(this._f);
    }

    public void setZero(Zero zero) {
        if (this._zero != zero) {
            this._zero = zero;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setColor(Color color) {
        if (!this.equalColors(this._color, color)) {
            this._color = color;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int nx = this._sx.getCount();
        double dx = this._sx.getDelta();
        double fx = this._sx.getFirst();
        double lx = this._sx.getLast();
        Projector bhp = this.getBestHorizontalProjector();
        Projector bvp = this.getBestVerticalProjector();
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        double rbx = this.ballRadiusX() * hp.getScaleRatio(bhp);
        double rby = this.ballRadiusY() * vp.getScaleRatio(bvp);
        int rx = ts.width(rbx);
        int ry = ts.height(rby);
        int rb = ArrayMath.max(0, ArrayMath.min(rx, ry) - 1);
        if (this._color != null) {
            g2d.setColor(this._color);
        }
        int xf = ts.x(hp.u(fx));
        int xl = ts.x(hp.u(lx));
        int x1 = ArrayMath.min(xf, xl) - rb;
        int x2 = ArrayMath.max(xf, xl) + rb;
        int y0 = ts.y(vp.u(0.0));
        g2d.drawLine(x1, y0, x2, y0);
        for (int ix = 0; ix < nx; ++ix) {
            double xi = fx + (double)ix * dx;
            double fi = this._f[ix];
            int x = ts.x(hp.u(xi));
            int y = ts.y(vp.u(fi));
            g2d.drawLine(x, y0, x, y);
            g2d.fillOval(x - rb, y - rb, 1 + 2 * rb, 1 + 2 * rb);
        }
    }

    private void updateBestProjectors() {
        double xmax;
        double xl;
        double nx = this._sx.getCount();
        double xf = this._sx.getFirst();
        double xmin = ArrayMath.min(xf, xl = this._sx.getLast());
        if (xmin == (xmax = ArrayMath.max(xf, xl))) {
            double tiny = ArrayMath.max(1.0, (double)ArrayMath.ulp(1.0f) * ArrayMath.abs(xmin));
            xmin -= tiny;
            xmax += tiny;
        }
        double fmin = this._f[0];
        double fmax = this._f[0];
        int ix = 0;
        while ((double)ix < nx) {
            if ((double)this._f[ix] < fmin) {
                fmin = this._f[ix];
            }
            if ((double)this._f[ix] > fmax) {
                fmax = this._f[ix];
            }
            ++ix;
        }
        if (this._zero == Zero.ALWAYS) {
            fmin = ArrayMath.min(0.0, fmin);
            fmax = ArrayMath.max(0.0, fmax);
        } else if (this._zero == Zero.MIDDLE) {
            fmax = ArrayMath.max(ArrayMath.abs(fmin), ArrayMath.abs(fmax));
            fmin = -fmax;
        }
        if (fmin == fmax) {
            double tiny = ArrayMath.max(1.0, (double)ArrayMath.ulp(1.0f) * ArrayMath.abs(fmin));
            fmin -= tiny;
            fmax += tiny;
        }
        double rbx = this.ballRadiusX();
        double rby = this.ballRadiusY();
        Projector bhp = new Projector(xmin, xmax, rbx, 1.0 - rbx);
        Projector bvp = new Projector(fmax, fmin, rby, 1.0 - rby);
        this.setBestProjectors(bhp, bvp);
    }

    private double ballRadiusX() {
        double nx = this._sx.getCount();
        return 0.9 / (2.0 * nx);
    }

    private double ballRadiusY() {
        return 0.04;
    }

    private boolean equalColors(Color ca, Color cb) {
        return ca == null ? cb == null : ca.equals(cb);
    }

    public static enum Zero {
        NORMAL,
        ALWAYS,
        MIDDLE;

    }
}

