/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Vector3;

public class Segment {
    private static final double TINY = 2.220446049250313E-13;
    private Point3 _a;
    private Point3 _b;
    private Vector3 _d;

    public Segment(Point3 a, Point3 b) {
        this._a = new Point3(a);
        this._b = new Point3(b);
        this._d = this._b.minus(this._a);
    }

    public Segment(Segment ls) {
        this(ls._a, ls._b);
    }

    public Point3 getA() {
        return new Point3(this._a);
    }

    public Point3 getB() {
        return new Point3(this._b);
    }

    public double length() {
        return this._a.distanceTo(this._b);
    }

    public void transform(Matrix44 m) {
        this._a = m.times(this._a);
        this._b = m.times(this._b);
        this._d = this._b.minus(this._a);
    }

    public Point3 intersectWithTriangle(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc) {
        double xba = xb - xa;
        double yd = this._d.y;
        double zca = zc - za;
        double zd = this._d.z;
        double yca = yc - ya;
        double xp = yd * zca - zd * yca;
        double yba = yb - ya;
        double xca = xc - xa;
        double xd = this._d.x;
        double yp = zd * xca - xd * zca;
        double zba = zb - za;
        double zp = xd * yca - yd * xca;
        double a = xba * xp + yba * yp + zba * zp;
        if (-2.220446049250313E-13 < a && a < 2.220446049250313E-13) {
            return null;
        }
        double f = 1.0 / a;
        double xaa = this._a.x - xa;
        double yaa = this._a.y - ya;
        double zaa = this._a.z - za;
        double u = f * (xaa * xp + yaa * yp + zaa * zp);
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        double xq = yaa * zba - zaa * yba;
        double yq = zaa * xba - xaa * zba;
        double zq = xaa * yba - yaa * xba;
        double v = f * (xd * xq + yd * yq + zd * zq);
        if (v < 0.0 || u + v > 1.0) {
            return null;
        }
        double t = f * (xca * xq + yca * yq + zca * zq);
        if (t < 0.0 || 1.0 < t) {
            return null;
        }
        double w = 1.0 - u - v;
        double xi = w * xa + u * xb + v * xc;
        double yi = w * ya + u * yb + v * yc;
        double zi = w * za + u * zb + v * zc;
        return new Point3(xi, yi, zi);
    }
}

