/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.utils;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.renjin.sexp.DoubleVector;
import org.renjin.utils.ColumnPrinter;

public class DoublePrinter
implements ColumnPrinter {
    private final PrintWriter writer;
    private final DoubleVector vector;
    private String naSymbol;
    private final DecimalFormat format;

    public DoublePrinter(PrintWriter writer, DoubleVector vector, String decimal, String naSymbol) {
        this.writer = writer;
        this.vector = vector;
        this.naSymbol = naSymbol;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(decimal.charAt(0));
        this.format = new DecimalFormat();
        this.format.setGroupingUsed(false);
        this.format.setDecimalFormatSymbols(symbols);
        this.format.setMinimumIntegerDigits(0);
        this.format.setMaximumFractionDigits(6);
    }

    @Override
    public void print(int rowNumber) {
        double value = this.vector.getElementAsDouble(rowNumber);
        if (DoubleVector.isNA((double)value)) {
            this.writer.write(this.naSymbol);
        } else {
            this.writer.write(this.format.format(value));
        }
    }
}

