/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ui;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import ij.Prefs;
import ij.io.DirectoryChooser;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;

public class RootNodeConfigDialog
implements ActionListener {
    private final Hashtable<String, String> paramMap;
    private final Hashtable<String, TextField> fieldMap;
    private final String prefRoot;
    private final Frame rootConfigFrame;
    private final Panel panel;
    private final Cluster cluster;
    private final AtomicBoolean isConfigured;

    public RootNodeConfigDialog(Cluster cluster, AtomicBoolean configured) {
        GridBagConstraints gbc = new GridBagConstraints();
        Button execRootButton = new Button("Select exec root...");
        Button fileRootButton = new Button("Select file root...");
        Button okButton = new Button("OK");
        Button cancelButton = new Button("Cancel");
        boolean useDefault = cluster.getState() == Cluster.ClusterState.INSTANTIATED;
        this.cluster = cluster;
        this.isConfigured = configured;
        this.panel = new Panel();
        this.paramMap = new Hashtable();
        this.fieldMap = new Hashtable();
        this.prefRoot = "FijiArchipelago";
        this.rootConfigFrame = new Frame("Root Node Configuration");
        if (useDefault) {
            FijiArchipelago.debug("RootNodeConfigDialog: Using default parameters");
        } else {
            FijiArchipelago.debug("RootNodeConfigDialog: Using configured parameters");
        }
        this.setEntry("execRoot", FijiArchipelago.getExecRoot(), useDefault);
        this.setEntry("fileRoot", FijiArchipelago.getFileRoot(), useDefault);
        this.setEntry("execRootRemote", cluster.getParametersFactory().getDefaultExecRoot(), useDefault);
        this.setEntry("fileRootRemote", cluster.getParametersFactory().getDefaultFileRoot(), useDefault);
        this.setEntry("username", cluster.getParametersFactory().getDefaultUser(), useDefault);
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)new Label("Root Node Configuration"), gbc);
        this.addField("\tLocal Exec Root", "execRoot", gbc, execRootButton);
        this.addField("\tLocal File Root", "fileRoot", gbc, fileRootButton);
        this.addField("\tUser Name", "username", gbc, null);
        this.addField("\tDefault Client Exec Root", "execRootRemote", gbc, null);
        this.addField("\tDefault Client File Root", "fileRootRemote", gbc, null);
        gbc.gridwidth = -1;
        this.panel.add((Component)okButton, gbc);
        gbc.gridwidth = 0;
        this.panel.add((Component)cancelButton, gbc);
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        fileRootButton.addActionListener(this);
        execRootButton.addActionListener(this);
        okButton.setActionCommand("ok");
        cancelButton.setActionCommand("cancel");
        fileRootButton.setActionCommand("fileRoot");
        execRootButton.setActionCommand("execRoot");
        this.rootConfigFrame.add(this.panel);
        this.panel.setVisible(true);
        this.rootConfigFrame.setPreferredSize(new Dimension(768, 384));
        this.rootConfigFrame.setMinimumSize(new Dimension(768, 384));
        this.panel.validate();
        this.rootConfigFrame.validate();
        this.rootConfigFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RootNodeConfigDialog.this.rootConfigFrame.setVisible(false);
                RootNodeConfigDialog.this.rootConfigFrame.removeAll();
            }
        });
    }

    public void show() {
        FijiArchipelago.debug("Showing config");
        if (!this.rootConfigFrame.isVisible()) {
            FijiArchipelago.debug("Setting frame visible");
            this.rootConfigFrame.validate();
            this.rootConfigFrame.setVisible(true);
        }
    }

    public boolean isVisible() {
        return this.rootConfigFrame.isVisible();
    }

    private void syncMap() {
        for (String key : this.paramMap.keySet()) {
            String value = this.fieldMap.get(key).getText();
            this.paramMap.put(key, value);
            Prefs.set((String)(this.prefRoot + "." + key), (String)value);
        }
        Prefs.savePreferences();
    }

    public String getStringValue(String key) {
        return this.paramMap.get(key);
    }

    private void addField(String label, String key, GridBagConstraints gbc, Button b) {
        int buttonWidth = b == null ? 0 : 128;
        int h = 32;
        int lw = 256;
        int fw = 384;
        Label l = new Label(label);
        TextField tf = new TextField(this.paramMap.get(key));
        this.fieldMap.put(key, tf);
        l.setMinimumSize(new Dimension(256, 32));
        l.setSize(new Dimension(256, 32));
        tf.setMinimumSize(new Dimension(384 - buttonWidth, 32));
        tf.setSize(new Dimension(384 - buttonWidth, 32));
        gbc.gridwidth = -1;
        this.panel.add((Component)l, gbc);
        if (b == null) {
            gbc.gridwidth = 0;
        }
        this.panel.add((Component)tf, gbc);
        if (b != null) {
            b.setMinimumSize(new Dimension(buttonWidth, 32));
            b.setSize(new Dimension(buttonWidth, 32));
            gbc.gridwidth = 0;
            this.panel.add((Component)b, gbc);
        }
    }

    private void setEntry(String key, String dValue, boolean useDefault) {
        String value = useDefault ? Prefs.get((String)(this.prefRoot + "." + key), (String)dValue) : dValue;
        this.paramMap.put(key, value);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DirectoryChooser dc;
        String command = actionEvent.getActionCommand();
        if (command.equals("ok")) {
            this.rootConfigFrame.setVisible(false);
            this.rootConfigFrame.removeAll();
            this.syncMap();
            this.isConfigured.set(Cluster.configureCluster(this.cluster, this.getStringValue("execRootRemote"), this.getStringValue("fileRootRemote"), this.getStringValue("execRoot"), this.getStringValue("fileRoot"), this.getStringValue("username")));
        } else if (command.equals("cancel")) {
            this.rootConfigFrame.setVisible(false);
        } else if (command.equals("fileRoot")) {
            DirectoryChooser dc2 = new DirectoryChooser("Choose File Root");
            if (dc2.getDirectory() != null) {
                this.fieldMap.get("fileRoot").setText(dc2.getDirectory());
            }
        } else if (command.equals("execRoot") && (dc = new DirectoryChooser("Choose Exec Root")).getDirectory() != null) {
            this.fieldMap.get("execRoot").setText(dc.getDirectory());
        }
    }
}

