/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

public class Normal {
    private static final double SQRTPI = 1.772453850905516;
    private static final double UPPERLIMIT = 20.0;
    private static final double P10 = 242.66795523053176;
    private static final double P11 = 21.979261618294153;
    private static final double P12 = 6.996383488619135;
    private static final double P13 = -0.035609843701815386;
    private static final double Q10 = 215.0588758698612;
    private static final double Q11 = 91.1649054045149;
    private static final double Q12 = 15.082797630407788;
    private static final double Q13 = 1.0;
    private static final double P20 = 300.4592610201616;
    private static final double P21 = 451.9189537118729;
    private static final double P22 = 339.3208167343437;
    private static final double P23 = 152.9892850469404;
    private static final double P24 = 43.162227222056735;
    private static final double P25 = 7.2117582508830935;
    private static final double P26 = 0.564195517478974;
    private static final double P27 = -1.368648573827167E-7;
    private static final double Q20 = 300.4592609569833;
    private static final double Q21 = 790.9509253278981;
    private static final double Q22 = 931.3540948506096;
    private static final double Q23 = 638.9802644656312;
    private static final double Q24 = 277.58544474398764;
    private static final double Q25 = 77.00015293522948;
    private static final double Q26 = 12.782727319629423;
    private static final double Q27 = 1.0;
    private static final double P30 = -0.002996107077035422;
    private static final double P31 = -0.04947309106232507;
    private static final double P32 = -0.22695659353968692;
    private static final double P33 = -0.2786613086096478;
    private static final double P34 = -0.02231924597341847;
    private static final double Q30 = 0.010620923052846792;
    private static final double Q31 = 0.19130892610782985;
    private static final double Q32 = 1.051675107067932;
    private static final double Q33 = 1.9873320181713525;
    private static final double Q34 = 1.0;
    private static final double SQRT2 = 1.4142135623730951;

    public static double getNormal(double x) {
        double phi;
        int sn;
        if (x < -20.0) {
            return 0.0;
        }
        if (x > 20.0) {
            return 1.0;
        }
        double y = x / 1.4142135623730951;
        if (y < 0.0) {
            y = -y;
            sn = -1;
        } else {
            sn = 1;
        }
        double y2 = y * y;
        double y4 = y2 * y2;
        double y6 = y4 * y2;
        if (y < 0.46875) {
            double R1 = 242.66795523053176 + 21.979261618294153 * y2 + 6.996383488619135 * y4 + -0.035609843701815386 * y6;
            double R2 = 215.0588758698612 + 91.1649054045149 * y2 + 15.082797630407788 * y4 + 1.0 * y6;
            double erf = y * R1 / R2;
            phi = sn == 1 ? 0.5 + 0.5 * erf : 0.5 - 0.5 * erf;
        } else if (y < 4.0) {
            double y3 = y2 * y;
            double y5 = y4 * y;
            double y7 = y6 * y;
            double R1 = 300.4592610201616 + 451.9189537118729 * y + 339.3208167343437 * y2 + 152.9892850469404 * y3 + 43.162227222056735 * y4 + 7.2117582508830935 * y5 + 0.564195517478974 * y6 + -1.368648573827167E-7 * y7;
            double R2 = 300.4592609569833 + 790.9509253278981 * y + 931.3540948506096 * y2 + 638.9802644656312 * y3 + 277.58544474398764 * y4 + 77.00015293522948 * y5 + 12.782727319629423 * y6 + 1.0 * y7;
            double erfc = Math.exp(-y2) * R1 / R2;
            phi = sn == 1 ? 1.0 - 0.5 * erfc : 0.5 * erfc;
        } else {
            double z = y4;
            double z2 = z * z;
            double z3 = z2 * z;
            double z4 = z2 * z2;
            double R1 = -0.002996107077035422 + -0.04947309106232507 * z + -0.22695659353968692 * z2 + -0.2786613086096478 * z3 + -0.02231924597341847 * z4;
            double R2 = 0.010620923052846792 + 0.19130892610782985 * z + 1.051675107067932 * z2 + 1.9873320181713525 * z3 + 1.0 * z4;
            double erfc = Math.exp(-y2) / y * (0.5641895835477563 + R1 / (R2 * y2));
            phi = sn == 1 ? 1.0 - 0.5 * erfc : 0.5 * erfc;
        }
        return phi;
    }
}

