/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.util.Map;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.ViewSetupAttributes;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;

public class ViewSetup
extends BasicViewSetup
implements Comparable<ViewSetup> {
    private Tile tile;
    private Channel channel;
    private Angle angle;
    private Illumination illumination;
    protected static String tileAttributeKey = ViewSetupAttributes.getNameForClass(Tile.class);
    protected static String channelAttributeKey = ViewSetupAttributes.getNameForClass(Channel.class);
    protected static String angleAttributeKey = ViewSetupAttributes.getNameForClass(Angle.class);
    protected static String illuminationAttributeKey = ViewSetupAttributes.getNameForClass(Illumination.class);

    public ViewSetup(int id, String name, Dimensions size, VoxelDimensions voxelSize, Tile tile, Channel channel, Angle angle, Illumination illumination) {
        super(id, name, size, voxelSize);
        this.setChannel(channel);
        this.setAngle(angle);
        this.setIllumination(illumination);
        this.setTile(tile);
    }

    public ViewSetup(int id, String name, Dimensions size, VoxelDimensions voxelSize, Channel channel, Angle angle, Illumination illumination) {
        super(id, name, size, voxelSize);
        this.setChannel(channel);
        this.setAngle(angle);
        this.setIllumination(illumination);
        this.setTile(new Tile(0));
    }

    @Override
    public int getId() {
        return super.getId();
    }

    @Override
    public boolean hasName() {
        return super.hasName();
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public boolean hasSize() {
        return super.hasSize();
    }

    @Override
    public Dimensions getSize() {
        return super.getSize();
    }

    @Override
    public void setSize(Dimensions size) {
        super.setSize(size);
    }

    @Override
    public boolean hasVoxelSize() {
        return super.hasVoxelSize();
    }

    @Override
    public VoxelDimensions getVoxelSize() {
        return super.getVoxelSize();
    }

    @Override
    public void setVoxelSize(VoxelDimensions voxelSize) {
        super.setVoxelSize(voxelSize);
    }

    public Tile getTile() {
        return this.tile;
    }

    protected void setTile(Tile tile) {
        this.tile = tile;
        this.getAttributes().put(tileAttributeKey, tile);
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void setChannel(Channel channel) {
        this.channel = channel;
        this.getAttributes().put(channelAttributeKey, channel);
    }

    public Angle getAngle() {
        return this.angle;
    }

    protected void setAngle(Angle angle) {
        this.angle = angle;
        this.getAttributes().put(angleAttributeKey, angle);
    }

    public Illumination getIllumination() {
        return this.illumination;
    }

    protected void setIllumination(Illumination illumination) {
        this.illumination = illumination;
        this.getAttributes().put(illuminationAttributeKey, illumination);
    }

    @Override
    public int compareTo(ViewSetup o) {
        return this.getId() - o.getId();
    }

    @Override
    protected void setAttributes(Map<String, Entity> attributes) {
        super.setAttributes(attributes);
        this.setTile((Tile)attributes.get(tileAttributeKey));
        this.setChannel((Channel)attributes.get(channelAttributeKey));
        this.setAngle((Angle)attributes.get(angleAttributeKey));
        this.setIllumination((Illumination)attributes.get(illuminationAttributeKey));
        if (this.getTile() == null) {
            this.setTile(new Tile(0));
        }
        if (this.getChannel() == null) {
            this.setChannel(new Channel(0));
        }
        if (this.getAngle() == null) {
            this.setAngle(new Angle(0));
        }
        if (this.getIllumination() == null) {
            this.setIllumination(new Illumination(0));
        }
    }

    ViewSetup() {
    }
}

