/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics;

import org.renjin.eval.Context;
import org.renjin.graphics.ColorPalette;
import org.renjin.graphics.GraphicsDevice;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class Color {
    private int value;
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = 255;
    public static final Color TRANSPARENT_WHITE = Color.fromRGBA(255, 255, 255, 0);
    public static final Color BLACK = Color.fromRGB(0, 0, 0);
    private static final NamedColor[] COLOR_DATABASE = new NamedColor[]{new NamedColor("white", Color.fromRGB(255, 255, 255)), new NamedColor("aliceblue", Color.fromRGB(240, 248, 255)), new NamedColor("antiquewhite", Color.fromRGB(250, 235, 215)), new NamedColor("antiquewhite1", Color.fromRGB(255, 239, 219)), new NamedColor("antiquewhite2", Color.fromRGB(238, 223, 204)), new NamedColor("antiquewhite3", Color.fromRGB(205, 192, 176)), new NamedColor("antiquewhite4", Color.fromRGB(139, 131, 120)), new NamedColor("aquamarine", Color.fromRGB(127, 255, 212)), new NamedColor("aquamarine1", Color.fromRGB(127, 255, 212)), new NamedColor("aquamarine2", Color.fromRGB(118, 238, 198)), new NamedColor("aquamarine3", Color.fromRGB(102, 205, 170)), new NamedColor("aquamarine4", Color.fromRGB(69, 139, 116)), new NamedColor("azure", Color.fromRGB(240, 255, 255)), new NamedColor("azure1", Color.fromRGB(240, 255, 255)), new NamedColor("azure2", Color.fromRGB(224, 238, 238)), new NamedColor("azure3", Color.fromRGB(193, 205, 205)), new NamedColor("azure4", Color.fromRGB(131, 139, 139)), new NamedColor("beige", Color.fromRGB(245, 245, 220)), new NamedColor("bisque", Color.fromRGB(255, 228, 196)), new NamedColor("bisque1", Color.fromRGB(255, 228, 196)), new NamedColor("bisque2", Color.fromRGB(238, 213, 183)), new NamedColor("bisque3", Color.fromRGB(205, 183, 158)), new NamedColor("bisque4", Color.fromRGB(139, 125, 107)), new NamedColor("black", Color.fromRGB(0, 0, 0)), new NamedColor("blanchedalmond", Color.fromRGB(255, 235, 205)), new NamedColor("blue", Color.fromRGB(0, 0, 255)), new NamedColor("blue1", Color.fromRGB(0, 0, 255)), new NamedColor("blue2", Color.fromRGB(0, 0, 238)), new NamedColor("blue3", Color.fromRGB(0, 0, 205)), new NamedColor("blue4", Color.fromRGB(0, 0, 139)), new NamedColor("blueviolet", Color.fromRGB(138, 43, 226)), new NamedColor("brown", Color.fromRGB(165, 42, 42)), new NamedColor("brown1", Color.fromRGB(255, 64, 64)), new NamedColor("brown2", Color.fromRGB(238, 59, 59)), new NamedColor("brown3", Color.fromRGB(205, 51, 51)), new NamedColor("brown4", Color.fromRGB(139, 35, 35)), new NamedColor("burlywood", Color.fromRGB(222, 184, 135)), new NamedColor("burlywood1", Color.fromRGB(255, 211, 155)), new NamedColor("burlywood2", Color.fromRGB(238, 197, 145)), new NamedColor("burlywood3", Color.fromRGB(205, 170, 125)), new NamedColor("burlywood4", Color.fromRGB(139, 115, 85)), new NamedColor("cadetblue", Color.fromRGB(95, 158, 160)), new NamedColor("cadetblue1", Color.fromRGB(152, 245, 255)), new NamedColor("cadetblue2", Color.fromRGB(142, 229, 238)), new NamedColor("cadetblue3", Color.fromRGB(122, 197, 205)), new NamedColor("cadetblue4", Color.fromRGB(83, 134, 139)), new NamedColor("chartreuse", Color.fromRGB(127, 255, 0)), new NamedColor("chartreuse1", Color.fromRGB(127, 255, 0)), new NamedColor("chartreuse2", Color.fromRGB(118, 238, 0)), new NamedColor("chartreuse3", Color.fromRGB(102, 205, 0)), new NamedColor("chartreuse4", Color.fromRGB(69, 139, 0)), new NamedColor("chocolate", Color.fromRGB(210, 105, 30)), new NamedColor("chocolate1", Color.fromRGB(255, 127, 36)), new NamedColor("chocolate2", Color.fromRGB(238, 118, 33)), new NamedColor("chocolate3", Color.fromRGB(205, 102, 29)), new NamedColor("chocolate4", Color.fromRGB(139, 69, 19)), new NamedColor("coral", Color.fromRGB(255, 127, 80)), new NamedColor("coral1", Color.fromRGB(255, 114, 86)), new NamedColor("coral2", Color.fromRGB(238, 106, 80)), new NamedColor("coral3", Color.fromRGB(205, 91, 69)), new NamedColor("coral4", Color.fromRGB(139, 62, 47)), new NamedColor("cornflowerblue", Color.fromRGB(100, 149, 237)), new NamedColor("cornsilk", Color.fromRGB(255, 248, 220)), new NamedColor("cornsilk1", Color.fromRGB(255, 248, 220)), new NamedColor("cornsilk2", Color.fromRGB(238, 232, 205)), new NamedColor("cornsilk3", Color.fromRGB(205, 200, 177)), new NamedColor("cornsilk4", Color.fromRGB(139, 136, 120)), new NamedColor("cyan", Color.fromRGB(0, 255, 255)), new NamedColor("cyan1", Color.fromRGB(0, 255, 255)), new NamedColor("cyan2", Color.fromRGB(0, 238, 238)), new NamedColor("cyan3", Color.fromRGB(0, 205, 205)), new NamedColor("cyan4", Color.fromRGB(0, 139, 139)), new NamedColor("darkblue", Color.fromRGB(0, 0, 139)), new NamedColor("darkcyan", Color.fromRGB(0, 139, 139)), new NamedColor("darkgoldenrod", Color.fromRGB(184, 134, 11)), new NamedColor("darkgoldenrod1", Color.fromRGB(255, 185, 15)), new NamedColor("darkgoldenrod2", Color.fromRGB(238, 173, 14)), new NamedColor("darkgoldenrod3", Color.fromRGB(205, 149, 12)), new NamedColor("darkgoldenrod4", Color.fromRGB(139, 101, 8)), new NamedColor("darkgray", Color.fromRGB(169, 169, 169)), new NamedColor("darkgreen", Color.fromRGB(0, 100, 0)), new NamedColor("darkgrey", Color.fromRGB(169, 169, 169)), new NamedColor("darkkhaki", Color.fromRGB(189, 183, 107)), new NamedColor("darkmagenta", Color.fromRGB(139, 0, 139)), new NamedColor("darkolivegreen", Color.fromRGB(85, 107, 47)), new NamedColor("darkolivegreen1", Color.fromRGB(202, 255, 112)), new NamedColor("darkolivegreen2", Color.fromRGB(188, 238, 104)), new NamedColor("darkolivegreen3", Color.fromRGB(162, 205, 90)), new NamedColor("darkolivegreen4", Color.fromRGB(110, 139, 61)), new NamedColor("darkorange", Color.fromRGB(255, 140, 0)), new NamedColor("darkorange1", Color.fromRGB(255, 127, 0)), new NamedColor("darkorange2", Color.fromRGB(238, 118, 0)), new NamedColor("darkorange3", Color.fromRGB(205, 102, 0)), new NamedColor("darkorange4", Color.fromRGB(139, 69, 0)), new NamedColor("darkorchid", Color.fromRGB(153, 50, 204)), new NamedColor("darkorchid1", Color.fromRGB(191, 62, 255)), new NamedColor("darkorchid2", Color.fromRGB(178, 58, 238)), new NamedColor("darkorchid3", Color.fromRGB(154, 50, 205)), new NamedColor("darkorchid4", Color.fromRGB(104, 34, 139)), new NamedColor("darkred", Color.fromRGB(139, 0, 0)), new NamedColor("darksalmon", Color.fromRGB(233, 150, 122)), new NamedColor("darkseagreen", Color.fromRGB(143, 188, 143)), new NamedColor("darkseagreen1", Color.fromRGB(193, 255, 193)), new NamedColor("darkseagreen2", Color.fromRGB(180, 238, 180)), new NamedColor("darkseagreen3", Color.fromRGB(155, 205, 155)), new NamedColor("darkseagreen4", Color.fromRGB(105, 139, 105)), new NamedColor("darkslateblue", Color.fromRGB(72, 61, 139)), new NamedColor("darkslategray", Color.fromRGB(47, 79, 79)), new NamedColor("darkslategray1", Color.fromRGB(151, 255, 255)), new NamedColor("darkslategray2", Color.fromRGB(141, 238, 238)), new NamedColor("darkslategray3", Color.fromRGB(121, 205, 205)), new NamedColor("darkslategray4", Color.fromRGB(82, 139, 139)), new NamedColor("darkslategrey", Color.fromRGB(47, 79, 79)), new NamedColor("darkturquoise", Color.fromRGB(0, 206, 209)), new NamedColor("darkviolet", Color.fromRGB(148, 0, 211)), new NamedColor("deeppink", Color.fromRGB(255, 20, 147)), new NamedColor("deeppink1", Color.fromRGB(255, 20, 147)), new NamedColor("deeppink2", Color.fromRGB(238, 18, 137)), new NamedColor("deeppink3", Color.fromRGB(205, 16, 118)), new NamedColor("deeppink4", Color.fromRGB(139, 10, 80)), new NamedColor("deepskyblue", Color.fromRGB(0, 191, 255)), new NamedColor("deepskyblue1", Color.fromRGB(0, 191, 255)), new NamedColor("deepskyblue2", Color.fromRGB(0, 178, 238)), new NamedColor("deepskyblue3", Color.fromRGB(0, 154, 205)), new NamedColor("deepskyblue4", Color.fromRGB(0, 104, 139)), new NamedColor("dimgray", Color.fromRGB(105, 105, 105)), new NamedColor("dimgrey", Color.fromRGB(105, 105, 105)), new NamedColor("dodgerblue", Color.fromRGB(30, 144, 255)), new NamedColor("dodgerblue1", Color.fromRGB(30, 144, 255)), new NamedColor("dodgerblue2", Color.fromRGB(28, 134, 238)), new NamedColor("dodgerblue3", Color.fromRGB(24, 116, 205)), new NamedColor("dodgerblue4", Color.fromRGB(16, 78, 139)), new NamedColor("firebrick", Color.fromRGB(178, 34, 34)), new NamedColor("firebrick1", Color.fromRGB(255, 48, 48)), new NamedColor("firebrick2", Color.fromRGB(238, 44, 44)), new NamedColor("firebrick3", Color.fromRGB(205, 38, 38)), new NamedColor("firebrick4", Color.fromRGB(139, 26, 26)), new NamedColor("floralwhite", Color.fromRGB(255, 250, 240)), new NamedColor("forestgreen", Color.fromRGB(34, 139, 34)), new NamedColor("gainsboro", Color.fromRGB(220, 220, 220)), new NamedColor("ghostwhite", Color.fromRGB(248, 248, 255)), new NamedColor("gold", Color.fromRGB(255, 215, 0)), new NamedColor("gold1", Color.fromRGB(255, 215, 0)), new NamedColor("gold2", Color.fromRGB(238, 201, 0)), new NamedColor("gold3", Color.fromRGB(205, 173, 0)), new NamedColor("gold4", Color.fromRGB(139, 117, 0)), new NamedColor("goldenrod", Color.fromRGB(218, 165, 32)), new NamedColor("goldenrod1", Color.fromRGB(255, 193, 37)), new NamedColor("goldenrod2", Color.fromRGB(238, 180, 34)), new NamedColor("goldenrod3", Color.fromRGB(205, 155, 29)), new NamedColor("goldenrod4", Color.fromRGB(139, 105, 20)), new NamedColor("gray", Color.fromRGB(190, 190, 190)), new NamedColor("gray0", Color.fromRGB(0, 0, 0)), new NamedColor("gray1", Color.fromRGB(3, 3, 3)), new NamedColor("gray2", Color.fromRGB(5, 5, 5)), new NamedColor("gray3", Color.fromRGB(8, 8, 8)), new NamedColor("gray4", Color.fromRGB(10, 10, 10)), new NamedColor("gray5", Color.fromRGB(13, 13, 13)), new NamedColor("gray6", Color.fromRGB(15, 15, 15)), new NamedColor("gray7", Color.fromRGB(18, 18, 18)), new NamedColor("gray8", Color.fromRGB(20, 20, 20)), new NamedColor("gray9", Color.fromRGB(23, 23, 23)), new NamedColor("gray10", Color.fromRGB(26, 26, 26)), new NamedColor("gray11", Color.fromRGB(28, 28, 28)), new NamedColor("gray12", Color.fromRGB(31, 31, 31)), new NamedColor("gray13", Color.fromRGB(33, 33, 33)), new NamedColor("gray14", Color.fromRGB(36, 36, 36)), new NamedColor("gray15", Color.fromRGB(38, 38, 38)), new NamedColor("gray16", Color.fromRGB(41, 41, 41)), new NamedColor("gray17", Color.fromRGB(43, 43, 43)), new NamedColor("gray18", Color.fromRGB(46, 46, 46)), new NamedColor("gray19", Color.fromRGB(48, 48, 48)), new NamedColor("gray20", Color.fromRGB(51, 51, 51)), new NamedColor("gray21", Color.fromRGB(54, 54, 54)), new NamedColor("gray22", Color.fromRGB(56, 56, 56)), new NamedColor("gray23", Color.fromRGB(59, 59, 59)), new NamedColor("gray24", Color.fromRGB(61, 61, 61)), new NamedColor("gray25", Color.fromRGB(64, 64, 64)), new NamedColor("gray26", Color.fromRGB(66, 66, 66)), new NamedColor("gray27", Color.fromRGB(69, 69, 69)), new NamedColor("gray28", Color.fromRGB(71, 71, 71)), new NamedColor("gray29", Color.fromRGB(74, 74, 74)), new NamedColor("gray30", Color.fromRGB(77, 77, 77)), new NamedColor("gray31", Color.fromRGB(79, 79, 79)), new NamedColor("gray32", Color.fromRGB(82, 82, 82)), new NamedColor("gray33", Color.fromRGB(84, 84, 84)), new NamedColor("gray34", Color.fromRGB(87, 87, 87)), new NamedColor("gray35", Color.fromRGB(89, 89, 89)), new NamedColor("gray36", Color.fromRGB(92, 92, 92)), new NamedColor("gray37", Color.fromRGB(94, 94, 94)), new NamedColor("gray38", Color.fromRGB(97, 97, 97)), new NamedColor("gray39", Color.fromRGB(99, 99, 99)), new NamedColor("gray40", Color.fromRGB(102, 102, 102)), new NamedColor("gray41", Color.fromRGB(105, 105, 105)), new NamedColor("gray42", Color.fromRGB(107, 107, 107)), new NamedColor("gray43", Color.fromRGB(110, 110, 110)), new NamedColor("gray44", Color.fromRGB(112, 112, 112)), new NamedColor("gray45", Color.fromRGB(115, 115, 115)), new NamedColor("gray46", Color.fromRGB(117, 117, 117)), new NamedColor("gray47", Color.fromRGB(120, 120, 120)), new NamedColor("gray48", Color.fromRGB(122, 122, 122)), new NamedColor("gray49", Color.fromRGB(125, 125, 125)), new NamedColor("gray50", Color.fromRGB(127, 127, 127)), new NamedColor("gray51", Color.fromRGB(130, 130, 130)), new NamedColor("gray52", Color.fromRGB(133, 133, 133)), new NamedColor("gray53", Color.fromRGB(135, 135, 135)), new NamedColor("gray54", Color.fromRGB(138, 138, 138)), new NamedColor("gray55", Color.fromRGB(140, 140, 140)), new NamedColor("gray56", Color.fromRGB(143, 143, 143)), new NamedColor("gray57", Color.fromRGB(145, 145, 145)), new NamedColor("gray58", Color.fromRGB(148, 148, 148)), new NamedColor("gray59", Color.fromRGB(150, 150, 150)), new NamedColor("gray60", Color.fromRGB(153, 153, 153)), new NamedColor("gray61", Color.fromRGB(156, 156, 156)), new NamedColor("gray62", Color.fromRGB(158, 158, 158)), new NamedColor("gray63", Color.fromRGB(161, 161, 161)), new NamedColor("gray64", Color.fromRGB(163, 163, 163)), new NamedColor("gray65", Color.fromRGB(166, 166, 166)), new NamedColor("gray66", Color.fromRGB(168, 168, 168)), new NamedColor("gray67", Color.fromRGB(171, 171, 171)), new NamedColor("gray68", Color.fromRGB(173, 173, 173)), new NamedColor("gray69", Color.fromRGB(176, 176, 176)), new NamedColor("gray70", Color.fromRGB(179, 179, 179)), new NamedColor("gray71", Color.fromRGB(181, 181, 181)), new NamedColor("gray72", Color.fromRGB(184, 184, 184)), new NamedColor("gray73", Color.fromRGB(186, 186, 186)), new NamedColor("gray74", Color.fromRGB(189, 189, 189)), new NamedColor("gray75", Color.fromRGB(191, 191, 191)), new NamedColor("gray76", Color.fromRGB(194, 194, 194)), new NamedColor("gray77", Color.fromRGB(196, 196, 196)), new NamedColor("gray78", Color.fromRGB(199, 199, 199)), new NamedColor("gray79", Color.fromRGB(201, 201, 201)), new NamedColor("gray80", Color.fromRGB(204, 204, 204)), new NamedColor("gray81", Color.fromRGB(207, 207, 207)), new NamedColor("gray82", Color.fromRGB(209, 209, 209)), new NamedColor("gray83", Color.fromRGB(212, 212, 212)), new NamedColor("gray84", Color.fromRGB(214, 214, 214)), new NamedColor("gray85", Color.fromRGB(217, 217, 217)), new NamedColor("gray86", Color.fromRGB(219, 219, 219)), new NamedColor("gray87", Color.fromRGB(222, 222, 222)), new NamedColor("gray88", Color.fromRGB(224, 224, 224)), new NamedColor("gray89", Color.fromRGB(227, 227, 227)), new NamedColor("gray90", Color.fromRGB(229, 229, 229)), new NamedColor("gray91", Color.fromRGB(232, 232, 232)), new NamedColor("gray92", Color.fromRGB(235, 235, 235)), new NamedColor("gray93", Color.fromRGB(237, 237, 237)), new NamedColor("gray94", Color.fromRGB(240, 240, 240)), new NamedColor("gray95", Color.fromRGB(242, 242, 242)), new NamedColor("gray96", Color.fromRGB(245, 245, 245)), new NamedColor("gray97", Color.fromRGB(247, 247, 247)), new NamedColor("gray98", Color.fromRGB(250, 250, 250)), new NamedColor("gray99", Color.fromRGB(252, 252, 252)), new NamedColor("gray100", Color.fromRGB(255, 255, 255)), new NamedColor("green", Color.fromRGB(0, 255, 0)), new NamedColor("green1", Color.fromRGB(0, 255, 0)), new NamedColor("green2", Color.fromRGB(0, 238, 0)), new NamedColor("green3", Color.fromRGB(0, 205, 0)), new NamedColor("green4", Color.fromRGB(0, 139, 0)), new NamedColor("greenyellow", Color.fromRGB(173, 255, 47)), new NamedColor("grey", Color.fromRGB(190, 190, 190)), new NamedColor("grey0", Color.fromRGB(0, 0, 0)), new NamedColor("grey1", Color.fromRGB(3, 3, 3)), new NamedColor("grey2", Color.fromRGB(5, 5, 5)), new NamedColor("grey3", Color.fromRGB(8, 8, 8)), new NamedColor("grey4", Color.fromRGB(10, 10, 10)), new NamedColor("grey5", Color.fromRGB(13, 13, 13)), new NamedColor("grey6", Color.fromRGB(15, 15, 15)), new NamedColor("grey7", Color.fromRGB(18, 18, 18)), new NamedColor("grey8", Color.fromRGB(20, 20, 20)), new NamedColor("grey9", Color.fromRGB(23, 23, 23)), new NamedColor("grey10", Color.fromRGB(26, 26, 26)), new NamedColor("grey11", Color.fromRGB(28, 28, 28)), new NamedColor("grey12", Color.fromRGB(31, 31, 31)), new NamedColor("grey13", Color.fromRGB(33, 33, 33)), new NamedColor("grey14", Color.fromRGB(36, 36, 36)), new NamedColor("grey15", Color.fromRGB(38, 38, 38)), new NamedColor("grey16", Color.fromRGB(41, 41, 41)), new NamedColor("grey17", Color.fromRGB(43, 43, 43)), new NamedColor("grey18", Color.fromRGB(46, 46, 46)), new NamedColor("grey19", Color.fromRGB(48, 48, 48)), new NamedColor("grey20", Color.fromRGB(51, 51, 51)), new NamedColor("grey21", Color.fromRGB(54, 54, 54)), new NamedColor("grey22", Color.fromRGB(56, 56, 56)), new NamedColor("grey23", Color.fromRGB(59, 59, 59)), new NamedColor("grey24", Color.fromRGB(61, 61, 61)), new NamedColor("grey25", Color.fromRGB(64, 64, 64)), new NamedColor("grey26", Color.fromRGB(66, 66, 66)), new NamedColor("grey27", Color.fromRGB(69, 69, 69)), new NamedColor("grey28", Color.fromRGB(71, 71, 71)), new NamedColor("grey29", Color.fromRGB(74, 74, 74)), new NamedColor("grey30", Color.fromRGB(77, 77, 77)), new NamedColor("grey31", Color.fromRGB(79, 79, 79)), new NamedColor("grey32", Color.fromRGB(82, 82, 82)), new NamedColor("grey33", Color.fromRGB(84, 84, 84)), new NamedColor("grey34", Color.fromRGB(87, 87, 87)), new NamedColor("grey35", Color.fromRGB(89, 89, 89)), new NamedColor("grey36", Color.fromRGB(92, 92, 92)), new NamedColor("grey37", Color.fromRGB(94, 94, 94)), new NamedColor("grey38", Color.fromRGB(97, 97, 97)), new NamedColor("grey39", Color.fromRGB(99, 99, 99)), new NamedColor("grey40", Color.fromRGB(102, 102, 102)), new NamedColor("grey41", Color.fromRGB(105, 105, 105)), new NamedColor("grey42", Color.fromRGB(107, 107, 107)), new NamedColor("grey43", Color.fromRGB(110, 110, 110)), new NamedColor("grey44", Color.fromRGB(112, 112, 112)), new NamedColor("grey45", Color.fromRGB(115, 115, 115)), new NamedColor("grey46", Color.fromRGB(117, 117, 117)), new NamedColor("grey47", Color.fromRGB(120, 120, 120)), new NamedColor("grey48", Color.fromRGB(122, 122, 122)), new NamedColor("grey49", Color.fromRGB(125, 125, 125)), new NamedColor("grey50", Color.fromRGB(127, 127, 127)), new NamedColor("grey51", Color.fromRGB(130, 130, 130)), new NamedColor("grey52", Color.fromRGB(133, 133, 133)), new NamedColor("grey53", Color.fromRGB(135, 135, 135)), new NamedColor("grey54", Color.fromRGB(138, 138, 138)), new NamedColor("grey55", Color.fromRGB(140, 140, 140)), new NamedColor("grey56", Color.fromRGB(143, 143, 143)), new NamedColor("grey57", Color.fromRGB(145, 145, 145)), new NamedColor("grey58", Color.fromRGB(148, 148, 148)), new NamedColor("grey59", Color.fromRGB(150, 150, 150)), new NamedColor("grey60", Color.fromRGB(153, 153, 153)), new NamedColor("grey61", Color.fromRGB(156, 156, 156)), new NamedColor("grey62", Color.fromRGB(158, 158, 158)), new NamedColor("grey63", Color.fromRGB(161, 161, 161)), new NamedColor("grey64", Color.fromRGB(163, 163, 163)), new NamedColor("grey65", Color.fromRGB(166, 166, 166)), new NamedColor("grey66", Color.fromRGB(168, 168, 168)), new NamedColor("grey67", Color.fromRGB(171, 171, 171)), new NamedColor("grey68", Color.fromRGB(173, 173, 173)), new NamedColor("grey69", Color.fromRGB(176, 176, 176)), new NamedColor("grey70", Color.fromRGB(179, 179, 179)), new NamedColor("grey71", Color.fromRGB(181, 181, 181)), new NamedColor("grey72", Color.fromRGB(184, 184, 184)), new NamedColor("grey73", Color.fromRGB(186, 186, 186)), new NamedColor("grey74", Color.fromRGB(189, 189, 189)), new NamedColor("grey75", Color.fromRGB(191, 191, 191)), new NamedColor("grey76", Color.fromRGB(194, 194, 194)), new NamedColor("grey77", Color.fromRGB(196, 196, 196)), new NamedColor("grey78", Color.fromRGB(199, 199, 199)), new NamedColor("grey79", Color.fromRGB(201, 201, 201)), new NamedColor("grey80", Color.fromRGB(204, 204, 204)), new NamedColor("grey81", Color.fromRGB(207, 207, 207)), new NamedColor("grey82", Color.fromRGB(209, 209, 209)), new NamedColor("grey83", Color.fromRGB(212, 212, 212)), new NamedColor("grey84", Color.fromRGB(214, 214, 214)), new NamedColor("grey85", Color.fromRGB(217, 217, 217)), new NamedColor("grey86", Color.fromRGB(219, 219, 219)), new NamedColor("grey87", Color.fromRGB(222, 222, 222)), new NamedColor("grey88", Color.fromRGB(224, 224, 224)), new NamedColor("grey89", Color.fromRGB(227, 227, 227)), new NamedColor("grey90", Color.fromRGB(229, 229, 229)), new NamedColor("grey91", Color.fromRGB(232, 232, 232)), new NamedColor("grey92", Color.fromRGB(235, 235, 235)), new NamedColor("grey93", Color.fromRGB(237, 237, 237)), new NamedColor("grey94", Color.fromRGB(240, 240, 240)), new NamedColor("grey95", Color.fromRGB(242, 242, 242)), new NamedColor("grey96", Color.fromRGB(245, 245, 245)), new NamedColor("grey97", Color.fromRGB(247, 247, 247)), new NamedColor("grey98", Color.fromRGB(250, 250, 250)), new NamedColor("grey99", Color.fromRGB(252, 252, 252)), new NamedColor("grey100", Color.fromRGB(255, 255, 255)), new NamedColor("honeydew", Color.fromRGB(240, 255, 240)), new NamedColor("honeydew1", Color.fromRGB(240, 255, 240)), new NamedColor("honeydew2", Color.fromRGB(224, 238, 224)), new NamedColor("honeydew3", Color.fromRGB(193, 205, 193)), new NamedColor("honeydew4", Color.fromRGB(131, 139, 131)), new NamedColor("hotpink", Color.fromRGB(255, 105, 180)), new NamedColor("hotpink1", Color.fromRGB(255, 110, 180)), new NamedColor("hotpink2", Color.fromRGB(238, 106, 167)), new NamedColor("hotpink3", Color.fromRGB(205, 96, 144)), new NamedColor("hotpink4", Color.fromRGB(139, 58, 98)), new NamedColor("indianred", Color.fromRGB(205, 92, 92)), new NamedColor("indianred1", Color.fromRGB(255, 106, 106)), new NamedColor("indianred2", Color.fromRGB(238, 99, 99)), new NamedColor("indianred3", Color.fromRGB(205, 85, 85)), new NamedColor("indianred4", Color.fromRGB(139, 58, 58)), new NamedColor("ivory", Color.fromRGB(255, 255, 240)), new NamedColor("ivory1", Color.fromRGB(255, 255, 240)), new NamedColor("ivory2", Color.fromRGB(238, 238, 224)), new NamedColor("ivory3", Color.fromRGB(205, 205, 193)), new NamedColor("ivory4", Color.fromRGB(139, 139, 131)), new NamedColor("khaki", Color.fromRGB(240, 230, 140)), new NamedColor("khaki1", Color.fromRGB(255, 246, 143)), new NamedColor("khaki2", Color.fromRGB(238, 230, 133)), new NamedColor("khaki3", Color.fromRGB(205, 198, 115)), new NamedColor("khaki4", Color.fromRGB(139, 134, 78)), new NamedColor("lavender", Color.fromRGB(230, 230, 250)), new NamedColor("lavenderblush", Color.fromRGB(255, 240, 245)), new NamedColor("lavenderblush1", Color.fromRGB(255, 240, 245)), new NamedColor("lavenderblush2", Color.fromRGB(238, 224, 229)), new NamedColor("lavenderblush3", Color.fromRGB(205, 193, 197)), new NamedColor("lavenderblush4", Color.fromRGB(139, 131, 134)), new NamedColor("lawngreen", Color.fromRGB(124, 252, 0)), new NamedColor("lemonchiffon", Color.fromRGB(255, 250, 205)), new NamedColor("lemonchiffon1", Color.fromRGB(255, 250, 205)), new NamedColor("lemonchiffon2", Color.fromRGB(238, 233, 191)), new NamedColor("lemonchiffon3", Color.fromRGB(205, 201, 165)), new NamedColor("lemonchiffon4", Color.fromRGB(139, 137, 112)), new NamedColor("lightblue", Color.fromRGB(173, 216, 230)), new NamedColor("lightblue1", Color.fromRGB(191, 239, 255)), new NamedColor("lightblue2", Color.fromRGB(178, 223, 238)), new NamedColor("lightblue3", Color.fromRGB(154, 192, 205)), new NamedColor("lightblue4", Color.fromRGB(104, 131, 139)), new NamedColor("lightcoral", Color.fromRGB(240, 128, 128)), new NamedColor("lightcyan", Color.fromRGB(224, 255, 255)), new NamedColor("lightcyan1", Color.fromRGB(224, 255, 255)), new NamedColor("lightcyan2", Color.fromRGB(209, 238, 238)), new NamedColor("lightcyan3", Color.fromRGB(180, 205, 205)), new NamedColor("lightcyan4", Color.fromRGB(122, 139, 139)), new NamedColor("lightgoldenrod", Color.fromRGB(238, 221, 130)), new NamedColor("lightgoldenrod1", Color.fromRGB(255, 236, 139)), new NamedColor("lightgoldenrod2", Color.fromRGB(238, 220, 130)), new NamedColor("lightgoldenrod3", Color.fromRGB(205, 190, 112)), new NamedColor("lightgoldenrod4", Color.fromRGB(139, 129, 76)), new NamedColor("lightgoldenrodyellow", Color.fromRGB(250, 250, 210)), new NamedColor("lightgray", Color.fromRGB(211, 211, 211)), new NamedColor("lightgreen", Color.fromRGB(144, 238, 144)), new NamedColor("lightgrey", Color.fromRGB(211, 211, 211)), new NamedColor("lightpink", Color.fromRGB(255, 182, 193)), new NamedColor("lightpink1", Color.fromRGB(255, 174, 185)), new NamedColor("lightpink2", Color.fromRGB(238, 162, 173)), new NamedColor("lightpink3", Color.fromRGB(205, 140, 149)), new NamedColor("lightpink4", Color.fromRGB(139, 95, 101)), new NamedColor("lightsalmon", Color.fromRGB(255, 160, 122)), new NamedColor("lightsalmon1", Color.fromRGB(255, 160, 122)), new NamedColor("lightsalmon2", Color.fromRGB(238, 149, 114)), new NamedColor("lightsalmon3", Color.fromRGB(205, 129, 98)), new NamedColor("lightsalmon4", Color.fromRGB(139, 87, 66)), new NamedColor("lightseagreen", Color.fromRGB(32, 178, 170)), new NamedColor("lightskyblue", Color.fromRGB(135, 206, 250)), new NamedColor("lightskyblue1", Color.fromRGB(176, 226, 255)), new NamedColor("lightskyblue2", Color.fromRGB(164, 211, 238)), new NamedColor("lightskyblue3", Color.fromRGB(141, 182, 205)), new NamedColor("lightskyblue4", Color.fromRGB(96, 123, 139)), new NamedColor("lightslateblue", Color.fromRGB(132, 112, 255)), new NamedColor("lightslategray", Color.fromRGB(119, 136, 153)), new NamedColor("lightslategrey", Color.fromRGB(119, 136, 153)), new NamedColor("lightsteelblue", Color.fromRGB(176, 196, 222)), new NamedColor("lightsteelblue1", Color.fromRGB(202, 225, 255)), new NamedColor("lightsteelblue2", Color.fromRGB(188, 210, 238)), new NamedColor("lightsteelblue3", Color.fromRGB(162, 181, 205)), new NamedColor("lightsteelblue4", Color.fromRGB(110, 123, 139)), new NamedColor("lightyellow", Color.fromRGB(255, 255, 224)), new NamedColor("lightyellow1", Color.fromRGB(255, 255, 224)), new NamedColor("lightyellow2", Color.fromRGB(238, 238, 209)), new NamedColor("lightyellow3", Color.fromRGB(205, 205, 180)), new NamedColor("lightyellow4", Color.fromRGB(139, 139, 122)), new NamedColor("limegreen", Color.fromRGB(50, 205, 50)), new NamedColor("linen", Color.fromRGB(250, 240, 230)), new NamedColor("magenta", Color.fromRGB(255, 0, 255)), new NamedColor("magenta1", Color.fromRGB(255, 0, 255)), new NamedColor("magenta2", Color.fromRGB(238, 0, 238)), new NamedColor("magenta3", Color.fromRGB(205, 0, 205)), new NamedColor("magenta4", Color.fromRGB(139, 0, 139)), new NamedColor("maroon", Color.fromRGB(176, 48, 96)), new NamedColor("maroon1", Color.fromRGB(255, 52, 179)), new NamedColor("maroon2", Color.fromRGB(238, 48, 167)), new NamedColor("maroon3", Color.fromRGB(205, 41, 144)), new NamedColor("maroon4", Color.fromRGB(139, 28, 98)), new NamedColor("mediumaquamarine", Color.fromRGB(102, 205, 170)), new NamedColor("mediumblue", Color.fromRGB(0, 0, 205)), new NamedColor("mediumorchid", Color.fromRGB(186, 85, 211)), new NamedColor("mediumorchid1", Color.fromRGB(224, 102, 255)), new NamedColor("mediumorchid2", Color.fromRGB(209, 95, 238)), new NamedColor("mediumorchid3", Color.fromRGB(180, 82, 205)), new NamedColor("mediumorchid4", Color.fromRGB(122, 55, 139)), new NamedColor("mediumpurple", Color.fromRGB(147, 112, 219)), new NamedColor("mediumpurple1", Color.fromRGB(171, 130, 255)), new NamedColor("mediumpurple2", Color.fromRGB(159, 121, 238)), new NamedColor("mediumpurple3", Color.fromRGB(137, 104, 205)), new NamedColor("mediumpurple4", Color.fromRGB(93, 71, 139)), new NamedColor("mediumseagreen", Color.fromRGB(60, 179, 113)), new NamedColor("mediumslateblue", Color.fromRGB(123, 104, 238)), new NamedColor("mediumspringgreen", Color.fromRGB(0, 250, 154)), new NamedColor("mediumturquoise", Color.fromRGB(72, 209, 204)), new NamedColor("mediumvioletred", Color.fromRGB(199, 21, 133)), new NamedColor("midnightblue", Color.fromRGB(25, 25, 112)), new NamedColor("mintcream", Color.fromRGB(245, 255, 250)), new NamedColor("mistyrose", Color.fromRGB(255, 228, 225)), new NamedColor("mistyrose1", Color.fromRGB(255, 228, 225)), new NamedColor("mistyrose2", Color.fromRGB(238, 213, 210)), new NamedColor("mistyrose3", Color.fromRGB(205, 183, 181)), new NamedColor("mistyrose4", Color.fromRGB(139, 125, 123)), new NamedColor("moccasin", Color.fromRGB(255, 228, 181)), new NamedColor("navajowhite", Color.fromRGB(255, 222, 173)), new NamedColor("navajowhite1", Color.fromRGB(255, 222, 173)), new NamedColor("navajowhite2", Color.fromRGB(238, 207, 161)), new NamedColor("navajowhite3", Color.fromRGB(205, 179, 139)), new NamedColor("navajowhite4", Color.fromRGB(139, 121, 94)), new NamedColor("navy", Color.fromRGB(0, 0, 128)), new NamedColor("navyblue", Color.fromRGB(0, 0, 128)), new NamedColor("oldlace", Color.fromRGB(253, 245, 230)), new NamedColor("olivedrab", Color.fromRGB(107, 142, 35)), new NamedColor("olivedrab1", Color.fromRGB(192, 255, 62)), new NamedColor("olivedrab2", Color.fromRGB(179, 238, 58)), new NamedColor("olivedrab3", Color.fromRGB(154, 205, 50)), new NamedColor("olivedrab4", Color.fromRGB(105, 139, 34)), new NamedColor("orange", Color.fromRGB(255, 165, 0)), new NamedColor("orange1", Color.fromRGB(255, 165, 0)), new NamedColor("orange2", Color.fromRGB(238, 154, 0)), new NamedColor("orange3", Color.fromRGB(205, 133, 0)), new NamedColor("orange4", Color.fromRGB(139, 90, 0)), new NamedColor("orangered", Color.fromRGB(255, 69, 0)), new NamedColor("orangered1", Color.fromRGB(255, 69, 0)), new NamedColor("orangered2", Color.fromRGB(238, 64, 0)), new NamedColor("orangered3", Color.fromRGB(205, 55, 0)), new NamedColor("orangered4", Color.fromRGB(139, 37, 0)), new NamedColor("orchid", Color.fromRGB(218, 112, 214)), new NamedColor("orchid1", Color.fromRGB(255, 131, 250)), new NamedColor("orchid2", Color.fromRGB(238, 122, 233)), new NamedColor("orchid3", Color.fromRGB(205, 105, 201)), new NamedColor("orchid4", Color.fromRGB(139, 71, 137)), new NamedColor("palegoldenrod", Color.fromRGB(238, 232, 170)), new NamedColor("palegreen", Color.fromRGB(152, 251, 152)), new NamedColor("palegreen1", Color.fromRGB(154, 255, 154)), new NamedColor("palegreen2", Color.fromRGB(144, 238, 144)), new NamedColor("palegreen3", Color.fromRGB(124, 205, 124)), new NamedColor("palegreen4", Color.fromRGB(84, 139, 84)), new NamedColor("paleturquoise", Color.fromRGB(175, 238, 238)), new NamedColor("paleturquoise1", Color.fromRGB(187, 255, 255)), new NamedColor("paleturquoise2", Color.fromRGB(174, 238, 238)), new NamedColor("paleturquoise3", Color.fromRGB(150, 205, 205)), new NamedColor("paleturquoise4", Color.fromRGB(102, 139, 139)), new NamedColor("palevioletred", Color.fromRGB(219, 112, 147)), new NamedColor("palevioletred1", Color.fromRGB(255, 130, 171)), new NamedColor("palevioletred2", Color.fromRGB(238, 121, 159)), new NamedColor("palevioletred3", Color.fromRGB(205, 104, 137)), new NamedColor("palevioletred4", Color.fromRGB(139, 71, 93)), new NamedColor("papayawhip", Color.fromRGB(255, 239, 213)), new NamedColor("peachpuff", Color.fromRGB(255, 218, 185)), new NamedColor("peachpuff1", Color.fromRGB(255, 218, 185)), new NamedColor("peachpuff2", Color.fromRGB(238, 203, 173)), new NamedColor("peachpuff3", Color.fromRGB(205, 175, 149)), new NamedColor("peachpuff4", Color.fromRGB(139, 119, 101)), new NamedColor("peru", Color.fromRGB(205, 133, 63)), new NamedColor("pink", Color.fromRGB(255, 192, 203)), new NamedColor("pink1", Color.fromRGB(255, 181, 197)), new NamedColor("pink2", Color.fromRGB(238, 169, 184)), new NamedColor("pink3", Color.fromRGB(205, 145, 158)), new NamedColor("pink4", Color.fromRGB(139, 99, 108)), new NamedColor("plum", Color.fromRGB(221, 160, 221)), new NamedColor("plum1", Color.fromRGB(255, 187, 255)), new NamedColor("plum2", Color.fromRGB(238, 174, 238)), new NamedColor("plum3", Color.fromRGB(205, 150, 205)), new NamedColor("plum4", Color.fromRGB(139, 102, 139)), new NamedColor("powderblue", Color.fromRGB(176, 224, 230)), new NamedColor("purple", Color.fromRGB(160, 32, 240)), new NamedColor("purple1", Color.fromRGB(155, 48, 255)), new NamedColor("purple2", Color.fromRGB(145, 44, 238)), new NamedColor("purple3", Color.fromRGB(125, 38, 205)), new NamedColor("purple4", Color.fromRGB(85, 26, 139)), new NamedColor("red", Color.fromRGB(255, 0, 0)), new NamedColor("red1", Color.fromRGB(255, 0, 0)), new NamedColor("red2", Color.fromRGB(238, 0, 0)), new NamedColor("red3", Color.fromRGB(205, 0, 0)), new NamedColor("red4", Color.fromRGB(139, 0, 0)), new NamedColor("rosybrown", Color.fromRGB(188, 143, 143)), new NamedColor("rosybrown1", Color.fromRGB(255, 193, 193)), new NamedColor("rosybrown2", Color.fromRGB(238, 180, 180)), new NamedColor("rosybrown3", Color.fromRGB(205, 155, 155)), new NamedColor("rosybrown4", Color.fromRGB(139, 105, 105)), new NamedColor("royalblue", Color.fromRGB(65, 105, 225)), new NamedColor("royalblue1", Color.fromRGB(72, 118, 255)), new NamedColor("royalblue2", Color.fromRGB(67, 110, 238)), new NamedColor("royalblue3", Color.fromRGB(58, 95, 205)), new NamedColor("royalblue4", Color.fromRGB(39, 64, 139)), new NamedColor("saddlebrown", Color.fromRGB(139, 69, 19)), new NamedColor("salmon", Color.fromRGB(250, 128, 114)), new NamedColor("salmon1", Color.fromRGB(255, 140, 105)), new NamedColor("salmon2", Color.fromRGB(238, 130, 98)), new NamedColor("salmon3", Color.fromRGB(205, 112, 84)), new NamedColor("salmon4", Color.fromRGB(139, 76, 57)), new NamedColor("sandybrown", Color.fromRGB(244, 164, 96)), new NamedColor("seagreen", Color.fromRGB(46, 139, 87)), new NamedColor("seagreen1", Color.fromRGB(84, 255, 159)), new NamedColor("seagreen2", Color.fromRGB(78, 238, 148)), new NamedColor("seagreen3", Color.fromRGB(67, 205, 128)), new NamedColor("seagreen4", Color.fromRGB(46, 139, 87)), new NamedColor("seashell", Color.fromRGB(255, 245, 238)), new NamedColor("seashell1", Color.fromRGB(255, 245, 238)), new NamedColor("seashell2", Color.fromRGB(238, 229, 222)), new NamedColor("seashell3", Color.fromRGB(205, 197, 191)), new NamedColor("seashell4", Color.fromRGB(139, 134, 130)), new NamedColor("sienna", Color.fromRGB(160, 82, 45)), new NamedColor("sienna1", Color.fromRGB(255, 130, 71)), new NamedColor("sienna2", Color.fromRGB(238, 121, 66)), new NamedColor("sienna3", Color.fromRGB(205, 104, 57)), new NamedColor("sienna4", Color.fromRGB(139, 71, 38)), new NamedColor("skyblue", Color.fromRGB(135, 206, 235)), new NamedColor("skyblue1", Color.fromRGB(135, 206, 255)), new NamedColor("skyblue2", Color.fromRGB(126, 192, 238)), new NamedColor("skyblue3", Color.fromRGB(108, 166, 205)), new NamedColor("skyblue4", Color.fromRGB(74, 112, 139)), new NamedColor("slateblue", Color.fromRGB(106, 90, 205)), new NamedColor("slateblue1", Color.fromRGB(131, 111, 255)), new NamedColor("slateblue2", Color.fromRGB(122, 103, 238)), new NamedColor("slateblue3", Color.fromRGB(105, 89, 205)), new NamedColor("slateblue4", Color.fromRGB(71, 60, 139)), new NamedColor("slategray", Color.fromRGB(112, 128, 144)), new NamedColor("slategray1", Color.fromRGB(198, 226, 255)), new NamedColor("slategray2", Color.fromRGB(185, 211, 238)), new NamedColor("slategray3", Color.fromRGB(159, 182, 205)), new NamedColor("slategray4", Color.fromRGB(108, 123, 139)), new NamedColor("slategrey", Color.fromRGB(112, 128, 144)), new NamedColor("snow", Color.fromRGB(255, 250, 250)), new NamedColor("snow1", Color.fromRGB(255, 250, 250)), new NamedColor("snow2", Color.fromRGB(238, 233, 233)), new NamedColor("snow3", Color.fromRGB(205, 201, 201)), new NamedColor("snow4", Color.fromRGB(139, 137, 137)), new NamedColor("springgreen", Color.fromRGB(0, 255, 127)), new NamedColor("springgreen1", Color.fromRGB(0, 255, 127)), new NamedColor("springgreen2", Color.fromRGB(0, 238, 118)), new NamedColor("springgreen3", Color.fromRGB(0, 205, 102)), new NamedColor("springgreen4", Color.fromRGB(0, 139, 69)), new NamedColor("steelblue", Color.fromRGB(70, 130, 180)), new NamedColor("steelblue1", Color.fromRGB(99, 184, 255)), new NamedColor("steelblue2", Color.fromRGB(92, 172, 238)), new NamedColor("steelblue3", Color.fromRGB(79, 148, 205)), new NamedColor("steelblue4", Color.fromRGB(54, 100, 139)), new NamedColor("tan", Color.fromRGB(210, 180, 140)), new NamedColor("tan1", Color.fromRGB(255, 165, 79)), new NamedColor("tan2", Color.fromRGB(238, 154, 73)), new NamedColor("tan3", Color.fromRGB(205, 133, 63)), new NamedColor("tan4", Color.fromRGB(139, 90, 43)), new NamedColor("thistle", Color.fromRGB(216, 191, 216)), new NamedColor("thistle1", Color.fromRGB(255, 225, 255)), new NamedColor("thistle2", Color.fromRGB(238, 210, 238)), new NamedColor("thistle3", Color.fromRGB(205, 181, 205)), new NamedColor("thistle4", Color.fromRGB(139, 123, 139)), new NamedColor("tomato", Color.fromRGB(255, 99, 71)), new NamedColor("tomato1", Color.fromRGB(255, 99, 71)), new NamedColor("tomato2", Color.fromRGB(238, 92, 66)), new NamedColor("tomato3", Color.fromRGB(205, 79, 57)), new NamedColor("tomato4", Color.fromRGB(139, 54, 38)), new NamedColor("turquoise", Color.fromRGB(64, 224, 208)), new NamedColor("turquoise1", Color.fromRGB(0, 245, 255)), new NamedColor("turquoise2", Color.fromRGB(0, 229, 238)), new NamedColor("turquoise3", Color.fromRGB(0, 197, 205)), new NamedColor("turquoise4", Color.fromRGB(0, 134, 139)), new NamedColor("violet", Color.fromRGB(238, 130, 238)), new NamedColor("violetred", Color.fromRGB(208, 32, 144)), new NamedColor("violetred1", Color.fromRGB(255, 62, 150)), new NamedColor("violetred2", Color.fromRGB(238, 58, 140)), new NamedColor("violetred3", Color.fromRGB(205, 50, 120)), new NamedColor("violetred4", Color.fromRGB(139, 34, 82)), new NamedColor("wheat", Color.fromRGB(245, 222, 179)), new NamedColor("wheat1", Color.fromRGB(255, 231, 186)), new NamedColor("wheat2", Color.fromRGB(238, 216, 174)), new NamedColor("wheat3", Color.fromRGB(205, 186, 150)), new NamedColor("wheat4", Color.fromRGB(139, 126, 102)), new NamedColor("whitesmoke", Color.fromRGB(245, 245, 245)), new NamedColor("yellow", Color.fromRGB(255, 255, 0)), new NamedColor("yellow1", Color.fromRGB(255, 255, 0)), new NamedColor("yellow2", Color.fromRGB(238, 238, 0)), new NamedColor("yellow3", Color.fromRGB(205, 205, 0)), new NamedColor("yellow4", Color.fromRGB(139, 139, 0)), new NamedColor("yellowgreen", Color.fromRGB(154, 205, 50))};

    public Color(int argb) {
        this.value = argb;
    }

    public static Color fromRGB(int r, int g, int b) {
        return new Color(r | g << 8 | b << 16 | 0xFF000000);
    }

    public static Color fromRGBA(int r, int g, int b, int a) {
        return new Color(r | g << 8 | b << 16 | a << 24);
    }

    public static Color fromName(String name) {
        for (NamedColor namedColor : COLOR_DATABASE) {
            if (!namedColor.name.equals(name)) continue;
            return namedColor.color;
        }
        throw new IllegalArgumentException("No such color name: " + name);
    }

    public static Color fromExp(ColorPalette palette, Color background, Vector vector2, int elementIndex) {
        String string;
        if (vector2.isElementNA(elementIndex)) {
            return TRANSPARENT_WHITE;
        }
        if (vector2 instanceof StringVector && !Character.isDigit((string = vector2.getElementAsString(elementIndex)).codePointAt(0))) {
            return Color.fromString(vector2.getElementAsString(elementIndex));
        }
        int index = vector2.getElementAsInt(elementIndex);
        if (index <= 0) {
            return background;
        }
        return palette.get(index);
    }

    public static Color fromExp(Context context, GraphicsDevice device, Vector colorVector, int elementIndex) {
        return Color.fromExp(context.getSingleton(ColorPalette.class), device.getParameters().getBackground(), colorVector, elementIndex % colorVector.length());
    }

    public static Color fromString(String string) {
        if (string.length() >= 1 && string.charAt(0) == '#') {
            return Color.fromHexString(string);
        }
        return Color.fromName(string);
    }

    public static Color fromHexString(String rgb2) {
        int b;
        int g;
        int r;
        int a = 255;
        if (rgb2.length() < 1 || rgb2.charAt(0) != '#') {
            throw new IllegalArgumentException("invalid RGB specification: " + rgb2 + " (must begin with '#')");
        }
        switch (rgb2.length()) {
            case 9: {
                a = Integer.valueOf(rgb2.substring(7, 9), 16);
            }
            case 7: {
                r = Integer.valueOf(rgb2.substring(1, 3), 16);
                g = Integer.valueOf(rgb2.substring(3, 5), 16);
                b = Integer.valueOf(rgb2.substring(5, 7), 16);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid RGB specification: " + rgb2);
            }
        }
        return Color.fromRGBA(r, g, b, a);
    }

    public int getRed() {
        return this.value & 0xFF;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value >> 16 & 0xFF;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public boolean isOpaque() {
        return this.getAlpha() == 255;
    }

    public boolean isTransparent() {
        return this.getAlpha() == 0;
    }

    private char hexDigit(int digit) {
        return Character.forDigit(digit, 16);
    }

    private static int valueOfHexDigit(char hex) {
        return Character.digit(hex, 16);
    }

    public SEXP toExp() {
        return new StringArrayVector(this.toString());
    }

    public String toString() {
        if (this.isOpaque()) {
            for (NamedColor namedColor : COLOR_DATABASE) {
                if (!namedColor.color.equals(this)) continue;
                return namedColor.name;
            }
            char[] hexString = new char[]{'#', this.hexDigit(this.value >> 4 & 0xF), this.hexDigit(this.value & 0xF), this.hexDigit(this.value >> 12 & 0xF), this.hexDigit(this.value >> 8 & 0xF), this.hexDigit(this.value >> 20 & 0xF), this.hexDigit(this.value >> 16 & 0xF)};
            return new String(hexString);
        }
        if (this.isTransparent()) {
            return "transparent";
        }
        char[] hexString = new char[]{'#', this.hexDigit(this.value >> 4 & 0xF), this.hexDigit(this.value & 0xF), this.hexDigit(this.value >> 12 & 0xF), this.hexDigit(this.value >> 8 & 0xF), this.hexDigit(this.value >> 20 & 0xF), this.hexDigit(this.value >> 16 & 0xF), this.hexDigit(this.value >> 28 & 0xF)};
        hexString[8] = this.hexDigit(this.value >> 24 & 0xF);
        return new String(hexString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.value == color.value;
    }

    public int hashCode() {
        return this.value;
    }

    private static class NamedColor {
        private String name;
        private Color color;

        private NamedColor(String name, Color color) {
            this.name = name;
            this.color = color;
        }
    }
}

