/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.lang.invoke.MethodHandle;
import org.renjin.primitives.packaging.DllInfo;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbols;

public class DllSymbol {
    private String name;
    private DllInfo library;
    private MethodHandle methodHandle;
    private Convention convention;

    public DllSymbol(DllInfo library2) {
        this.library = library2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DllInfo getLibrary() {
        return this.library;
    }

    public void setMethodHandle(MethodHandle methodHandle) {
        this.methodHandle = methodHandle;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public void setLibrary(DllInfo library2) {
        this.library = library2;
    }

    public void setConvention(Convention convention) {
        this.convention = convention;
    }

    public ListVector createObject() {
        ListVector.NamedBuilder symbol2 = new ListVector.NamedBuilder();
        symbol2.add("name", this.name);
        symbol2.add("address", new ExternalPtr<MethodHandle>(this.methodHandle, AttributeMap.builder().setClass("RegisteredNativeSymbol").build()));
        symbol2.add("numParameters", this.methodHandle.type().parameterCount());
        if (this.convention != null) {
            symbol2.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector(this.convention.getClassName(), "NativeSymbolInfo"));
        } else {
            symbol2.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("NativeSymbolInfo"));
        }
        return symbol2.build();
    }

    public static enum Convention {
        C("CRoutine"),
        CALL("CallRoutine"),
        FORTRAN("FortranRoutine"),
        EXTERNAL("ExternalRoutine");

        private String className;

        private Convention(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

