/*
 * Decompiled with CFR 0.152.
 */
package io.scif.media.imageioimpl.plugins.pcx;

import io.scif.media.imageioimpl.common.PackageUtil;
import io.scif.media.imageioimpl.plugins.pcx.PCXImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class PCXImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"io.scif.media.imageioimpl.plugins.pcx.PCXImageWriterSpi"};
    private static String[] formatNames = new String[]{"pcx", "PCX"};
    private static String[] extensions = new String[]{"pcx"};
    private static String[] mimeTypes = new String[]{"image/pcx", "image/x-pcx", "image/x-windows-pcx", "image/x-pc-paintbrush"};
    private boolean registered = false;

    public PCXImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "io.scif.media.imageioimpl.plugins.pcx.PCXImageReader", STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    public String getDescription(Locale locale) {
        String desc = PackageUtil.getSpecificationTitle() + " PCX Image Reader";
        return desc;
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        stream.mark();
        byte b = stream.readByte();
        stream.reset();
        return b == 10;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new PCXImageReader(this);
    }
}

