/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.Colors;
import java.awt.Color;
import java.awt.image.IndexColorModel;

public class LUT
extends IndexColorModel
implements Cloneable {
    public static final String nameKey = "CurrentLUT";
    public double min;
    public double max;
    private IndexColorModel cm;

    public LUT(byte[] r, byte[] g, byte[] b) {
        this(8, 256, r, g, b);
    }

    public LUT(int bits, int size, byte[] r, byte[] g, byte[] b) {
        super(bits, size, r, g, b);
    }

    public LUT(IndexColorModel cm, double min, double max) {
        super(8, cm.getMapSize(), LUT.getReds(cm), LUT.getGreens(cm), LUT.getBlues(cm));
        this.min = min;
        this.max = max;
    }

    static byte[] getReds(IndexColorModel cm) {
        byte[] reds = new byte[256];
        cm.getReds(reds);
        return reds;
    }

    static byte[] getGreens(IndexColorModel cm) {
        byte[] greens = new byte[256];
        cm.getGreens(greens);
        return greens;
    }

    static byte[] getBlues(IndexColorModel cm) {
        byte[] blues = new byte[256];
        cm.getBlues(blues);
        return blues;
    }

    public IndexColorModel getColorModel() {
        if (this.cm == null) {
            byte[] reds = new byte[256];
            this.getReds(reds);
            byte[] greens = new byte[256];
            this.getGreens(greens);
            byte[] blues = new byte[256];
            this.getBlues(blues);
            this.cm = new IndexColorModel(8, this.getMapSize(), reds, greens, blues);
        }
        return this.cm;
    }

    public byte[] getBytes() {
        int i;
        int size = this.getMapSize();
        if (size != 256) {
            return null;
        }
        byte[] bytes = new byte[768];
        for (i = 0; i < 256; ++i) {
            bytes[i] = (byte)this.getRed(i);
        }
        for (i = 0; i < 256; ++i) {
            bytes[256 + i] = (byte)this.getGreen(i);
        }
        for (i = 0; i < 256; ++i) {
            bytes[512 + i] = (byte)this.getBlue(i);
        }
        return bytes;
    }

    public LUT createInvertedLut() {
        int mapSize = this.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] reds2 = new byte[mapSize];
        byte[] greens2 = new byte[mapSize];
        byte[] blues2 = new byte[mapSize];
        this.getReds(reds);
        this.getGreens(greens);
        this.getBlues(blues);
        for (int i = 0; i < mapSize; ++i) {
            reds2[i] = (byte)(reds[mapSize - i - 1] & 0xFF);
            greens2[i] = (byte)(greens[mapSize - i - 1] & 0xFF);
            blues2[i] = (byte)(blues[mapSize - i - 1] & 0xFF);
        }
        return new LUT(8, mapSize, reds2, greens2, blues2);
    }

    public static LUT createLutFromColor(Color color) {
        byte[] rLut = new byte[256];
        byte[] gLut = new byte[256];
        byte[] bLut = new byte[256];
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double rIncr = (double)red / 255.0;
        double gIncr = (double)green / 255.0;
        double bIncr = (double)blue / 255.0;
        for (int i = 0; i < 256; ++i) {
            rLut[i] = (byte)((double)i * rIncr);
            gLut[i] = (byte)((double)i * gIncr);
            bLut[i] = (byte)((double)i * bIncr);
        }
        return new LUT(rLut, gLut, bLut);
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "rgb[0]=" + Colors.colorToString(new Color(this.getRGB(0))) + ", rgb[255]=" + Colors.colorToString(new Color(this.getRGB(255))) + ", min=" + IJ.d2s(this.min, 4) + ", max=" + IJ.d2s(this.max, 4);
    }

    public static boolean LutsDiffer(ImagePlus imp1, ImagePlus imp2) {
        if (!imp1.isComposite() || !imp2.isComposite()) {
            return false;
        }
        LUT[] luts1 = ((CompositeImage)imp1).getLuts();
        LUT[] luts2 = ((CompositeImage)imp2).getLuts();
        if (luts1 == null || luts2 == null) {
            return false;
        }
        if (luts1.length != luts2.length) {
            return true;
        }
        for (int i = 0; i < luts1.length; ++i) {
            byte[] bytes2;
            if (luts1[i].min != luts2[i].min) {
                return true;
            }
            if (luts1[i].max != luts2[i].max) {
                return true;
            }
            byte[] bytes1 = luts1[i].getBytes();
            if (bytes1.length != (bytes2 = luts2[i].getBytes()).length) {
                return true;
            }
            for (int j = 0; j < bytes1.length; ++j) {
                if (bytes1[j] == bytes2[j]) continue;
                return true;
            }
        }
        return false;
    }
}

