/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.Iterator;
import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.roi.AbstractRegionOfInterest;
import net.imglib2.roi.IterableRegionOfInterest;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.Views;

@Deprecated
public class BinaryMaskRegionOfInterest<T extends BitType, I extends RandomAccessibleInterval<T>>
extends AbstractRegionOfInterest
implements IterableRegionOfInterest {
    final I img;
    final ThreadLocal<RandomAccess<T>> randomAccess;
    long cached_size = -1L;
    long[] firstRelPos;
    long[] minima;
    long[] maxima;
    double[] origin;

    public BinaryMaskRegionOfInterest(I img) {
        super(img.numDimensions());
        this.img = img;
        this.origin = new double[img.numDimensions()];
        this.randomAccess = new ThreadLocal<RandomAccess<T>>((RandomAccessibleInterval)img){
            final /* synthetic */ RandomAccessibleInterval val$img;
            {
                this.val$img = randomAccessibleInterval;
            }

            @Override
            protected RandomAccess<T> initialValue() {
                return this.val$img.randomAccess();
            }
        };
    }

    public <TT extends Type<TT>> IterableInterval<TT> getIterableIntervalOverROI(RandomAccessible<TT> src) {
        return new BMROIIterableInterval(src.randomAccess());
    }

    @Override
    public boolean contains(double[] position) {
        this.validate();
        for (int i = 0; i < this.numDimensions(); ++i) {
            long lPosition = (long)(position[i] - this.origin[i]);
            if (lPosition < this.minima[i] || lPosition > this.maxima[i]) {
                return false;
            }
            this.randomAccess.get().setPosition(lPosition, i);
        }
        return ((BitType)this.randomAccess.get().get()).get();
    }

    @Override
    protected void getRealExtrema(double[] min, double[] max) {
        this.validate();
        for (int i = 0; i < this.numDimensions(); ++i) {
            min[i] = (double)this.minima[i] + this.origin[i];
            max[i] = (double)this.maxima[i] + this.origin[i];
        }
    }

    protected long getCachedSize() {
        this.validate();
        return this.cached_size;
    }

    protected long[] getFirstPosition() {
        long[] pos = this.getFirstRelativePosition();
        for (int i = 0; i < pos.length; ++i) {
            int n = i;
            pos[n] = (long)((double)pos[n] + this.origin[i]);
        }
        return pos;
    }

    protected long[] getFirstRelativePosition() {
        this.validate();
        return this.firstRelPos;
    }

    protected void validate() {
        if (this.cached_size == -1L) {
            this.cached_size = 0L;
            this.minima = new long[this.numDimensions()];
            this.maxima = new long[this.numDimensions()];
            Cursor c = Views.iterable(this.img).localizingCursor();
            while (c.hasNext()) {
                if (!((BitType)c.next()).get()) continue;
                this.cached_size = 1L;
                this.firstRelPos = new long[this.numDimensions()];
                c.localize(this.firstRelPos);
                c.localize(this.minima);
                c.localize(this.maxima);
                break;
            }
            while (c.hasNext()) {
                if (!((BitType)c.next()).get()) continue;
                ++this.cached_size;
                for (int i = 0; i < this.numDimensions(); ++i) {
                    long pos = c.getLongPosition(i);
                    this.minima[i] = Math.min(this.minima[i], pos);
                    this.maxima[i] = Math.max(this.maxima[i], pos);
                }
            }
        }
    }

    @Override
    public void move(double displacement, int d) {
        int n = d;
        this.origin[n] = this.origin[n] + displacement;
    }

    public I getImg() {
        return this.img;
    }

    public double[] getOrigin() {
        return this.origin;
    }

    protected class BMROIIterableInterval<TT extends Type<TT>>
    implements IterableInterval<TT> {
        final RandomAccess<TT> src;

        protected BMROIIterableInterval(RandomAccess<TT> src) {
            this.src = src;
        }

        public long size() {
            return BinaryMaskRegionOfInterest.this.getCachedSize();
        }

        public TT firstElement() {
            this.src.setPosition(BinaryMaskRegionOfInterest.this.getFirstRelativePosition());
            return (TT)((Type)this.src.get());
        }

        public TT getType() {
            return (TT)((Type)this.src.getType());
        }

        public Object iterationOrder() {
            return new BMROIIterationOrder();
        }

        public double realMin(int d) {
            return BinaryMaskRegionOfInterest.this.img.realMin(d) + BinaryMaskRegionOfInterest.this.origin[d];
        }

        public void realMin(double[] min) {
            BinaryMaskRegionOfInterest.this.img.realMin(min);
            for (int i = 0; i < min.length; ++i) {
                int n = i;
                min[n] = min[n] + BinaryMaskRegionOfInterest.this.origin[i];
            }
        }

        public void realMin(RealPositionable min) {
            BinaryMaskRegionOfInterest.this.img.realMin(min);
            min.move(BinaryMaskRegionOfInterest.this.origin);
        }

        public double realMax(int d) {
            return BinaryMaskRegionOfInterest.this.img.realMax(d) + BinaryMaskRegionOfInterest.this.origin[d];
        }

        public void realMax(double[] max) {
            BinaryMaskRegionOfInterest.this.img.realMax(max);
            for (int i = 0; i < max.length; ++i) {
                int n = i;
                max[n] = max[n] + BinaryMaskRegionOfInterest.this.origin[i];
            }
        }

        public void realMax(RealPositionable max) {
            BinaryMaskRegionOfInterest.this.img.realMax(max);
            max.move(BinaryMaskRegionOfInterest.this.origin);
        }

        public int numDimensions() {
            return BinaryMaskRegionOfInterest.this.numDimensions();
        }

        public Iterator<TT> iterator() {
            return new BMROICursor();
        }

        public long min(int d) {
            BinaryMaskRegionOfInterest.this.validate();
            return BinaryMaskRegionOfInterest.this.minima[d] + (long)BinaryMaskRegionOfInterest.this.origin[d];
        }

        public void min(long[] min) {
            BinaryMaskRegionOfInterest.this.validate();
            for (int i = 0; i < this.numDimensions(); ++i) {
                min[i] = BinaryMaskRegionOfInterest.this.minima[i] + (long)BinaryMaskRegionOfInterest.this.origin[i];
            }
        }

        public void min(Positionable min) {
            BinaryMaskRegionOfInterest.this.validate();
            for (int i = 0; i < min.numDimensions(); ++i) {
                min.setPosition(BinaryMaskRegionOfInterest.this.minima[i] + (long)BinaryMaskRegionOfInterest.this.origin[i], i);
            }
        }

        public long max(int d) {
            BinaryMaskRegionOfInterest.this.validate();
            return BinaryMaskRegionOfInterest.this.maxima[d] + (long)BinaryMaskRegionOfInterest.this.origin[d];
        }

        public void max(long[] max) {
            BinaryMaskRegionOfInterest.this.validate();
            for (int i = 0; i < this.numDimensions(); ++i) {
                max[i] = BinaryMaskRegionOfInterest.this.maxima[i] + (long)BinaryMaskRegionOfInterest.this.origin[i];
            }
        }

        public void max(Positionable max) {
            BinaryMaskRegionOfInterest.this.validate();
            for (int i = 0; i < max.numDimensions(); ++i) {
                max.setPosition(BinaryMaskRegionOfInterest.this.maxima[i] + (long)BinaryMaskRegionOfInterest.this.origin[i], i);
            }
        }

        public void dimensions(long[] dimensions) {
            BinaryMaskRegionOfInterest.this.img.dimensions(dimensions);
        }

        public long dimension(int d) {
            return BinaryMaskRegionOfInterest.this.img.dimension(d);
        }

        public Cursor<TT> cursor() {
            return new BMROICursor();
        }

        public Cursor<TT> localizingCursor() {
            return new BMROICursor();
        }

        protected class BMROICursor
        extends AbstractCursor<TT> {
            boolean nextIsValid;
            boolean cursorHasNext;
            Cursor<T> cursor;
            final long[] position;

            protected BMROICursor() {
                super(BMROIIterableInterval.this.numDimensions());
                this.cursor = Views.iterable(BinaryMaskRegionOfInterest.this.img).localizingCursor();
                this.position = new long[BMROIIterableInterval.this.numDimensions()];
            }

            public TT get() {
                BMROIIterableInterval.this.src.setPosition((Localizable)this);
                return (Type)BMROIIterableInterval.this.src.get();
            }

            public TT getType() {
                return (Type)BMROIIterableInterval.this.src.getType();
            }

            public void fwd() {
                this.validateNext();
                this.cursor.localize(this.position);
                this.nextIsValid = false;
            }

            public void reset() {
                this.cursor.reset();
                this.nextIsValid = false;
            }

            public boolean hasNext() {
                this.validateNext();
                return this.cursorHasNext;
            }

            public void localize(long[] pos) {
                for (int i = 0; i < this.numDimensions(); ++i) {
                    pos[i] = this.position[i] + (long)BinaryMaskRegionOfInterest.this.origin[i];
                }
            }

            public long getLongPosition(int d) {
                return this.position[d] + (long)BinaryMaskRegionOfInterest.this.origin[d];
            }

            public AbstractCursor<TT> copy() {
                return this.copyCursor();
            }

            public AbstractCursor<TT> copyCursor() {
                BMROICursor c = new BMROICursor();
                c.cursor = this.cursor.copyCursor();
                System.arraycopy(this.position, 0, c.position, 0, this.numDimensions());
                c.nextIsValid = this.nextIsValid;
                return c;
            }

            private void validateNext() {
                if (!this.nextIsValid) {
                    while (this.cursor.hasNext()) {
                        if (!((BitType)this.cursor.next()).get()) continue;
                        this.nextIsValid = true;
                        this.cursorHasNext = true;
                        return;
                    }
                    this.nextIsValid = true;
                    this.cursorHasNext = false;
                }
            }
        }
    }

    protected class BMROIIterationOrder {
        protected BMROIIterationOrder() {
        }

        protected I getImg() {
            return BinaryMaskRegionOfInterest.this.img;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BMROIIterationOrder)) {
                return false;
            }
            BMROIIterationOrder o = (BMROIIterationOrder)obj;
            return o.getImg() == this.getImg();
        }
    }
}

