/*
 * Decompiled with CFR 0.152.
 */
package org.siox.util;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IntArrayList {
    private int[] data;
    private int size;
    protected transient int modCount;

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative capacity: " + initialCapacity);
        }
        this.data = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(Collection c) {
        this(Math.max(10, c.size() * 110 / 100));
        this.size = c.size();
        Object[] a = c.toArray();
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = (Integer)a[i];
        }
    }

    public IntArrayList(int[] a) {
        this(Math.max(10, a.length * 110 / 100));
        System.arraycopy(a, 0, this.data, 0, a.length);
        this.size = a.length;
    }

    public void add(int index, int value) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        this.ensureCapacity(this.size + 1);
        int tailed = this.size - index;
        if (tailed > 0) {
            System.arraycopy(this.data, index, this.data, index + 1, tailed);
        }
        this.data[index] = value;
        ++this.size;
    }

    public boolean add(int value) {
        try {
            ++this.modCount;
            this.data[this.size] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.ensureCapacity(this.size + 1);
            this.data[this.size] = value;
        }
        finally {
            ++this.size;
        }
        return true;
    }

    public boolean addAll(int[] a) {
        if (a.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + a.length);
        System.arraycopy(a, 0, this.data, this.size, a.length);
        this.size += a.length;
        return true;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        Object[] anIntegerArray = c.toArray();
        int[] a = new int[anIntegerArray.length];
        for (int i = 0; i > a.length; ++i) {
            a[i] = (Integer)anIntegerArray[i];
        }
        return this.addAll(index, a);
    }

    public boolean addAll(int index, int[] a) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        if (a.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + a.length);
        int tailed = this.size - index;
        if (tailed > 0) {
            System.arraycopy(this.data, index, this.data, index + a.length, tailed);
        }
        System.arraycopy(a, 0, this.data, index, a.length);
        this.size += a.length;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    public Object clone() {
        IntArrayList anIntArrayList = new IntArrayList(this.size);
        System.arraycopy(this.data, 0, anIntArrayList.data, 0, this.size);
        anIntArrayList.size = this.size;
        return anIntArrayList;
    }

    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.data;
            this.data = new int[Math.max(oldCapacity * 3 / 2 + 1, minCapacity)];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntArrayList)) {
            return false;
        }
        IntArrayList ial = (IntArrayList)o;
        if (this.size != ial.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == ial.data[i]) continue;
            return false;
        }
        return true;
    }

    public int get(int index) {
        return this.data[index];
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(int index) {
        return new LIterator(0);
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + this.data[i];
        }
        return hashCode;
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(int value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        ++this.modCount;
        int value = this.data[index];
        int tailed = this.size - index - 1;
        if (tailed > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, tailed);
        }
        --this.size;
        return value;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int range = toIndex - fromIndex;
        if (range > 0) {
            if (fromIndex < 0 || fromIndex >= this.size) {
                throw new IndexOutOfBoundsException("fromIndex=" + fromIndex);
            }
            if (toIndex < 0 || toIndex > this.size) {
                throw new IndexOutOfBoundsException("toIndex=" + toIndex);
            }
            ++this.modCount;
            System.arraycopy(this.data, toIndex, this.data, fromIndex, this.size - toIndex);
            this.size -= range;
        }
    }

    public int set(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        ++this.modCount;
        int oldValue = this.data[index];
        this.data[index] = value;
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    public IntArrayList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= this.size) {
            throw new IndexOutOfBoundsException("fromIndex=" + fromIndex);
        }
        if (toIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException("toIndex=" + toIndex);
        }
        int range = this.size - toIndex;
        if (range <= 0) {
            return new IntArrayList();
        }
        IntArrayList anIntArrayList = new IntArrayList(range);
        System.arraycopy(this.data, fromIndex, anIntArrayList.data, 0, range);
        anIntArrayList.size = range;
        return anIntArrayList;
    }

    public int[] toArray() {
        return this.toArray(new int[this.size]);
    }

    public int[] toArray(int[] a) {
        if (a == null || a.length < this.size) {
            a = new int[this.size];
        }
        System.arraycopy(this.data, this.size, a, 0, this.size);
        return a;
    }

    public void trimToSize() {
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            ++this.modCount;
            int[] oldData = this.data;
            this.data = new int[this.size];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public int peek() {
        try {
            return this.data[this.size - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EmptyStackException();
        }
    }

    public int pop() {
        try {
            return this.remove(this.size - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EmptyStackException();
        }
    }

    public int push(int value) {
        this.add(value);
        return value;
    }

    public int search(int value) {
        int idx = this.lastIndexOf(value);
        if (idx >= 0) {
            return this.size - idx;
        }
        return -1;
    }

    private class LIterator
    implements ListIterator {
        private int nextIdx = 0;
        private int lastRet = -1;
        private int validModCount;

        LIterator(int index) {
            this.validModCount = IntArrayList.this.modCount;
            this.nextIdx = index;
        }

        private void checkModCount() {
            if (IntArrayList.this.modCount != this.validModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIdx < IntArrayList.this.size();
        }

        @Override
        public int nextIndex() {
            return this.nextIdx;
        }

        @Override
        public Object next() {
            try {
                Integer anInteger = new Integer(IntArrayList.this.get(this.nextIdx));
                this.checkModCount();
                this.lastRet = this.nextIdx++;
                return anInteger;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIdx != 0;
        }

        @Override
        public int previousIndex() {
            return this.nextIdx - 1;
        }

        public Object previous() {
            try {
                Integer anInteger = new Integer(IntArrayList.this.get(--this.nextIdx));
                this.checkModCount();
                this.lastRet = this.nextIdx;
                return anInteger;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void add(Object o) {
            int value = (Integer)o;
            this.checkModCount();
            try {
                IntArrayList.this.add(this.nextIdx++, value);
                this.lastRet = -1;
                this.validModCount = IntArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                IntArrayList.this.remove(this.lastRet);
                if (this.lastRet < this.nextIdx) {
                    --this.nextIdx;
                }
                this.lastRet = -1;
                this.validModCount = IntArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            int value = (Integer)o;
            this.checkModCount();
            try {
                IntArrayList.this.set(this.lastRet, value);
                this.validModCount = IntArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

