/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.J3dNotification;
import org.scijava.java3d.RenderingError;
import org.scijava.java3d.ShaderError;
import org.scijava.java3d.VirtualUniverse;

class NotificationThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private volatile boolean running = true;
    private boolean waiting = false;
    private boolean ready = false;
    private ArrayList<J3dNotification> notificationQueue = new ArrayList();

    NotificationThread(ThreadGroup t) {
        super(t, "J3D-NotificationThread");
    }

    synchronized void addNotification(J3dNotification n) {
        this.notificationQueue.add(n);
        this.runMonitor(1);
    }

    private synchronized J3dNotification[] getNotifications() {
        J3dNotification[] n = new J3dNotification[this.notificationQueue.size()];
        n = this.notificationQueue.toArray(n);
        this.notificationQueue.clear();
        return n;
    }

    private void processNotifications() {
        J3dNotification[] notifications = this.getNotifications();
        block4: for (int i = 0; i < notifications.length; ++i) {
            J3dNotification n = notifications[i];
            switch (n.type) {
                case 0: {
                    n.universe.notifyShaderErrorListeners((ShaderError)n.args[0]);
                    continue block4;
                }
                case 1: {
                    VirtualUniverse.notifyRenderingErrorListeners((RenderingError)n.args[0]);
                    continue block4;
                }
                default: {
                    System.err.println("J3dNotification.processNotifications: unrecognized type = " + n.type);
                }
            }
        }
    }

    void finish() {
        this.runMonitor(2);
    }

    @Override
    public void run() {
        while (this.running) {
            this.runMonitor(0);
            this.processNotifications();
        }
    }

    private synchronized void runMonitor(int action) {
        switch (action) {
            case 0: {
                while (this.running && !this.ready) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

