/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ops.function.Function;
import net.imglib2.type.numeric.RealType;

@Deprecated
public class RealBilinearInterpolatingFunction<T extends RealType<T>>
implements Function<double[], T> {
    private Function<long[], T> discreteFunc;
    private long[] index;
    private T ul;
    private T ur;
    private T ll;
    private T lr;

    public RealBilinearInterpolatingFunction(Function<long[], T> discreteFunc) {
        this.discreteFunc = discreteFunc;
        this.index = null;
        this.ul = this.createOutput();
        this.ur = this.createOutput();
        this.ll = this.createOutput();
        this.lr = this.createOutput();
    }

    @Override
    public void compute(double[] point, T output) {
        if (this.index == null) {
            this.index = new long[point.length];
        }
        long x = (long)Math.floor(point[0]);
        long y = (long)Math.floor(point[1]);
        double ix = point[0] - (double)x;
        double iy = point[1] - (double)y;
        this.getValue(x + 0L, y + 0L, this.ul);
        this.getValue(x + 1L, y + 0L, this.ur);
        this.getValue(x + 0L, y + 1L, this.ll);
        this.getValue(x + 1L, y + 1L, this.lr);
        double value = this.interpolate(ix, iy, this.ul.getRealDouble(), this.ur.getRealDouble(), this.ll.getRealDouble(), this.lr.getRealDouble());
        output.setReal(value);
    }

    public RealBilinearInterpolatingFunction<T> copy() {
        return new RealBilinearInterpolatingFunction<T>(this.discreteFunc.copy());
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.discreteFunc.createOutput());
    }

    private double interpolate(double ix, double iy, double ul, double ur, double ll, double lr) {
        double value = 0.0;
        value += (1.0 - ix) * (1.0 - iy) * ul;
        value += (1.0 - ix) * iy * ll;
        value += ix * (1.0 - iy) * ur;
        return value += ix * iy * lr;
    }

    private void getValue(long x, long y, T output) {
        this.index[0] = x;
        this.index[1] = y;
        this.discreteFunc.compute(this.index, output);
    }
}

