/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.gui.SignedByteBuffer;
import io.scif.gui.SignedShortBuffer;
import io.scif.gui.UnsignedIntBuffer;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;

public class BufferedImageTools {
    public static int getPixelType(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        if (raster == null) {
            return -1;
        }
        DataBuffer buffer = raster.getDataBuffer();
        if (buffer == null) {
            return -1;
        }
        if (buffer instanceof SignedByteBuffer) {
            return 0;
        }
        if (buffer instanceof SignedShortBuffer) {
            return 2;
        }
        if (buffer instanceof UnsignedIntBuffer) {
            return 5;
        }
        int type = buffer.getDataType();
        int imageType = image.getType();
        switch (type) {
            case 0: {
                return 1;
            }
            case 5: {
                return 7;
            }
            case 4: {
                return 6;
            }
            case 3: {
                if (imageType == 1 || imageType == 4 || imageType == 2) {
                    return 1;
                }
                if (buffer instanceof UnsignedIntBuffer) {
                    return 5;
                }
                return 4;
            }
            case 2: {
                return 2;
            }
            case 1: {
                if (imageType == 9 || imageType == 8) {
                    return 1;
                }
                return 3;
            }
        }
        return -1;
    }
}

