/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.Format;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.SCIFIO;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImageRegion;
import io.scif.img.ImgIOException;
import io.scif.img.ImgUtilityService;
import io.scif.img.Range;
import io.scif.img.SCIFIOImgPlus;
import java.io.IOException;
import net.imagej.ImgPlus;
import net.imagej.axis.Axis;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.Bytes;

@Plugin(type=Service.class)
public class DefaultImgUtilityService
extends AbstractService
implements ImgUtilityService {
    private SCIFIO scifio = null;

    @Override
    public long[] getDimLengths(Metadata m, int imageIndex, SCIFIOConfig config) {
        long[] dimLengths = m.get(imageIndex).getAxesLengths();
        ImageRegion region = config.imgOpenerGetRegion();
        for (int i = 0; i < dimLengths.length; ++i) {
            Range range;
            if (region == null || i >= region.size() || (range = region.getRange(m.get(imageIndex).getAxis(i).type())) == null) continue;
            dimLengths[i] = range.size();
        }
        return dimLengths;
    }

    @Override
    public long[] getConstrainedLengths(Metadata m, int imageIndex, SCIFIOConfig config) {
        long[] lengths = this.getDimLengths(m, imageIndex, config);
        ImageRegion r = config.imgOpenerGetRegion();
        if (r != null) {
            for (CalibratedAxis t : m.get(0).getAxes()) {
                Range range = r.getRange(t.type());
                if (range == null) continue;
                lengths[m.get((int)0).getAxisIndex((CalibratedAxis)t)] = range.size();
            }
        }
        return lengths;
    }

    @Override
    public int getImageCount(Location source) throws ImgIOException {
        try {
            Format format = this.scifio().format().getFormat(source);
            return format.createParser().parse(source).getImageCount();
        }
        catch (FormatException | IOException e) {
            throw new ImgIOException(e);
        }
    }

    @Override
    public PlanarAccess<ArrayDataAccess<?>> getPlanarAccess(ImgPlus<?> img) {
        if (img.getImg() instanceof PlanarAccess) {
            return (PlanarAccess)img.getImg();
        }
        return null;
    }

    @Override
    public ArrayImg<?, ?> getArrayAccess(ImgPlus<?> img) {
        if (img.getImg() instanceof ArrayImg) {
            return (ArrayImg)img.getImg();
        }
        return null;
    }

    @Override
    public Type<?> makeType(int pixelType) {
        UnsignedByteType type;
        switch (pixelType) {
            case 1: {
                type = new UnsignedByteType();
                break;
            }
            case 0: {
                type = new ByteType();
                break;
            }
            case 3: {
                type = new UnsignedShortType();
                break;
            }
            case 2: {
                type = new ShortType();
                break;
            }
            case 5: {
                type = new UnsignedIntType();
                break;
            }
            case 4: {
                type = new IntType();
                break;
            }
            case 6: {
                type = new FloatType();
                break;
            }
            case 7: {
                type = new DoubleType();
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    @Override
    public int makeType(Object type) throws ImgIOException {
        int pixelType = 1;
        if (type instanceof UnsignedByteType) {
            pixelType = 1;
        } else if (type instanceof ByteType) {
            pixelType = 0;
        } else if (type instanceof UnsignedShortType) {
            pixelType = 3;
        } else if (type instanceof ShortType) {
            pixelType = 2;
        } else if (type instanceof UnsignedIntType) {
            pixelType = 5;
        } else if (type instanceof IntType) {
            pixelType = 4;
        } else if (type instanceof FloatType) {
            pixelType = 6;
        } else if (type instanceof DoubleType) {
            pixelType = 7;
        } else {
            throw new ImgIOException("Pixel type not supported. Please convert your image to a supported type.");
        }
        return pixelType;
    }

    @Override
    public ArrayDataAccess<?> makeArray(Object array) {
        Object access = array instanceof byte[] ? new ByteArray((byte[])array) : (array instanceof char[] ? new CharArray((char[])array) : (array instanceof double[] ? new DoubleArray((double[])array) : (array instanceof int[] ? new IntArray((int[])array) : (array instanceof float[] ? new FloatArray((float[])array) : (array instanceof short[] ? new ShortArray((short[])array) : (array instanceof long[] ? new LongArray((long[])array) : null))))));
        return access;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean isCompressible(Img<T> img) {
        return this.isCompressible(ImgPlus.wrap(img));
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean isCompressible(ImgPlus<T> img) {
        CalibratedAxis[] axes = new CalibratedAxis[img.numDimensions()];
        img.axes((Axis[])axes);
        long[] axisLengths = new long[5];
        long[] oldLengths = new long[img.numDimensions()];
        img.dimensions(oldLengths);
        boolean foundUnknown = false;
        block3: for (int i = 0; i < axes.length; ++i) {
            CalibratedAxis axis = axes[i];
            switch (axis.type().getLabel().toUpperCase().charAt(0)) {
                case 'C': 
                case 'T': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    continue block3;
                }
                default: {
                    if (oldLengths[i] <= 1L) continue block3;
                    foundUnknown = true;
                }
            }
        }
        if (!foundUnknown) {
            return false;
        }
        String dimOrder = this.guessDimOrder(axes, oldLengths, axisLengths);
        return dimOrder != null;
    }

    @Override
    public String guessDimOrder(CalibratedAxis[] axes, long[] dimLengths, long[] newLengths) {
        int i;
        String oldOrder = "";
        String newOrder = "";
        for (int i2 = 0; i2 < newLengths.length; ++i2) {
            newLengths[i2] = 1L;
        }
        boolean[] haveDim = new boolean[5];
        int contiguousUnknown = 0;
        int missingAxisCount = 0;
        boolean unknownBlock = false;
        block18: for (int i3 = 0; i3 < axes.length; ++i3) {
            switch (axes[i3].type().getLabel().toUpperCase().charAt(0)) {
                case 'X': {
                    oldOrder = oldOrder + "X";
                    haveDim[0] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'Y': {
                    oldOrder = oldOrder + "Y";
                    haveDim[1] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'Z': {
                    oldOrder = oldOrder + "Z";
                    haveDim[2] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'C': {
                    oldOrder = oldOrder + "C";
                    haveDim[3] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'T': {
                    oldOrder = oldOrder + "T";
                    haveDim[4] = true;
                    unknownBlock = false;
                    continue block18;
                }
                default: {
                    oldOrder = oldOrder + "U";
                    if (dimLengths[i3] <= 1L || unknownBlock) continue block18;
                    unknownBlock = true;
                    ++contiguousUnknown;
                }
            }
        }
        for (boolean d : haveDim) {
            if (d) continue;
            ++missingAxisCount;
        }
        if (contiguousUnknown > missingAxisCount) {
            return null;
        }
        int axesPlaced = 0;
        unknownBlock = false;
        boolean sizeOneUnknown = false;
        block20: for (i = 0; i < axes.length; ++i) {
            switch (oldOrder.charAt(0)) {
                case 'U': {
                    if (dimLengths[i] <= 1L && contiguousUnknown >= missingAxisCount) continue block20;
                    if (!unknownBlock) {
                        unknownBlock = true;
                        if (contiguousUnknown < missingAxisCount) {
                            ++contiguousUnknown;
                            sizeOneUnknown = true;
                        }
                        if (!haveDim[0]) {
                            newOrder = newOrder + "X";
                            haveDim[0] = true;
                        } else if (!haveDim[1]) {
                            newOrder = newOrder + "Y";
                            haveDim[1] = true;
                        } else if (!haveDim[2]) {
                            newOrder = newOrder + "Z";
                            haveDim[2] = true;
                        } else if (!haveDim[3]) {
                            newOrder = newOrder + "C";
                            haveDim[3] = true;
                        } else if (!haveDim[4]) {
                            newOrder = newOrder + "T";
                            haveDim[4] = true;
                        }
                    } else if (dimLengths[i] > 1L && sizeOneUnknown) {
                        sizeOneUnknown = false;
                        --contiguousUnknown;
                    }
                    int n = axesPlaced;
                    newLengths[n] = newLengths[n] * dimLengths[i];
                    continue block20;
                }
                default: {
                    if (unknownBlock) {
                        ++axesPlaced;
                        unknownBlock = false;
                        sizeOneUnknown = false;
                    }
                    newOrder = newOrder + oldOrder.charAt(i);
                    newLengths[axesPlaced] = dimLengths[i];
                    ++axesPlaced;
                }
            }
        }
        block21: for (i = 0; i < haveDim.length; ++i) {
            if (haveDim[i]) continue;
            switch (i) {
                case 0: {
                    newOrder = newOrder + "X";
                    continue block21;
                }
                case 1: {
                    newOrder = newOrder + "Y";
                    continue block21;
                }
                case 2: {
                    newOrder = newOrder + "Z";
                    continue block21;
                }
                case 3: {
                    newOrder = newOrder + "C";
                    continue block21;
                }
                case 4: {
                    newOrder = newOrder + "T";
                }
            }
        }
        return newOrder;
    }

    @Override
    public double decodeWord(byte[] plane, int index, int pixelType, boolean little) {
        double value;
        switch (pixelType) {
            case 1: {
                value = plane[index] & 0xFF;
                break;
            }
            case 0: {
                value = plane[index];
                break;
            }
            case 3: {
                value = Bytes.toShort((byte[])plane, (int)(2 * index), (int)2, (boolean)little) & 0xFFFF;
                break;
            }
            case 2: {
                value = Bytes.toShort((byte[])plane, (int)(2 * index), (int)2, (boolean)little);
                break;
            }
            case 5: {
                value = (long)Bytes.toInt((byte[])plane, (int)(4 * index), (int)4, (boolean)little) & 0xFFFFFFFFL;
                break;
            }
            case 4: {
                value = Bytes.toInt((byte[])plane, (int)(4 * index), (int)4, (boolean)little);
                break;
            }
            case 6: {
                value = Bytes.toFloat((byte[])plane, (int)(4 * index), (int)4, (boolean)little);
                break;
            }
            case 7: {
                value = Bytes.toDouble((byte[])plane, (int)(8 * index), (int)8, (boolean)little);
                break;
            }
            default: {
                value = Double.NaN;
            }
        }
        return value;
    }

    @Override
    public <T> SCIFIOImgPlus<T> makeSCIFIOImgPlus(Img<T> img) {
        if (img instanceof SCIFIOImgPlus) {
            return (SCIFIOImgPlus)img;
        }
        if (img instanceof ImgPlus) {
            return new SCIFIOImgPlus((ImgPlus)img);
        }
        return new SCIFIOImgPlus<T>(img);
    }

    private SCIFIO scifio() {
        if (this.scifio == null) {
            this.scifio = new SCIFIO(this.getContext());
        }
        return this.scifio;
    }
}

