/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.filters.MetadataWrapper;
import io.scif.img.cell.SCIFIOCellImg;
import java.io.IOException;
import net.imagej.ImgPlus;
import net.imagej.ImgPlusMetadata;
import net.imagej.axis.AxisType;
import net.imglib2.display.ColorTable;
import net.imglib2.img.Img;
import org.scijava.Disposable;

public class SCIFIOImgPlus<T>
extends ImgPlus<T>
implements Disposable {
    public static final String GLOBAL_META = "scifio.metadata.global";
    public static final String IMAGE_META = "scifio.metadata.image";

    public SCIFIOImgPlus(Img<T> img) {
        super(img);
    }

    public SCIFIOImgPlus(Img<T> img, String name) {
        super(img, name);
    }

    public SCIFIOImgPlus(Img<T> img, String name, AxisType[] axes) {
        super(img, name, axes);
    }

    public SCIFIOImgPlus(Img<T> img, ImgPlusMetadata metadata) {
        super(img, metadata);
    }

    public SCIFIOImgPlus(Img<T> img, String name, AxisType[] axes, double[] cal) {
        super(img, name, axes, cal);
    }

    public SCIFIOImgPlus(ImgPlus<T> imgPlus) {
        this((Img<T>)imgPlus.getImg(), (ImgPlusMetadata)imgPlus);
    }

    public Metadata getMetadata() {
        return (Metadata)this.getProperties().get(GLOBAL_META);
    }

    public void setMetadata(Metadata meta) {
        this.getProperties().put(GLOBAL_META, meta);
    }

    public ImageMetadata getImageMetadata() {
        return (ImageMetadata)this.getProperties().get(IMAGE_META);
    }

    public void setImageMetadata(ImageMetadata imageMeta) {
        this.getProperties().put(IMAGE_META, imageMeta);
    }

    public ColorTable getColorTable(int planeIndex) {
        return this.getColorTable(0, planeIndex);
    }

    public ColorTable getColorTable(int imageIndex, int planeIndex) {
        ColorTable table = super.getColorTable(planeIndex);
        if (table == null && SCIFIOCellImg.class.isAssignableFrom(this.getImg().getClass())) {
            try {
                table = ((SCIFIOCellImg)this.getImg()).getColorTable(imageIndex, planeIndex);
            }
            catch (FormatException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            this.setColorTable(table, planeIndex);
        }
        return table;
    }

    public SCIFIOImgPlus<T> copy() {
        SCIFIOImgPlus<T> copy = new SCIFIOImgPlus<T>(this.getImg().copy(), (ImgPlusMetadata)this);
        copy.setMetadata(this.getMetadata());
        return copy;
    }

    public void dispose() {
        Img img = this.getImg();
        if (img instanceof Disposable) {
            ((Disposable)img).dispose();
        }
    }

    void setROIsAndTablesProperties(Metadata meta, int index) {
        boolean tablesSet;
        boolean roisSet = this.getProperties().get("rois") != null;
        boolean bl = tablesSet = this.getProperties().get("tables") != null;
        if (roisSet && tablesSet) {
            return;
        }
        if (!roisSet) {
            this.getProperties().put("rois", meta.get(index).getROIs());
        }
        if (!tablesSet) {
            this.getProperties().put("tables", meta.get(index).getTables());
        }
        if (meta instanceof MetadataWrapper) {
            this.setROIsAndTablesProperties(((MetadataWrapper)meta).unwrap(), index);
        }
    }
}

