/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewSetup;
import spim.process.fusion.export.ImgTitler;

public class XMLTIFFImgTitler
implements ImgTitler {
    final List<TimePoint> timepoints;
    final List<ViewSetup> viewSetups;

    public XMLTIFFImgTitler(List<TimePoint> newTimepoints, List<ViewSetup> newViewSetups) {
        this.timepoints = newTimepoints;
        this.viewSetups = newViewSetups;
    }

    @Override
    public String getImageTitle(TimePoint tp, ViewSetup vs) {
        String filename = "img";
        if (this.timepoints.size() > 1) {
            filename = filename + "_TL" + tp.getId();
        }
        if (XMLTIFFImgTitler.getAllChannels(this.viewSetups).size() > 1) {
            filename = filename + "_Ch" + vs.getChannel().getName();
        }
        if (XMLTIFFImgTitler.getAllIlluminations(this.viewSetups).size() > 1) {
            filename = filename + "_Ill" + vs.getIllumination().getName();
        }
        if (XMLTIFFImgTitler.getAllAngles(this.viewSetups).size() > 1) {
            filename = filename + "_Angle" + vs.getAngle().getName();
        }
        return filename;
    }

    public static Set<Angle> getAllAngles(List<ViewSetup> viewSetups) {
        HashSet<Angle> angles = new HashSet<Angle>();
        for (ViewSetup v : viewSetups) {
            angles.add(v.getAngle());
        }
        return angles;
    }

    public static Set<Channel> getAllChannels(List<ViewSetup> viewSetups) {
        HashSet<Channel> channels = new HashSet<Channel>();
        for (ViewSetup v : viewSetups) {
            channels.add(v.getChannel());
        }
        return channels;
    }

    public static Set<Illumination> getAllIlluminations(List<ViewSetup> viewSetups) {
        HashSet<Illumination> illums = new HashSet<Illumination>();
        for (ViewSetup v : viewSetups) {
            illums.add(v.getIllumination());
        }
        return illums;
    }
}

