/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.geometricdescriptor;

import ij.gui.GenericDialog;
import java.util.List;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.plugin.interestpointregistration.InterestPointRegistration;
import spim.fiji.spimdata.SpimData2;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.RANSACParameters;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.geometricdescriptor.RGLDMPairwise;
import spim.process.interestpointregistration.geometricdescriptor.RGLDMParameters;

public class RGLDM
extends InterestPointRegistration {
    public static int defaultModel = 2;
    public static boolean defaultRegularize = true;
    protected TransformationModel model = null;
    protected RGLDMParameters parameters;
    protected RANSACParameters ransacParams;

    public RGLDM(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        super(spimData, viewIdsToProcess, channelsToProcess);
    }

    protected RGLDMPairwise pairwiseMatchingInstance(PairwiseMatch pair, String description) {
        return new RGLDMPairwise(pair, this.model, description, this.ransacParams, this.parameters);
    }

    @Override
    protected TransformationModel getTransformationModel() {
        return this.model;
    }

    @Override
    public RGLDM newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        return new RGLDM(spimData, viewIdsToProcess, channelsToProcess);
    }

    @Override
    public String getDescription() {
        return "Redundant geometric local descriptor matching (translation invariant)";
    }

    @Override
    public void addQuery(GenericDialog gd, Interest_Point_Registration.RegistrationType registrationType) {
        gd.addChoice("Transformation model", TransformationModel.modelChoice, TransformationModel.modelChoice[defaultModel]);
        gd.addCheckbox("Regularize_model", defaultRegularize);
        gd.addSlider("Number_of_neighbors for the descriptors", 3.0, 10.0, (double)RGLDMParameters.numNeighbors);
        gd.addSlider("Redundancy for descriptor matching", 0.0, 10.0, (double)RGLDMParameters.redundancy);
        gd.addSlider("Significance required for a descriptor match", 1.0, 10.0, (double)RGLDMParameters.ratioOfDistance);
        gd.addSlider("Allowed_error_for_RANSAC (px)", 0.5, 20.0, (double)RANSACParameters.max_epsilon);
    }

    @Override
    public boolean parseDialog(GenericDialog gd, Interest_Point_Registration.RegistrationType registrationType) {
        defaultModel = gd.getNextChoiceIndex();
        this.model = new TransformationModel(defaultModel);
        defaultRegularize = gd.getNextBoolean();
        if (defaultRegularize && !this.model.queryRegularizedModel()) {
            return false;
        }
        int numNeighbors = RGLDMParameters.numNeighbors = (int)Math.round(gd.getNextNumber());
        int redundancy = RGLDMParameters.redundancy = (int)Math.round(gd.getNextNumber());
        float significance = RGLDMParameters.ratioOfDistance = (float)gd.getNextNumber();
        float maxEpsilon = RANSACParameters.max_epsilon = (float)gd.getNextNumber();
        this.parameters = new RGLDMParameters(RGLDMParameters.differenceThreshold, significance, numNeighbors, redundancy);
        this.ransacParams = new RANSACParameters(maxEpsilon, RANSACParameters.min_inlier_ratio, RANSACParameters.min_inlier_factor, RANSACParameters.num_iterations);
        return true;
    }
}

