/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.registrationstatistics;

import java.util.List;
import spim.process.interestpointregistration.PairwiseMatch;

public class RegistrationStatistics
implements Comparable<RegistrationStatistics> {
    double minError = 0.0;
    double avgError = 0.0;
    double maxError = 0.0;
    double minRatio = 1.0;
    double maxRatio = 0.0;
    double avgRatio = 0.0;
    int numValidPairs = 0;
    int numInvalidPairs = 0;
    final int timePoint;

    public RegistrationStatistics(int timepoint, List<List<PairwiseMatch>> matches) {
        this.timePoint = timepoint;
        this.collect(timepoint, matches);
    }

    public RegistrationStatistics(int timePoint, double minError, double avgError, double maxError, double minRatio, double avgRatio, double maxRatio, int numValidPairs, int numInvalidPairs) {
        this.timePoint = timePoint;
        this.minError = minError;
        this.avgError = avgError;
        this.maxError = maxError;
        this.minRatio = minRatio;
        this.avgRatio = avgRatio;
        this.maxRatio = maxRatio;
        this.numValidPairs = numValidPairs;
        this.numInvalidPairs = numInvalidPairs;
    }

    int getTimePoint() {
        return this.timePoint;
    }

    double getMinError() {
        return this.minError;
    }

    double getAvgError() {
        return this.avgError;
    }

    double getMaxError() {
        return this.maxError;
    }

    double getMinRatio() {
        return this.minRatio;
    }

    double getAvgRatio() {
        return this.avgRatio;
    }

    double getMaxRatio() {
        return this.maxRatio;
    }

    int getNumValidPairs() {
        return this.numValidPairs;
    }

    int getNumInvalidPairs() {
        return this.numInvalidPairs;
    }

    protected void collect(int timepoint, List<List<PairwiseMatch>> matches) {
        this.minError = Double.MAX_VALUE;
        this.avgError = 0.0;
        this.maxError = -1.0;
        this.minRatio = 1.0;
        this.maxRatio = 0.0;
        this.avgRatio = 0.0;
        for (List<PairwiseMatch> subset : matches) {
            for (PairwiseMatch match : subset) {
                if (match.getViewIdA().getTimePointId() != timepoint && match.getViewIdB().getTimePointId() != timepoint) continue;
                int numCandidates = match.getNumCandidates();
                int numInliers = match.getNumInliers();
                double error = match.getAvgError();
                if (!Double.isNaN(error) && numCandidates > 0 && numInliers > 0) {
                    ++this.numValidPairs;
                    this.maxError = Math.max(this.maxError, error);
                    this.avgError += error;
                    this.minError = Math.min(this.minError, error);
                    double ratio = (double)numInliers / (double)numCandidates;
                    this.maxRatio = Math.max(this.maxRatio, ratio);
                    this.avgRatio += ratio;
                    this.minRatio = Math.min(this.minRatio, ratio);
                    continue;
                }
                ++this.numInvalidPairs;
            }
        }
        if (this.numValidPairs > 0) {
            this.avgError /= (double)this.numValidPairs;
            this.avgRatio /= (double)this.numValidPairs;
        }
    }

    @Override
    public int compareTo(RegistrationStatistics o) {
        return this.getTimePoint() - o.getTimePoint();
    }
}

