/*
 * Decompiled with CFR 0.152.
 */
package adt;

import adt.Byte3DArray;
import adt.ByteProbability;
import java.util.HashMap;

public class Sparse3DByteArray
implements Byte3DArray {
    HashMap<Integer, HashMap<Integer, HashMap<Integer, Byte>>> data = new HashMap();
    public int xMin = Integer.MAX_VALUE;
    public int xMax = Integer.MIN_VALUE;
    public int yMin = Integer.MAX_VALUE;
    public int yMax = Integer.MIN_VALUE;
    public int zMin = Integer.MAX_VALUE;
    public int zMax = Integer.MIN_VALUE;

    @Override
    public void put(int x, int y, int z, byte val) {
        HashMap<Integer, Byte> zDim;
        this.xMin = Math.min(this.xMin, x);
        this.xMax = Math.max(this.xMax, x);
        this.yMin = Math.min(this.yMin, y);
        this.yMax = Math.max(this.yMax, y);
        this.zMin = Math.min(this.zMin, z);
        this.zMax = Math.max(this.zMax, z);
        HashMap<Integer, HashMap<Integer, Byte>> yzDim = this.data.get(x);
        if (yzDim == null) {
            yzDim = new HashMap();
            this.data.put(x, yzDim);
        }
        if ((zDim = yzDim.get(y)) == null) {
            zDim = new HashMap();
            yzDim.put(y, zDim);
        }
        zDim.put(z, val);
    }

    @Override
    public byte get(int x, int y, int z) {
        HashMap<Integer, HashMap<Integer, Byte>> yzDim = this.data.get(x);
        if (yzDim == null) {
            return 0;
        }
        HashMap<Integer, Byte> zDim = yzDim.get(y);
        if (zDim == null) {
            return 0;
        }
        Byte val = zDim.get(z);
        if (val == null) {
            return 0;
        }
        return val;
    }

    @Override
    public double getDouble(int x, int y, int z) {
        return ByteProbability.BYTE_TO_DOUBLE[this.get(x, y, z) & 0xFF];
    }

    @Override
    public int getxMin() {
        return this.xMin;
    }

    @Override
    public int getxMax() {
        return this.xMax;
    }

    @Override
    public int getyMin() {
        return this.yMin;
    }

    @Override
    public int getyMax() {
        return this.yMax;
    }

    @Override
    public int getzMin() {
        return this.zMin;
    }

    @Override
    public int getzMax() {
        return this.zMax;
    }
}

