/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class AmiraMeshEncoder {
    private int width;
    private int height;
    private int numSlices;
    private int mode;
    public final int RAW = 0;
    public final int RLE = 1;
    public final int ZLIB = 2;
    private Hashtable parameters;
    private Vector materials;
    private String path;
    private RandomAccessFile file;
    private long offsetOfStreamLength;
    private String line;
    private byte[] rleOverrun;
    private int rleOverrunLength;
    private DeflaterOutputStream zStream;
    private BufferedOutputStream out;
    private int zLength;

    public AmiraMeshEncoder(String path_) {
        this.path = path_;
        this.numSlices = -1;
        this.height = -1;
        this.width = -1;
        this.offsetOfStreamLength = 0L;
        this.rleOverrunLength = 0;
        this.mode = 2;
    }

    public boolean open() {
        try {
            this.file = new RandomAccessFile(this.path, "rw");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean writeHeader(ImagePlus ip) {
        try {
            AmiraParameters parameters = new AmiraParameters(ip);
            if (AmiraParameters.isAmiraLabelfield(ip)) {
                this.mode = 1;
            }
            Date date = new Date();
            this.file.writeBytes("# AmiraMesh 3D BINARY 2.0\n# CreationDate: " + date.toString() + "\n\ndefine Lattice " + this.width + " " + this.height + " " + this.numSlices + "\n\nParameters {\n" + parameters.toString() + "}\n\nLattice { byte " + (this.mode == 1 ? "Labels" : "Data") + " } @1");
            if (this.mode == 1) {
                this.file.writeBytes("(HxByteRLE,");
                this.offsetOfStreamLength = this.file.getFilePointer();
                this.file.writeBytes("          ");
            } else if (this.mode == 2) {
                this.file.writeBytes("(HxZip,");
                this.offsetOfStreamLength = this.file.getFilePointer();
                this.file.writeBytes("          ");
            }
            this.file.writeBytes("\n\n# Data section follows\n@1\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean write(ImagePlus ip) {
        IJ.showStatus((String)("Writing " + this.path + " (AmiraMesh) ..."));
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.numSlices = ip.getStackSize();
        if (!this.writeHeader(ip)) {
            return false;
        }
        try {
            long offsetOfData = this.file.getFilePointer();
            ImageStack is = ip.getStack();
            for (int k = 1; k <= this.numSlices; ++k) {
                ByteProcessor ipro = (ByteProcessor)is.getProcessor(k);
                byte[] pixels = (byte[])ipro.getPixels();
                if (null != pixels) {
                    if (this.mode == 1) {
                        this.writeRLE(pixels);
                    } else if (this.mode == 2) {
                        this.writeZlib(pixels);
                    } else {
                        this.file.write(pixels);
                    }
                }
                IJ.showProgress((int)k, (int)this.numSlices);
            }
            long eof = this.file.getFilePointer();
            this.file.setLength(eof);
            if (this.mode == 1 || this.mode == 2) {
                long length = eof - offsetOfData;
                this.file.seek(this.offsetOfStreamLength);
                this.file.writeBytes("" + length + ")\n");
                this.file.seek(eof);
            }
            if (this.mode == 2) {
                this.zStream.close();
                this.out.close();
            }
            this.file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"");
        return true;
    }

    public boolean writeFast(ImagePlus ip) {
        IJ.showStatus((String)("Writing " + this.path + " (AmiraMesh) ..."));
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.numSlices = ip.getStackSize();
        if (!this.writeHeader(ip)) {
            return false;
        }
        byte[] allPixels = new byte[this.width * this.height * this.numSlices];
        try {
            long offsetOfData = this.file.getFilePointer();
            ImageStack is = ip.getStack();
            for (int k = 1; k <= this.numSlices; ++k) {
                ByteProcessor ipro = (ByteProcessor)is.getProcessor(k);
                byte[] pixels = (byte[])ipro.getPixels();
                System.arraycopy(pixels, 0, allPixels, (k - 1) * pixels.length, pixels.length);
                IJ.showProgress((int)k, (int)this.numSlices);
            }
            if (this.mode == 1) {
                this.writeRLE(allPixels);
            } else if (this.mode == 2) {
                this.writeZlib(allPixels);
            } else {
                this.file.write(allPixels);
            }
            long eof = this.file.getFilePointer();
            this.file.setLength(eof);
            if (this.mode == 1 || this.mode == 2) {
                long length = eof - offsetOfData;
                this.file.seek(this.offsetOfStreamLength);
                this.file.writeBytes("" + length + ")\n");
                this.file.seek(eof);
            }
            if (this.mode == 2) {
                this.zStream.close();
                this.out.close();
            }
            this.file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"");
        return true;
    }

    public void writeRLE(byte[] pixels) throws IOException {
        int i = 0;
        while (i < pixels.length) {
            int j;
            if (i + 1 >= pixels.length) {
                this.file.writeByte(1);
                this.file.writeByte(pixels[i]);
                ++i;
                continue;
            }
            if (pixels[i] == pixels[i + 1]) {
                for (j = 2; j < 127 && j + i + 1 < pixels.length && pixels[i] == pixels[i + j]; ++j) {
                }
                this.file.writeByte(j);
                this.file.writeByte(pixels[i]);
                i += j;
                continue;
            }
            for (j = 1; j < 127 && j + i + 1 < pixels.length && pixels[i + j] != pixels[i + j + 1]; ++j) {
            }
            this.file.writeByte(j | 0x80);
            this.file.write(pixels, i, j);
            i += j;
        }
    }

    public void writeZlib(byte[] pixels) throws IOException {
        if (this.zStream == null) {
            this.out = new BufferedOutputStream(new FileOutputStream(this.file.getFD()));
            this.zStream = new DeflaterOutputStream((OutputStream)this.out, new Deflater(), pixels.length);
        }
        this.zStream.write(pixels, 0, pixels.length);
    }
}

