/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import math3d.Point3d;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;
import util.StupidLog;
import vib.FastMatrix;
import vib.VIB;

public abstract class RegistrationOptimizer {
    protected boolean verbose = false;
    double[] eulerParameters;
    double[][] cachedInitialGuesses;
    Point3d origC;
    Point3d transC;
    double translateMax;
    double angleMax;

    public abstract void getInitialCenters();

    public abstract double calculateBadness(FastMatrix var1);

    public FastMatrix doRegister(double tol) {
        if (this.verbose) {
            VIB.println("tol: " + tol);
        }
        ConjugateDirectionSearch CG = new ConjugateDirectionSearch();
        if (IJ.getInstance() != null && this.verbose) {
            CG.prin = 1;
        }
        if (this.eulerParameters == null) {
            this.eulerParameters = this.searchInitialEulerParams()[0];
        }
        double[] originalEulerParameters = (double[])this.eulerParameters.clone();
        double[] lastx = new double[6];
        for (int i = 0; i < 6; ++i) {
            lastx[i] = Double.MAX_VALUE;
        }
        boolean gotStuck = false;
        Refinement refinement = new Refinement(this.eulerParameters);
        refinement.showStatus = true;
        double[] x = new double[6];
        do {
            CG.optimize(refinement, x, tol, tol);
            x = refinement.best;
            if (Arrays.equals(x, lastx)) {
                StupidLog.log("       Got stuck: x is (and was): " + x[0] + ", " + x[1] + ", " + x[2] + ", " + x[3] + ", " + x[4] + ", " + x[5]);
                StupidLog.log("                   maxAdjust was: " + refinement.maxAdjust);
                StupidLog.log("                translateMax was: " + this.translateMax);
                StupidLog.log("                          tol is: " + tol);
                double[] e = originalEulerParameters;
                StupidLog.log("    originalEulerParameters were: " + e[0] + ", " + e[1] + ", " + e[2] + ", " + e[3] + ", " + e[4] + ", " + e[5] + ", " + e[6] + ", " + e[7] + ", " + e[8]);
                gotStuck = true;
                break;
            }
            System.arraycopy(x, 0, lastx, 0, 6);
            this.eulerParameters = refinement.adjustInitial(x);
            if (!this.verbose) continue;
            VIB.println("eulerParameters: " + this.eulerParameters[0] + ", " + this.eulerParameters[1] + ", " + this.eulerParameters[2] + "; " + this.eulerParameters[3] + ", " + this.eulerParameters[4] + ", " + this.eulerParameters[5] + "; " + this.eulerParameters[6] + ", " + this.eulerParameters[7] + ", " + this.eulerParameters[8]);
        } while (refinement.maxAdjust > this.translateMax / 8.0);
        if (gotStuck) {
            Refinement originalRefinement = new Refinement(originalEulerParameters);
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0.0;
            }
            return originalRefinement.getMatrix(x);
        }
        return refinement.getMatrix(x);
    }

    protected double[][] searchInitialEulerParams() {
        Refinement refinement;
        int i;
        if (this.cachedInitialGuesses != null) {
            return this.cachedInitialGuesses;
        }
        double[][] p = new double[24][9];
        this.angleMax = 0.7853981633974483;
        this.translateMax = 20.0;
        ConjugateDirectionSearch CG = new ConjugateDirectionSearch();
        CG.step = 10.0;
        double[][] orderedEulerParams = new double[24][9];
        this.getInitialCenters();
        p[0][3] = this.origC.x - this.transC.x;
        p[0][4] = this.origC.y - this.transC.y;
        p[0][5] = this.origC.z - this.transC.z;
        p[0][6] = this.transC.x;
        p[0][7] = this.transC.y;
        p[0][8] = this.transC.z;
        for (int i2 = 1; i2 < 24; ++i2) {
            System.arraycopy(p[0], 0, p[i2], 0, 9);
        }
        double pi2 = 1.5707963267948966;
        for (int i3 = 0; i3 < 4; ++i3) {
            int j;
            for (j = 0; j < 4; ++j) {
                p[i3 * 6 + j][0] = (double)i3 * pi2;
                p[i3 * 6 + j][1] = (double)j * pi2;
            }
            for (j = 0; j < 2; ++j) {
                p[i3 * 6 + 4 + j][0] = (double)i3 * pi2;
                p[i3 * 6 + 4 + j][1] = (double)(j * 2 + 1) * pi2;
                p[i3 * 6 + 4 + j][2] = pi2;
            }
        }
        ArrayList<Refinement> refinements = new ArrayList<Refinement>();
        double[][] x = new double[24][6];
        for (i = 0; i < 24; ++i) {
            if (this.verbose) {
                VIB.showStatus("Trying orientation " + (i + 1) + " of 24...");
            }
            refinement = new Refinement(p[i]);
            CG.optimize(refinement, x[i], 5.0, 5.0);
            refinements.add(refinement);
            if (!this.verbose) continue;
            VIB.showProgress(i + 1, 24);
        }
        Collections.sort(refinements);
        for (i = 0; i < refinements.size(); ++i) {
            refinement = (Refinement)refinements.get(i);
            x[i] = refinement.best;
            orderedEulerParams[i] = refinement.adjustInitial(x[i]);
            if (!this.verbose) continue;
            VIB.println(i + 1 + " eulerParameters (" + refinement.min + "): " + orderedEulerParams[i][0] + ", " + orderedEulerParams[i][1] + ", " + orderedEulerParams[i][2] + "; " + orderedEulerParams[i][3] + ", " + orderedEulerParams[i][4] + ", " + orderedEulerParams[i][5] + "; " + orderedEulerParams[i][6] + ", " + orderedEulerParams[i][7] + ", " + orderedEulerParams[i][8]);
        }
        this.cachedInitialGuesses = orderedEulerParams;
        return orderedEulerParams;
    }

    public static final FastMatrix getEulerMatrix(double[] x) {
        return RegistrationOptimizer.getEulerMatrix(x[0], x[1], x[2], x[3], x[4], x[5], x[6], x[7], x[8]);
    }

    public static final FastMatrix getEulerMatrix(double a1, double a2, double a3, double tX, double tY, double tZ, double cX, double cY, double cZ) {
        FastMatrix trans = FastMatrix.translate(tX, tY, tZ);
        FastMatrix rot = FastMatrix.rotateEulerAt(a1, a2, a3, cX, cY, cZ);
        return trans.times(rot);
    }

    class Refinement
    implements MultivariateFunction,
    Comparable {
        public boolean showStatus = false;
        double min;
        double[] best;
        double[] initial;
        double angleFactor;
        double maxAdjust;

        public Refinement(double[] start) {
            if (RegistrationOptimizer.this.verbose) {
                VIB.println("translateMax: " + RegistrationOptimizer.this.translateMax + ", angleMax: " + RegistrationOptimizer.this.angleMax);
            }
            this.min = Double.MAX_VALUE;
            this.initial = start;
            this.evaluate(new double[9]);
            this.angleFactor = RegistrationOptimizer.this.angleMax / RegistrationOptimizer.this.translateMax;
        }

        public FastMatrix getMatrix(double[] x) {
            return RegistrationOptimizer.getEulerMatrix(x[0] * this.angleFactor + this.initial[0], x[1] * this.angleFactor + this.initial[1], x[2] * this.angleFactor + this.initial[2], x[3] + this.initial[3], x[4] + this.initial[4], x[5] + this.initial[5], this.initial[6], this.initial[7], this.initial[8]);
        }

        @Override
        public double evaluate(double[] x) {
            double result = RegistrationOptimizer.this.calculateBadness(this.getMatrix(x));
            if (result < this.min) {
                this.best = (double[])x.clone();
                this.min = result;
                if (this.showStatus) {
                    VIB.showStatus("difference: " + this.min);
                }
            }
            return result;
        }

        @Override
        public int getNumArguments() {
            return 6;
        }

        @Override
        public double getLowerBound(int n) {
            return n < 3 ? -RegistrationOptimizer.this.angleMax / this.angleFactor : -RegistrationOptimizer.this.translateMax;
        }

        @Override
        public double getUpperBound(int n) {
            return n < 3 ? RegistrationOptimizer.this.angleMax / this.angleFactor : RegistrationOptimizer.this.translateMax;
        }

        public double evaluate(double[] x, double[] gradient) {
            double result = this.evaluate(x);
            this.computeGradient(x, gradient);
            return result;
        }

        public void computeGradient(double[] x, double[] gradient) {
            for (int i = 0; i < 6; ++i) {
                double bup = x[i];
                x[i] = bup + 1.0;
                double r1 = this.evaluate(x);
                x[i] = bup - 1.0;
                double r2 = this.evaluate(x);
                x[i] = bup;
                gradient[i] = (r1 - r2) / 2.0;
            }
        }

        public double[] adjustInitial(double[] x) {
            this.maxAdjust = 0.0;
            for (int i = 0; i < 6; ++i) {
                if (i < 3) {
                    int n = i;
                    this.initial[n] = this.initial[n] + x[i] * this.angleFactor;
                } else {
                    int n = i;
                    this.initial[n] = this.initial[n] + x[i];
                }
                if (Math.abs(x[i]) > this.maxAdjust) {
                    this.maxAdjust = Math.abs(x[i]);
                }
                x[i] = 0.0;
            }
            return this.initial;
        }

        public int compareTo(Object other) {
            Refinement o = (Refinement)other;
            if (this.min < o.min) {
                return -1;
            }
            if (this.min > o.min) {
                return 1;
            }
            return 0;
        }
    }
}

