/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.ByteType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType8BitSignedInteger
extends AbstractContextual
implements DataType<ByteType> {
    private final ByteType type = new ByteType();

    @Override
    public ByteType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "8-bit int";
    }

    @Override
    public String longName() {
        return "8-bit signed integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between -128 and 127";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(ByteType dest) {
        dest.set((byte)-128);
    }

    @Override
    public void upperBound(ByteType dest) {
        dest.set((byte)127);
    }

    @Override
    public int bitCount() {
        return 8;
    }

    @Override
    public ByteType createVariable() {
        return new ByteType();
    }

    @Override
    public void cast(ByteType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, ByteType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(ByteType val) {
        return val.get();
    }

    @Override
    public long asLong(ByteType val) {
        return val.get();
    }

    @Override
    public void setDouble(ByteType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(ByteType val, long v) {
        if (v < -128L) {
            val.set((byte)-128);
        } else if (v > 127L) {
            val.set((byte)127);
        } else {
            val.set((byte)v);
        }
    }
}

