/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.dnd;

import java.io.File;
import java.io.IOException;
import net.imagej.display.ImageDisplay;
import net.imagej.lut.LUTService;
import net.imglib2.display.ColorTable;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.dnd.AbstractDragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropHandler;

@Plugin(type=DragAndDropHandler.class)
public class LUTFileDragAndDropHandler
extends AbstractDragAndDropHandler<File> {
    @Parameter(required=false)
    private LUTService lutService;
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private LogService log;

    public boolean supports(File file) {
        if (!super.supports((Object)file)) {
            return false;
        }
        if (this.lutService == null) {
            return false;
        }
        return this.lutService.isLUT(file);
    }

    public boolean supportsDisplay(Display<?> display) {
        return display == null || display instanceof ImageDisplay;
    }

    public boolean drop(File file, Display<?> display) {
        if (this.lutService == null || this.displayService == null) {
            return false;
        }
        this.check(file, display);
        if (file == null) {
            return true;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        ColorTable colorTable = this.loadLUT(file);
        if (colorTable == null) {
            return false;
        }
        if (display == null) {
            this.displayService.createDisplay(this.getBaseName(file), (Object)colorTable);
        } else {
            this.lutService.applyLUT(colorTable, imageDisplay);
        }
        return true;
    }

    public Class<File> getType() {
        return File.class;
    }

    private ColorTable loadLUT(File file) {
        ColorTable colorTable;
        try {
            colorTable = this.lutService.loadLUT(file);
        }
        catch (IOException exc) {
            if (this.log != null) {
                this.log.error((Object)("Error opening LUT: " + file), (Throwable)exc);
            }
            return null;
        }
        return colorTable;
    }

    private String getBaseName(File file) {
        String name = file.getName();
        return name.toLowerCase().endsWith(".lut") ? name.substring(0, name.length() - 4) : name;
    }
}

