/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import process3d.Rebin;

public class Rebin_
extends Rebin
implements PlugInFilter {
    private static final String MIN_KEY = "VIB.Rebin.min";
    private static final String MAX_KEY = "VIB.Rebin.max";
    private static final String N_BINS_KEY = "VIB.Rebin.nBins";
    private static final double DEFAULT_MIN = 0.0;
    private static final double DEFAULT_MAX = 255.0;
    private static final int DEFAULT_N_BINS = 256;
    private ImagePlus image;
    private GenericDialog settingsDialog;
    private double min;
    private double max;
    private int nBins;

    public void run(ImageProcessor ip) {
        this.loadSettings();
        this.createSettingsDialog();
        this.settingsDialog.showDialog();
        if (this.settingsDialog.wasCanceled()) {
            return;
        }
        this.readSettings();
        this.saveSettings();
        Rebin_.rebin((ImagePlus)this.image, (float)((float)this.min), (float)((float)this.max), (int)this.nBins).show();
    }

    public int setup(String arg, ImagePlus img) {
        this.image = img;
        return 8;
    }

    private void saveSettings() {
        Prefs.set((String)MIN_KEY, (double)this.min);
        Prefs.set((String)MAX_KEY, (double)this.max);
        Prefs.set((String)N_BINS_KEY, (int)this.nBins);
    }

    private void readSettings() {
        this.min = this.settingsDialog.getNextNumber();
        this.max = this.settingsDialog.getNextNumber();
        this.nBins = (int)this.settingsDialog.getNextNumber();
    }

    private void loadSettings() {
        this.min = Prefs.get((String)MIN_KEY, (double)0.0);
        this.max = Prefs.get((String)MAX_KEY, (double)255.0);
        String bins = Prefs.get((String)N_BINS_KEY, (String)String.valueOf(256));
        this.nBins = Integer.parseInt(bins);
    }

    private void createSettingsDialog() {
        this.settingsDialog = new GenericDialog("Rebin_");
        this.settingsDialog.addNumericField("min", this.min, 3);
        this.settingsDialog.addNumericField("max", this.max, 3);
        this.settingsDialog.addNumericField("nbins", (double)this.nBins, 0);
        this.settingsDialog.addHelp("http://imagej.net/3D_Binary_Filters");
    }
}

