/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsLengthEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsLengthEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsLengthEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Ym\\s*", "Ym");
        p.put("^\\s*Zm\\s*", "Zm");
        p.put("^\\s*Em\\s*", "Em");
        p.put("^\\s*Pm\\s*", "Pm");
        p.put("^\\s*Tm\\s*", "Tm");
        p.put("^\\s*Gm\\s*", "Gm");
        p.put("^\\s*Mm\\s*", "Mm");
        p.put("^\\s*km\\s*", "km");
        p.put("^\\s*hm\\s*", "hm");
        p.put("^\\s*dam\\s*", "dam");
        p.put("^\\s*m\\s*", "m");
        p.put("^\\s*dm\\s*", "dm");
        p.put("^\\s*cm\\s*", "cm");
        p.put("^\\s*mm\\s*", "mm");
        p.put("^\\s*\u00b5m\\s*", "\u00b5m");
        p.put("^\\s*nm\\s*", "nm");
        p.put("^\\s*pm\\s*", "pm");
        p.put("^\\s*fm\\s*", "fm");
        p.put("^\\s*am\\s*", "am");
        p.put("^\\s*zm\\s*", "zm");
        p.put("^\\s*ym\\s*", "ym");
        p.put("^\\s*\u00c5\\s*", "\u00c5");
        p.put("^\\s*thou\\s*", "thou");
        p.put("^\\s*li\\s*", "li");
        p.put("^\\s*in\\s*", "in");
        p.put("^\\s*ft\\s*", "ft");
        p.put("^\\s*yd\\s*", "yd");
        p.put("^\\s*mi\\s*", "mi");
        p.put("^\\s*ua\\s*", "ua");
        p.put("^\\s*ly\\s*", "ly");
        p.put("^\\s*pc\\s*", "pc");
        p.put("^\\s*pt\\s*", "pt");
        p.put("^\\s*pixel\\s*", "pixel");
        p.put("^\\s*reference frame\\s*", "reference frame");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsLength.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsLength", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Length inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Length> getBaseUnit(UnitsLength inModelUnit) {
        Unit<Length> theResult = UNITS.METRE;
        if (UnitsLength.YOTTAMETER.equals(inModelUnit)) {
            theResult = UNITS.YOTTAMETER;
        }
        if (UnitsLength.ZETTAMETER.equals(inModelUnit)) {
            theResult = UNITS.ZETTAMETER;
        }
        if (UnitsLength.EXAMETER.equals(inModelUnit)) {
            theResult = UNITS.EXAMETER;
        }
        if (UnitsLength.PETAMETER.equals(inModelUnit)) {
            theResult = UNITS.PETAMETER;
        }
        if (UnitsLength.TERAMETER.equals(inModelUnit)) {
            theResult = UNITS.TERAMETER;
        }
        if (UnitsLength.GIGAMETER.equals(inModelUnit)) {
            theResult = UNITS.GIGAMETER;
        }
        if (UnitsLength.MEGAMETER.equals(inModelUnit)) {
            theResult = UNITS.MEGAMETER;
        }
        if (UnitsLength.KILOMETER.equals(inModelUnit)) {
            theResult = UNITS.KILOMETER;
        }
        if (UnitsLength.HECTOMETER.equals(inModelUnit)) {
            theResult = UNITS.HECTOMETER;
        }
        if (UnitsLength.DECAMETER.equals(inModelUnit)) {
            theResult = UNITS.DECAMETER;
        }
        if (UnitsLength.METER.equals(inModelUnit)) {
            theResult = UNITS.METER;
        }
        if (UnitsLength.DECIMETER.equals(inModelUnit)) {
            theResult = UNITS.DECIMETER;
        }
        if (UnitsLength.CENTIMETER.equals(inModelUnit)) {
            theResult = UNITS.CENTIMETER;
        }
        if (UnitsLength.MILLIMETER.equals(inModelUnit)) {
            theResult = UNITS.MILLIMETER;
        }
        if (UnitsLength.MICROMETER.equals(inModelUnit)) {
            theResult = UNITS.MICROMETER;
        }
        if (UnitsLength.NANOMETER.equals(inModelUnit)) {
            theResult = UNITS.NANOMETER;
        }
        if (UnitsLength.PICOMETER.equals(inModelUnit)) {
            theResult = UNITS.PICOMETER;
        }
        if (UnitsLength.FEMTOMETER.equals(inModelUnit)) {
            theResult = UNITS.FEMTOMETER;
        }
        if (UnitsLength.ATTOMETER.equals(inModelUnit)) {
            theResult = UNITS.ATTOMETER;
        }
        if (UnitsLength.ZEPTOMETER.equals(inModelUnit)) {
            theResult = UNITS.ZEPTOMETER;
        }
        if (UnitsLength.YOCTOMETER.equals(inModelUnit)) {
            theResult = UNITS.YOCTOMETER;
        }
        if (UnitsLength.ANGSTROM.equals(inModelUnit)) {
            theResult = UNITS.ANGSTROM;
        }
        if (UnitsLength.THOU.equals(inModelUnit)) {
            theResult = UNITS.THOU;
        }
        if (UnitsLength.LINE.equals(inModelUnit)) {
            theResult = UNITS.LINE;
        }
        if (UnitsLength.INCH.equals(inModelUnit)) {
            theResult = UNITS.INCH;
        }
        if (UnitsLength.FOOT.equals(inModelUnit)) {
            theResult = UNITS.FOOT;
        }
        if (UnitsLength.YARD.equals(inModelUnit)) {
            theResult = UNITS.YARD;
        }
        if (UnitsLength.MILE.equals(inModelUnit)) {
            theResult = UNITS.MILE;
        }
        if (UnitsLength.ASTRONOMICALUNIT.equals(inModelUnit)) {
            theResult = UNITS.ASTRONOMICALUNIT;
        }
        if (UnitsLength.LIGHTYEAR.equals(inModelUnit)) {
            theResult = UNITS.LIGHTYEAR;
        }
        if (UnitsLength.PARSEC.equals(inModelUnit)) {
            theResult = UNITS.PARSEC;
        }
        if (UnitsLength.POINT.equals(inModelUnit)) {
            theResult = UNITS.POINT;
        }
        if (UnitsLength.PIXEL.equals(inModelUnit)) {
            theResult = UNITS.PIXEL;
        }
        if (UnitsLength.REFERENCEFRAME.equals(inModelUnit)) {
            theResult = UNITS.REFERENCEFRAME;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Length getQuantity(T inValue, UnitsLength inModelUnit) throws EnumerationException {
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Length' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsLengthEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Length getQuantity(T inValue, UnitsLength inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Length(doubleValue, UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Length(intValue, UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Length' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsLengthEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsLength.class;
    }
}

