/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import stitching.CommonFunctions;
import stitching.CrossCorrelationResult2D;
import stitching.FloatArray2D;
import stitching.ImageInformation;
import stitching.Point2D;
import stitching.Quicksortable;
import stitching.utils.Log;

public class Stitching_2D
implements PlugIn {
    private String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    public String image1;
    public String image2;
    public String fusedImageName;
    public static String methodStatic = CommonFunctions.methodList[1];
    public static String handleRGB1Static = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String handleRGB2Static = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static boolean fuseImagesStatic = true;
    public static boolean windowingStatic = true;
    public static boolean computeOverlapStatic = true;
    public static int checkPeaksStatic = 5;
    public static double alphaStatic = 1.5;
    public static int xOffsetStatic = 0;
    public static int yOffsetStatic = 0;
    public String method = CommonFunctions.methodList[1];
    public String handleRGB1 = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public String handleRGB2 = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public boolean fuseImages = true;
    public boolean windowing = true;
    public boolean computeOverlap = true;
    public int checkPeaks = 5;
    public double alpha = 1.5;
    public int xOffset = 0;
    public int yOffset = 0;
    public boolean doLogging = true;
    public ImagePlus imp1 = null;
    public ImagePlus imp2 = null;
    public Point2D shift = null;
    private CrossCorrelationResult2D[] result = null;
    private Point2D translation = null;

    public Point2D getTranslation() {
        return this.shift.clone();
    }

    public CrossCorrelationResult2D[] getCrossCorrelationResults() {
        return this.result;
    }

    public CrossCorrelationResult2D getCrossCorrelationResult() {
        return this.result[0].clone();
    }

    public void run(String args) {
        int[] idList = WindowManager.getIDList();
        if (idList == null) {
            IJ.error((String)"You need two open images.");
            return;
        }
        int nostacks = 0;
        for (int i = 0; i < idList.length; ++i) {
            if (WindowManager.getImage((int)idList[i]).getStackSize() != 1) continue;
            ++nostacks;
        }
        if (nostacks < 2) {
            IJ.error((String)"You need two open images (no stacks).");
            return;
        }
        String[] nostackList = new String[nostacks];
        int[] nostackIDs = new int[nostacks];
        nostacks = 0;
        for (int i = 0; i < idList.length; ++i) {
            if (WindowManager.getImage((int)idList[i]).getStackSize() != 1) continue;
            nostackList[nostacks] = WindowManager.getImage((int)idList[i]).getTitle();
            nostackIDs[nostacks] = idList[i];
            ++nostacks;
        }
        GenericDialog gd = new GenericDialog("Stitching of 2D Images");
        gd.addChoice("First_image (reference)", nostackList, nostackList[0]);
        gd.addChoice("Use_Channel_for_First", CommonFunctions.colorList, handleRGB1Static);
        this.enableChannelChoice((Choice)gd.getChoices().get(0), (Choice)gd.getChoices().get(1), nostackIDs);
        gd.addChoice("Second_image (to register)", nostackList, nostackList[1]);
        gd.addChoice("Use_Channel_for_Second", CommonFunctions.colorList, handleRGB2Static);
        this.enableChannelChoice((Choice)gd.getChoices().get(2), (Choice)gd.getChoices().get(3), nostackIDs);
        gd.addCheckbox("Use_windowing", windowingStatic);
        gd.addNumericField("How_many_peaks should be checked", (double)checkPeaksStatic, 0);
        gd.addMessage("");
        gd.addCheckbox("Create_merged_image (fusion)", fuseImagesStatic);
        gd.addChoice("Fusion_method", CommonFunctions.methodList, methodStatic);
        gd.addNumericField("Fusion_alpha", alphaStatic, 2);
        gd.addStringField("Fused_image name: ", "Fused_" + nostackList[0] + "_" + nostackList[1]);
        gd.addCheckbox("compute_overlap", computeOverlapStatic);
        gd.addNumericField("x", (double)this.xOffset, xOffsetStatic);
        gd.addNumericField("y", (double)this.yOffset, yOffsetStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\n" + this.myURL);
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, this.myURL);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.image1 = gd.getNextChoice();
        handleRGB1Static = gd.getNextChoice();
        this.image2 = gd.getNextChoice();
        handleRGB2Static = gd.getNextChoice();
        this.imp1 = WindowManager.getImage((int)nostackIDs[((Choice)gd.getChoices().get(0)).getSelectedIndex()]);
        this.imp2 = WindowManager.getImage((int)nostackIDs[((Choice)gd.getChoices().get(2)).getSelectedIndex()]);
        windowingStatic = gd.getNextBoolean();
        checkPeaksStatic = (int)gd.getNextNumber();
        fuseImagesStatic = gd.getNextBoolean();
        methodStatic = gd.getNextChoice();
        alphaStatic = gd.getNextNumber();
        this.fusedImageName = gd.getNextString();
        computeOverlapStatic = gd.getNextBoolean();
        xOffsetStatic = (int)Math.round(gd.getNextNumber());
        yOffsetStatic = (int)Math.round(gd.getNextNumber());
        this.method = methodStatic;
        this.handleRGB1 = handleRGB1Static;
        this.handleRGB2 = handleRGB2Static;
        this.fuseImages = fuseImagesStatic;
        this.windowing = windowingStatic;
        this.checkPeaks = checkPeaksStatic;
        this.alpha = alphaStatic;
        this.computeOverlap = computeOverlapStatic;
        this.xOffset = xOffsetStatic;
        this.yOffset = yOffsetStatic;
        this.translation = !this.computeOverlap ? new Point2D(this.xOffset, this.yOffset) : null;
        boolean calledFromMacro = false;
        if (!this.imp1.getTitle().equals(this.image1) || !this.imp2.getTitle().equals(this.image2)) {
            calledFromMacro = true;
            this.imp1 = WindowManager.getImage((String)this.image1);
            this.imp2 = WindowManager.getImage((String)this.image2);
        }
        if (!calledFromMacro && nostackIDs[((Choice)gd.getChoices().get(0)).getSelectedIndex()] == nostackIDs[((Choice)gd.getChoices().get(2)).getSelectedIndex()]) {
            IJ.error((String)"You selected the same stack twice. Stopping.");
            return;
        }
        if (this.fuseImages) {
            if (this.imp1.getType() != this.imp2.getType()) {
                IJ.error((String)"The Image Stacks are of a different type, it is unclear how to fuse them. Stopping.");
                return;
            }
            if ((this.imp1.getType() == 4 || this.imp1.getType() == 3) && this.method.equals(CommonFunctions.methodList[4])) {
                Log.warn("Red-Cyan Overlay is not possible for RGB images, reducing images to Single Channel data.");
            }
        }
        this.work();
    }

    private final void enableChannelChoice(final Choice controller, final Choice target, final int[] nostackIDs) {
        this.setRGB(nostackIDs[controller.getSelectedIndex()], target);
        controller.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Stitching_2D.this.setRGB(nostackIDs[controller.getSelectedIndex()], target);
            }
        });
    }

    private final void setRGB(int imagejID, Choice target) {
        if (WindowManager.getImage((int)imagejID).getType() == 4 || WindowManager.getImage((int)imagejID).getType() == 3) {
            target.setEnabled(true);
        } else {
            target.setEnabled(false);
        }
    }

    private ImagePlus getImage(String img) {
        ImagePlus imp = null;
        try {
            imp = WindowManager.getImage((String)img);
        }
        catch (Exception e) {
            IJ.error((String)("Could not find image: " + e));
        }
        return imp;
    }

    public Stitching_2D() {
    }

    public Stitching_2D(boolean windowing1, int checkPeaks1, boolean fuseImages1, String method1, String fusedImageName1) {
        this.windowing = windowing1;
        this.fuseImages = fuseImages1;
        this.method = method1;
        this.fusedImageName = fusedImageName1;
        this.checkPeaks = checkPeaks1;
    }

    public void work() {
        this.work(null, null);
    }

    public void work(FloatArray2D inputImage1, FloatArray2D inputImage2) {
        ImagePlus imp2;
        ImagePlus imp1;
        FloatArray2D img1 = null;
        FloatArray2D img2 = null;
        Point2D img1Dim = new Point2D(0, 0);
        Point2D img2Dim = new Point2D(0, 0);
        Point2D ext1Dim = new Point2D(0, 0);
        Point2D ext2Dim = new Point2D(0, 0);
        if (inputImage1 == null || inputImage2 == null) {
            imp1 = this.imp1 == null ? this.getImage(this.image1) : this.imp1;
            imp2 = this.imp2 == null ? this.getImage(this.image2) : this.imp2;
            if (imp1 == null || imp2 == null) {
                return;
            }
            if (!this.checkRoi(imp1, imp2)) {
                return;
            }
            if (this.translation == null) {
                img1 = this.applyROI(imp1, img1Dim, ext1Dim, this.handleRGB1, this.windowing);
                img2 = this.applyROI(imp2, img2Dim, ext2Dim, this.handleRGB2, this.windowing);
            }
        } else {
            img1 = inputImage1;
            img2 = inputImage2;
            imp1 = this.FloatArrayToImagePlus(img1, "Image1", 0.0f, 0.0f);
            imp2 = this.FloatArrayToImagePlus(img2, "Image2", 0.0f, 0.0f);
            img1Dim.x = img1.width;
            img1Dim.y = img1.height;
            img2Dim.x = img2.width;
            img2Dim.y = img2.height;
        }
        if (this.translation == null) {
            if (this.windowing) {
                this.exponentialWindow(img1);
                this.exponentialWindow(img2);
            }
            FloatArray2D[] zeropadded = CommonFunctions.zeroPadImages(img1, img2);
            img1 = zeropadded[0];
            img2 = zeropadded[1];
            Point2D maxDim = new Point2D(img1.width, img1.height);
            FloatArray2D fft1 = CommonFunctions.computeFFT(img1);
            FloatArray2D fft2 = CommonFunctions.computeFFT(img2);
            FloatArray2D invPCM = CommonFunctions.computePhaseCorrelationMatrix(fft1, fft2, maxDim.x);
            ArrayList<Point2D> peaks = this.findPeaks(invPCM, img1Dim, img2Dim, ext1Dim, ext2Dim, this.checkPeaks);
            img1 = this.applyROI(imp1, img1Dim, ext1Dim, this.handleRGB1, false);
            img2 = this.applyROI(imp2, img2Dim, ext2Dim, this.handleRGB2, false);
            this.result = this.testCrossCorrelation(invPCM, peaks, img1, img2);
            this.shift = this.getImageOffset(this.result[0], imp1, imp2);
        } else {
            this.shift = this.translation;
        }
        if (this.fuseImages) {
            ImagePlus fused = this.fuseImages(imp1, imp2, this.shift, this.method, this.fusedImageName);
            fused.show();
        }
        if (this.doLogging) {
            Log.info("Translation Parameters:");
            Log.info("(second stack relative to first stack)");
            if (this.translation == null) {
                Log.info("x= " + this.shift.x + " y= " + this.shift.y + " R= " + this.result[0].R);
            } else {
                Log.info("x= " + this.shift.x + " y= " + this.shift.y);
            }
        }
    }

    private Point2D getImageOffset(CrossCorrelationResult2D result, ImagePlus imp1, ImagePlus imp2) {
        Point2D si;
        Point2D sr = result.shift;
        if (imp1.getRoi() == null || imp2.getRoi() == null) {
            si = sr;
        } else {
            Roi roi1 = imp1.getRoi();
            Roi roi2 = imp2.getRoi();
            int x1 = roi1.getBoundingRect().x;
            int y1 = roi1.getBoundingRect().y;
            int x2 = roi2.getBoundingRect().x;
            int y2 = roi2.getBoundingRect().y;
            Point2D r1 = new Point2D(x1, y1);
            Point2D r2 = new Point2D(x2, y2);
            Point2D sir = this.add(r1, sr);
            si = this.subtract(sir, r2);
        }
        return si;
    }

    private Point2D subtract(Point2D a, Point2D b) {
        return new Point2D(a.x - b.x, a.y - b.y);
    }

    private Point2D add(Point2D a, Point2D b) {
        return new Point2D(a.x + b.x, a.y + b.y);
    }

    private ImagePlus fuseImages(ImagePlus imp1, ImagePlus imp2, Point2D shift, String fusionMethod, String name) {
        int dim = 2;
        ImageInformation i1 = new ImageInformation(2, 1, null);
        i1.closeAtEnd = false;
        i1.imp = imp1;
        i1.size[0] = imp1.getWidth();
        i1.size[1] = imp1.getHeight();
        i1.position = new float[2];
        i1.position[0] = 0.0f;
        i1.position[1] = 0.0f;
        i1.imageName = imp1.getTitle();
        i1.invalid = false;
        i1.imageType = imp1.getType();
        ImageInformation i2 = new ImageInformation(2, 2, null);
        i2.closeAtEnd = false;
        i2.imp = imp2;
        i2.size[0] = imp2.getWidth();
        i2.size[1] = imp2.getHeight();
        i2.position = new float[2];
        i2.position[0] = shift.x;
        i2.position[1] = shift.y;
        i2.imageName = imp2.getTitle();
        i2.invalid = false;
        i2.imageType = imp2.getType();
        ArrayList<ImageInformation> imageInformationList = new ArrayList<ImageInformation>();
        imageInformationList.add(i1);
        imageInformationList.add(i2);
        float[] max = Stitch_Image_Collection.getAndApplyMinMax(imageInformationList, 2);
        return Stitch_Image_Collection.fuseImages(imageInformationList, max, name, fusionMethod, "rgb", 2, this.alpha, true);
    }

    public static Point2D[] getCommonRectangle(ImagePlus[] img, Point2D[] t, boolean min) {
        Point2D size = new Point2D(0, 0);
        Point2D startOffset = new Point2D(0, 0);
        Point2D start = new Point2D(0, 0, 0.0f);
        Point2D minEnd = new Point2D(img[0].getWidth(), img[0].getHeight());
        Point2D maxStart = new Point2D(0, 0, 0.0f);
        for (int i = 1; i < img.length; ++i) {
            start.x += t[i - 1].x;
            start.y += t[i - 1].y;
            maxStart.x = Math.max(start.x, maxStart.x);
            maxStart.y = Math.max(start.y, maxStart.y);
            minEnd.x = Math.min(minEnd.x, start.x + img[i].getWidth());
            minEnd.y = Math.min(minEnd.y, start.y + img[i].getHeight());
        }
        size.x = minEnd.x - maxStart.x;
        size.y = minEnd.y - maxStart.y;
        startOffset.x = maxStart.x;
        startOffset.y = maxStart.y;
        Point2D[] result = new Point2D[]{startOffset, size};
        return result;
    }

    private CrossCorrelationResult2D[] testCrossCorrelation(FloatArray2D invPCM, ArrayList<Point2D> peaks, FloatArray2D img1, FloatArray2D img2) {
        int numBestHits = peaks.size();
        int numCases = 4;
        Quicksortable[] result = new CrossCorrelationResult2D[numBestHits * 4];
        int count = 0;
        int w = invPCM.width;
        int h = invPCM.height;
        Point2D[] points = new Point2D[4];
        int hit = 0;
        while (count < numBestHits * 4) {
            points[0] = peaks.get(hit);
            points[1] = points[0].x < 0 ? new Point2D(points[0].x + w, points[0].y, points[0].value) : new Point2D(points[0].x - w, points[0].y, points[0].value);
            points[2] = points[0].y < 0 ? new Point2D(points[0].x, points[0].y + h, points[0].value) : new Point2D(points[0].x, points[0].y - h, points[0].value);
            points[3] = new Point2D(points[1].x, points[2].y, points[0].value);
            final AtomicInteger entry = new AtomicInteger(count);
            final AtomicInteger shift = new AtomicInteger(0);
            Runnable task = new Runnable((CrossCorrelationResult2D[])result, points, img1, img2){
                final /* synthetic */ CrossCorrelationResult2D[] val$result;
                final /* synthetic */ Point2D[] val$points;
                final /* synthetic */ FloatArray2D val$img1;
                final /* synthetic */ FloatArray2D val$img2;
                {
                    this.val$result = crossCorrelationResult2DArray;
                    this.val$points = point2DArray;
                    this.val$img1 = floatArray2D;
                    this.val$img2 = floatArray2D2;
                }

                @Override
                public void run() {
                    try {
                        int myEntry = entry.getAndIncrement();
                        int myShift = shift.getAndIncrement();
                        this.val$result[myEntry] = Stitching_2D.this.testCrossCorrelation(this.val$points[myShift], this.val$img1, this.val$img2);
                    }
                    catch (Exception e) {
                        Log.error(e);
                    }
                }
            };
            CommonFunctions.startTask(task, 4);
            count += 4;
            ++hit;
        }
        CommonFunctions.quicksort(result, 0, result.length - 1);
        if (this.doLogging) {
            for (int i = 0; i < result.length; ++i) {
                Log.info("x:" + ((CrossCorrelationResult2D)result[i]).shift.x + " y:" + ((CrossCorrelationResult2D)result[i]).shift.y + " overlap:" + ((CrossCorrelationResult2D)result[i]).overlappingPixels + " R:" + ((CrossCorrelationResult2D)result[i]).R + " Peak:" + ((CrossCorrelationResult2D)result[i]).PCMValue);
            }
        }
        return result;
    }

    private CrossCorrelationResult2D testCrossCorrelation(Point2D shift, FloatArray2D img1, FloatArray2D img2) {
        float pixel2;
        float pixel1;
        CrossCorrelationResult2D result = new CrossCorrelationResult2D();
        result.PCMValue = shift.value;
        result.shift = shift;
        int w1 = img1.width;
        int h1 = img1.height;
        int w2 = img2.width;
        int h2 = img2.height;
        int sx = shift.x;
        int sy = shift.y;
        int imgW = sx >= 0 ? Math.max(w1, w2 + sx) : Math.max(w1 - sx, w2);
        int imgH = sy >= 0 ? Math.max(h1, h2 + sy) : Math.max(h1 - sy, h2);
        int offsetImg1X = Math.max(0, -sx);
        int offsetImg1Y = Math.max(0, -sy);
        int offsetImg2X = Math.max(0, sx);
        int offsetImg2Y = Math.max(0, sy);
        int count = 0;
        double avg1 = 0.0;
        double avg2 = 0.0;
        for (int y = 0; y < imgH; ++y) {
            for (int x = 0; x < imgW; ++x) {
                if (x < offsetImg1X || x < offsetImg2X || x >= offsetImg1X + w1 || x >= offsetImg2X + w2 || y < offsetImg1Y || y < offsetImg2Y || y >= offsetImg1Y + h1 || y >= offsetImg2Y + h2) continue;
                pixel1 = img1.getZero(x - offsetImg1X, y - offsetImg1Y);
                pixel2 = img2.getZero(x - offsetImg2X, y - offsetImg2Y);
                avg1 += (double)pixel1;
                avg2 += (double)pixel2;
                ++count;
            }
        }
        if ((double)count <= (double)(Math.min(w1, w2) * Math.min(h1, h2)) * 0.01) {
            result.R = 0.0;
            result.SSQ = 3.4028234663852886E38;
            result.overlappingPixels = count;
            return result;
        }
        avg1 /= (double)count;
        avg2 /= (double)count;
        double var1 = 0.0;
        double var2 = 0.0;
        double coVar = 0.0;
        double SSQ = 0.0;
        count = 0;
        for (int y = 0; y < imgH; ++y) {
            for (int x = 0; x < imgW; ++x) {
                if (x < offsetImg1X || x < offsetImg2X || x >= offsetImg1X + w1 || x >= offsetImg2X + w2 || y < offsetImg1Y || y < offsetImg2Y || y >= offsetImg1Y + h1 || y >= offsetImg2Y + h2) continue;
                pixel1 = img1.getZero(x - offsetImg1X, y - offsetImg1Y);
                pixel2 = img2.getZero(x - offsetImg2X, y - offsetImg2Y);
                double pixelSSQ = Math.pow(pixel1 - pixel2, 2.0);
                SSQ += pixelSSQ;
                ++count;
                double dist1 = (double)pixel1 - avg1;
                double dist2 = (double)pixel2 - avg2;
                coVar += dist1 * dist2;
                var1 += Math.pow(dist1, 2.0);
                var2 += Math.pow(dist2, 2.0);
            }
        }
        SSQ /= (double)count;
        coVar /= (double)count;
        double stDev1 = Math.sqrt(var1 /= (double)count);
        double stDev2 = Math.sqrt(var2 /= (double)count);
        if (stDev1 == 0.0 || stDev2 == 0.0) {
            result.R = 0.0;
            result.SSQ = 3.4028234663852886E38;
            result.overlappingPixels = count;
            return result;
        }
        result.R = coVar / (stDev1 * stDev2);
        result.SSQ = SSQ;
        result.overlappingPixels = count;
        return result;
    }

    private ArrayList<Point2D> findPeaks(FloatArray2D invPCM, Point2D img1, Point2D img2, Point2D ext1, Point2D ext2, int checkPeaks) {
        int w = invPCM.width;
        int h = invPCM.height;
        ArrayList<Point2D> peaks = new ArrayList<Point2D>();
        for (int j = 0; j < checkPeaks; ++j) {
            peaks.add(new Point2D(0, 0, Float.MIN_VALUE));
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (!this.isLocalMaxima(invPCM, x, y)) continue;
                float value = invPCM.get(x, y);
                Point2D insert = null;
                int insertPos = -1;
                Iterator<Point2D> i = peaks.iterator();
                boolean wasBigger = true;
                while (i.hasNext() && wasBigger) {
                    if (value > i.next().value) {
                        if (insert == null) {
                            insert = new Point2D(0, 0, value);
                        }
                        ++insertPos;
                        continue;
                    }
                    wasBigger = false;
                }
                if (insertPos >= 0) {
                    peaks.add(insertPos + 1, insert);
                }
                if (peaks.size() > checkPeaks) {
                    peaks.remove(0);
                }
                if (insert == null) continue;
                int xt = x + (img1.x - img2.x) / 2 - (ext1.x - ext2.x) / 2;
                int xs = xt >= w / 2 ? xt - w : xt;
                int yt = y + (img1.y - img2.y) / 2 - (ext1.y - ext2.y) / 2;
                int ys = yt >= h / 2 ? yt - h : yt;
                insert.x = xs;
                insert.y = ys;
            }
        }
        return peaks;
    }

    private boolean isLocalMaxima(FloatArray2D invPCM, int x, int y) {
        int width = invPCM.width;
        int height = invPCM.height;
        boolean isMax = true;
        float value = invPCM.get(x, y);
        if (x > 0 && y > 0 && x < width - 1 && y < height - 1) {
            for (int xs = x - 1; xs <= x + 1 && isMax; ++xs) {
                for (int ys = y - 1; ys <= y + 1 && isMax; ++ys) {
                    if (x == xs && y == ys || !(invPCM.get(xs, ys) > value)) continue;
                    isMax = false;
                }
            }
        } else {
            for (int xs = x - 1; xs <= x + 1 && isMax; ++xs) {
                for (int ys = y - 1; ys <= y + 1 && isMax; ++ys) {
                    if (x == xs && y == ys) continue;
                    int xt = xs;
                    int yt = ys;
                    if (xt == -1) {
                        xt = width - 1;
                    }
                    if (yt == -1) {
                        yt = height - 1;
                    }
                    if (xt == width) {
                        xt = 0;
                    }
                    if (yt == height) {
                        yt = 0;
                    }
                    if (!(invPCM.get(xt, yt) > value)) continue;
                    isMax = false;
                }
            }
        }
        return isMax;
    }

    private FloatArray2D applyROI(ImagePlus imp, Point2D imgDim, Point2D extDim, String handleRGB, boolean windowing) {
        FloatArray2D img;
        if (imp.getRoi() == null) {
            img = this.ImageToFloatArray(imp.getProcessor(), handleRGB);
        } else {
            Roi r = imp.getRoi();
            int x = r.getBoundingRect().x;
            int y = r.getBoundingRect().y;
            int w = r.getBoundingRect().width;
            int h = r.getBoundingRect().height;
            img = this.ImageToFloatArray(imp.getProcessor(), handleRGB, x, y, w, h);
        }
        imgDim.x = img.width;
        imgDim.y = img.height;
        extDim.y = 0;
        extDim.x = 0;
        if (windowing) {
            int imgW = img.width;
            int imgH = img.height;
            int extW = imgW / 4;
            int extH = imgH / 4;
            if (extW % 2 != 0) {
                ++extW;
            }
            if (extH % 2 != 0) {
                ++extH;
            }
            extDim.x = extW;
            extDim.y = extH;
            imgDim.x += extDim.x;
            imgDim.y += extDim.y;
            img = this.extendImageMirror(img, imgW + extW, imgH + extH);
        }
        return img;
    }

    private boolean checkRoi(ImagePlus imp1, ImagePlus imp2) {
        boolean img1HasROI = imp1.getRoi() != null;
        boolean img2HasROI = imp2.getRoi() != null;
        if (img1HasROI && !img2HasROI || img2HasROI && !img1HasROI) {
            IJ.error((String)"Eigher both images should have a ROI or none of them.");
            return false;
        }
        if (img1HasROI) {
            int type1 = imp1.getRoi().getType();
            int type2 = imp2.getRoi().getType();
            if (type1 != 0) {
                IJ.error((String)(imp1.getTitle() + " has a ROI which is no rectangle."));
            }
            if (type2 != 0) {
                IJ.error((String)(imp2.getTitle() + " has a ROI which is no rectangle."));
            }
        }
        return true;
    }

    private void exponentialWindow(FloatArray2D img) {
        int y;
        double relPos;
        double a = 1000.0;
        double[] weightsX = new double[img.width];
        double[] weightsY = new double[img.height];
        for (int x = 0; x < img.width; ++x) {
            relPos = (double)x / (double)(img.width - 1);
            weightsX[x] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (y = 0; y < img.height; ++y) {
            relPos = (double)y / (double)(img.height - 1);
            weightsY[y] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (y = 0; y < img.height; ++y) {
            for (int x = 0; x < img.width; ++x) {
                img.set((float)((double)img.get(x, y) * weightsX[x] * weightsY[y]), x, y);
            }
        }
    }

    private FloatArray2D extendImageMirror(FloatArray2D ip, int width, int height) {
        FloatArray2D image = new FloatArray2D(width, height);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        if (offsetX < 0) {
            IJ.error((String)("Stitching_3D.extendImageMirror(): Extended size in X smaller than image! " + width + " < " + ip.width));
            return null;
        }
        if (offsetY < 0) {
            IJ.error((String)("Stitching_3D.extendImageMirror(): Extended size in Y smaller than image! " + height + " < " + ip.height));
            return null;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.set(ip.getMirror(x - offsetX, y - offsetY), x, y);
            }
        }
        return image;
    }

    public FloatArray2D ImageToFloatArray(ImageProcessor ip, String handleRGB) {
        int height;
        int width;
        int rgbType = -1;
        if (ip == null) {
            Log.error("Image Stack is empty.");
            return null;
        }
        if (ip.getPixels() instanceof int[]) {
            if (handleRGB == null || handleRGB.trim().length() == 0) {
                handleRGB = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
            }
            for (int i = 0; i < CommonFunctions.colorList.length; ++i) {
                if (!handleRGB.toLowerCase().trim().equals(CommonFunctions.colorList[i].toLowerCase())) continue;
                rgbType = i;
            }
            if (rgbType == -1) {
                Log.warn("Unrecognized command to handle RGB: " + handleRGB + ". Assuming Average of Red, Green and Blue.");
                rgbType = CommonFunctions.colorList.length - 1;
            }
        }
        if ((width = ip.getWidth()) * (height = ip.getHeight()) == 0) {
            Log.error("Image is empty.");
            return null;
        }
        FloatArray2D pixels = new FloatArray2D(width, height);
        if (ip.getPixels() instanceof byte[]) {
            byte[] pixelTmp = (byte[])ip.getPixels();
            int count = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels.data[pixels.getPos((int)x, (int)y)] = pixelTmp[count++] & 0xFF;
                }
            }
        } else if (ip.getPixels() instanceof short[]) {
            short[] pixelTmp = (short[])ip.getPixels();
            int count = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels.data[pixels.getPos((int)x, (int)y)] = pixelTmp[count++] & 0xFFFF;
                }
            }
        } else if (ip.getPixels() instanceof int[]) {
            int[] pixelTmp = (int[])ip.getPixels();
            int count = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels.data[pixels.getPos((int)x, (int)y)] = CommonFunctions.getPixelValueRGB(pixelTmp[count++], rgbType);
                }
            }
        } else {
            float[] pixelTmp = (float[])ip.getPixels();
            int count = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels.data[pixels.getPos((int)x, (int)y)] = pixelTmp[count++];
                }
            }
        }
        return pixels;
    }

    private FloatArray2D ImageToFloatArray(ImageProcessor ip, String handleRGB, int xCrop, int yCrop, int wCrop, int hCrop) {
        int height;
        int width;
        int rgbType = -1;
        if (ip == null) {
            Log.error("Image Stack is empty.");
            return null;
        }
        if (ip.getPixels() instanceof int[]) {
            if (handleRGB == null || handleRGB.trim().length() == 0) {
                handleRGB = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
            }
            for (int i = 0; i < CommonFunctions.colorList.length; ++i) {
                if (!handleRGB.toLowerCase().trim().equals(CommonFunctions.colorList[i].toLowerCase())) continue;
                rgbType = i;
            }
            if (rgbType == -1) {
                Log.warn("Unrecognized command to handle RGB: " + handleRGB + ". Assuming Average of Red, Green and Blue.");
                rgbType = CommonFunctions.colorList.length - 1;
            }
        }
        if ((width = ip.getWidth()) * (height = ip.getHeight()) == 0) {
            Log.error("Image is empty.");
            return null;
        }
        FloatArray2D pixels = new FloatArray2D(wCrop, hCrop);
        if (ip.getPixels() instanceof byte[]) {
            byte[] pixelTmp = (byte[])ip.getPixels();
            for (int y = yCrop; y < yCrop + hCrop; ++y) {
                for (int x = xCrop; x < xCrop + wCrop; ++x) {
                    pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop))] = pixelTmp[x + y * width] & 0xFF;
                }
            }
        } else if (ip.getPixels() instanceof short[]) {
            short[] pixelTmp = (short[])ip.getPixels();
            for (int y = yCrop; y < yCrop + hCrop; ++y) {
                for (int x = xCrop; x < xCrop + wCrop; ++x) {
                    pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop))] = pixelTmp[x + y * width] & 0xFFFF;
                }
            }
        } else if (ip.getPixels() instanceof int[]) {
            int[] pixelTmp = (int[])ip.getPixels();
            for (int y = yCrop; y < yCrop + hCrop; ++y) {
                for (int x = xCrop; x < xCrop + wCrop; ++x) {
                    pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop))] = CommonFunctions.getPixelValueRGB(pixelTmp[x + y * width], rgbType);
                }
            }
        } else {
            float[] pixelTmp = (float[])ip.getPixels();
            for (int y = yCrop; y < yCrop + hCrop; ++y) {
                for (int x = xCrop; x < xCrop + wCrop; ++x) {
                    pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop))] = pixelTmp[x + y * width];
                }
            }
        }
        return pixels;
    }

    private ImagePlus FloatArrayToImagePlus(FloatArray2D image, String name, float min, float max) {
        int width = image.width;
        int height = image.height;
        ImagePlus impResult = IJ.createImage((String)name, (String)"32-Bit Black", (int)width, (int)height, (int)1);
        ImageProcessor ipResult = impResult.getProcessor();
        float[] sliceImg = new float[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                sliceImg[y * width + x] = image.get(x, y);
            }
        }
        ipResult.setPixels((Object)sliceImg);
        if (min == max) {
            ipResult.resetMinAndMax();
        } else {
            ipResult.setMinAndMax((double)min, (double)max);
        }
        impResult.updateAndDraw();
        return impResult;
    }
}

