/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.tool.Tool;
import org.scijava.tool.ToolService;
import org.scijava.tool.event.ToolActivatedEvent;
import org.scijava.tool.event.ToolDeactivatedEvent;
import org.scijava.ui.ToolBar;
import org.scijava.ui.UIService;
import org.scijava.ui.swing.SwingIconService;

public class SwingToolBar
extends JToolBar
implements ToolBar {
    protected static final Border ACTIVE_BORDER = new BevelBorder(1);
    protected static final Border INACTIVE_BORDER = new BevelBorder(0);
    private final Map<String, AbstractButton> toolButtons;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    @Parameter
    private SwingIconService iconService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ToolService toolService;
    @Parameter
    private UIService uiService;
    @Parameter
    private LogService log;

    public SwingToolBar(Context context) {
        context.inject((Object)this);
        this.toolButtons = new HashMap<String, AbstractButton>();
        this.populateToolBar();
    }

    private void populateToolBar() {
        Tool activeTool = this.toolService.getActiveTool();
        Tool lastTool = null;
        for (Tool tool : this.toolService.getTools()) {
            try {
                AbstractButton button = this.createButton(tool, tool == activeTool);
                this.toolButtons.put(tool.getInfo().getName(), button);
                this.iconService.registerButton(tool, button);
                if (this.toolService.isSeparatorNeeded(tool, lastTool)) {
                    this.addSeparator();
                }
                lastTool = tool;
                this.add(button);
            }
            catch (InstantiableException e) {
                this.log.warn((Object)("Invalid tool: " + tool.getInfo()), (Throwable)e);
            }
        }
    }

    private AbstractButton createButton(final Tool tool, boolean active) throws InstantiableException {
        PluginInfo info = tool.getInfo();
        String name = info.getName();
        String label = info.getLabel();
        URL iconURL = info.getIconURL();
        boolean enabled = info.isEnabled();
        boolean visible = info.isVisible();
        final JToggleButton button = new JToggleButton();
        if (iconURL == null) {
            button.setText(name);
            this.log.warn((Object)("Invalid icon for tool: " + tool));
        } else {
            this.log.debug((Object)("Loading icon from " + iconURL.toString()));
            button.setIcon(new ImageIcon(iconURL, label));
        }
        if (label != null && !label.isEmpty()) {
            button.setToolTipText(label);
        } else {
            button.setToolTipText(name);
        }
        this.buttonGroup.add(button);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SwingToolBar.this.statusService.showStatus(tool.getDescription());
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SwingToolBar.this.statusService.clearStatus();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 0) {
                    return;
                }
                if (evt.getButton() == 1) {
                    return;
                }
                tool.configure();
            }
        });
        button.addChangeListener(new ChangeListener(){
            boolean isActive = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = button.isSelected();
                button.setBorder(selected ? ACTIVE_BORDER : INACTIVE_BORDER);
                if (selected == this.isActive) {
                    return;
                }
                this.isActive = selected;
                if (this.isActive) {
                    SwingToolBar.this.toolService.setActiveTool(tool);
                }
            }
        });
        button.setBorder(active ? ACTIVE_BORDER : INACTIVE_BORDER);
        if (active) {
            button.setSelected(true);
        }
        button.setEnabled(enabled);
        button.setVisible(visible);
        return button;
    }

    @EventHandler
    protected void onEvent(ToolActivatedEvent event) {
        PluginInfo info = event.getTool().getInfo();
        if (info == null) {
            return;
        }
        String name = info.getName();
        if (name == null) {
            return;
        }
        AbstractButton button = this.toolButtons.get(name);
        if (button == null) {
            return;
        }
        button.setSelected(true);
        button.setBorder(ACTIVE_BORDER);
        this.log.debug((Object)("Selected " + name + " button."));
    }

    @EventHandler
    protected void onEvent(ToolDeactivatedEvent event) {
        PluginInfo info = event.getTool().getInfo();
        if (info == null) {
            return;
        }
        String name = info.getName();
        if (name == null) {
            return;
        }
        AbstractButton button = this.toolButtons.get(name);
        if (button == null) {
            return;
        }
        button.setBorder(INACTIVE_BORDER);
        this.log.debug((Object)("Deactivated " + name + " button."));
    }
}

