/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.scijava.log.LogService;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.widget.SwingFileWidget;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.FileListWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingFileListWidget
extends SwingInputWidget<File[]>
implements FileListWidget<JPanel>,
ActionListener,
MouseListener {
    @Parameter
    private LogService logService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private ThreadService threadService;
    private JList<File> paths;
    private JButton addFilesButton;
    private JButton addFolderButton;
    private JButton removeFilesButton;
    private JButton clearButton;

    public File[] getValue() {
        DefaultListModel listModel = (DefaultListModel)this.paths.getModel();
        ArrayList fileList = Collections.list(listModel.elements());
        return fileList.toArray(new File[fileList.size()]);
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.paths = new JList(new DefaultListModel());
        this.paths.setDragEnabled(true);
        String style = model.getItem().getWidgetStyle();
        this.paths.setTransferHandler(new FileListTransferHandler(style));
        JScrollPane scrollPane = new JScrollPane(this.paths);
        scrollPane.setPreferredSize(new Dimension(350, 100));
        this.paths.addMouseListener(this);
        this.setToolTip(scrollPane);
        this.getComponent().add(scrollPane);
        this.getComponent().add(Box.createHorizontalStrut(3));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
        String filesLabel = model.isStyle("directories") ? "Add folders..." : "Add files...";
        this.addFilesButton = new JButton(filesLabel);
        this.setToolTip(this.addFilesButton);
        buttonPanel.add((Component)this.addFilesButton, "wrap, grow");
        this.addFilesButton.addActionListener(this);
        if (!model.isStyle("directories")) {
            this.addFolderButton = new JButton("Add folder content...");
            this.setToolTip(this.addFolderButton);
            this.addFolderButton.setTransferHandler(new FolderTransferHandler());
            DropTarget dropTarget = this.addFolderButton.getDropTarget();
            try {
                dropTarget.addDropTargetListener(new ButtonDropTargetListener());
            }
            catch (TooManyListenersException exc) {
                this.logService.error((Object)"Error with setting up drop support", (Throwable)exc);
            }
            buttonPanel.add((Component)this.addFolderButton, "wrap, grow");
            this.addFolderButton.addActionListener(this);
        }
        this.removeFilesButton = new JButton("Remove selected");
        this.setToolTip(this.removeFilesButton);
        buttonPanel.add((Component)this.removeFilesButton, "wrap, grow");
        this.removeFilesButton.addActionListener(this);
        this.clearButton = new JButton("Clear list");
        this.setToolTip(this.clearButton);
        buttonPanel.add((Component)this.clearButton, "grow");
        this.clearButton.addActionListener(this);
        this.getComponent().add(buttonPanel);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(File[].class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultListModel listModel = (DefaultListModel)this.paths.getModel();
        if (e.getSource() == this.addFilesButton) {
            List fileList = Collections.list(listModel.elements());
            WidgetModel widgetModel = this.get();
            String widgetStyle = widgetModel.getItem().getWidgetStyle();
            FileFilter filter = SwingFileWidget.createFileFilter(widgetStyle);
            String style = widgetModel.isStyle("both") ? "both" : (widgetModel.isStyle("directories") ? "directories" : "files");
            fileList = this.ui().chooseFiles(null, fileList, filter, style);
            if (fileList == null) {
                return;
            }
            fileList.forEach(file -> listModel.addElement(file));
        } else if (e.getSource() == this.addFolderButton) {
            File folder = this.ui().chooseFile(null, "directory");
            if (folder == null) {
                return;
            }
            List<File> fileList = this.getFilesFromFolder(folder);
            fileList.forEach(file -> listModel.addElement(file));
        } else if (e.getSource() == this.removeFilesButton) {
            List<File> selected = this.paths.getSelectedValuesList();
            for (File f : selected) {
                listModel.removeElement(f);
            }
        } else if (e.getSource() == this.clearButton) {
            listModel.removeAllElements();
        }
        this.paths.setModel(listModel);
        this.updateModel();
    }

    protected void doRefresh() {
        File[] files = (File[])this.get().getValue();
        DefaultListModel<File> listModel = new DefaultListModel<File>();
        if (files != null) {
            for (File file : files) {
                listModel.addElement(file);
            }
        }
        this.paths.setModel(listModel);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            DefaultListModel listModel = (DefaultListModel)this.paths.getModel();
            List<File> selected = this.paths.getSelectedValuesList();
            for (File f : selected) {
                listModel.removeElement(f);
            }
            this.paths.setModel(listModel);
            this.updateModel();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private List<File> getFilesFromFolder(File inputFolder) {
        List<File> fileList = new ArrayList<File>();
        WidgetModel widgetModel = this.get();
        String widgetStyle = widgetModel.getItem().getWidgetStyle();
        FileFilter filter = SwingFileWidget.createFileFilter(widgetStyle);
        try {
            fileList = Arrays.asList(Files.walk(inputFolder.toPath(), new FileVisitOption[0]).filter(path -> filter.accept(path.toFile())).map(path -> path.toFile()).toArray(File[]::new));
        }
        catch (IOException exc) {
            this.logService.error((Object)"Error when trying to retrieve file list", (Throwable)exc);
        }
        return fileList;
    }

    private class ButtonDropTargetListener
    extends DropTargetAdapter {
        private ButtonDropTargetListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            JButton button = (JButton)dtde.getDropTargetContext().getComponent();
            button.getModel().setPressed(false);
            dtde.acceptDrop(3);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            JButton button = (JButton)dtde.getDropTargetContext().getComponent();
            button.getModel().setPressed(true);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            JButton button = (JButton)dte.getDropTargetContext().getComponent();
            button.getModel().setPressed(false);
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return SwingFileWidget.hasFiles(support);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            List<File> files = SwingFileWidget.getFiles(support);
            if (files == null || files.size() != 1) {
                return false;
            }
            File folder = files.get(0);
            if (!folder.isDirectory()) {
                return false;
            }
            List fileList = SwingFileListWidget.this.getFilesFromFolder(folder);
            DefaultListModel model = (DefaultListModel)SwingFileListWidget.this.paths.getModel();
            fileList.forEach(file -> model.addElement(file));
            SwingFileListWidget.this.paths.setModel(model);
            SwingFileListWidget.this.updateModel();
            return true;
        }
    }

    private class FileListTransferHandler
    extends TransferHandler {
        private final String style;

        public FileListTransferHandler(String style) {
            this.style = style;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return SwingFileWidget.hasFiles(support);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            List<File> allFiles = SwingFileWidget.getFiles(support);
            if (allFiles == null) {
                return false;
            }
            FileFilter filter = SwingFileWidget.createFileFilter(this.style);
            List<File> files = SwingFileWidget.filterFiles(allFiles, filter);
            if (allFiles.size() != files.size()) {
                SwingFileListWidget.this.logService.warn((Object)("Some files were excluded for not matching the input requirements (" + this.style + ")"));
            }
            JList jlist = (JList)support.getComponent();
            DefaultListModel model = (DefaultListModel)jlist.getModel();
            files.forEach(f -> model.addElement(f));
            jlist.setModel(model);
            SwingFileListWidget.this.updateModel();
            return true;
        }
    }
}

