/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.awt.ColorMapped;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.AxisTics;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Clips;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Iterator;

public class ContoursView
extends TiledView
implements ColorMapped {
    private float _lineWidth = 0.0f;
    private Line _lineStyle = Line.SOLID;
    private Line _lineStyleNegative = Line.DEFAULT;
    private ColorMap _colorMap = new ColorMap(ColorMap.JET);
    private Sampling _s1;
    private Sampling _s2;
    private float[][] _f;
    private Orientation _orientation = Orientation.X1RIGHT_X2UP;
    private boolean _transposed;
    private boolean _xflipped;
    private boolean _yflipped;
    private int _nx;
    private double _dx;
    private double _fx;
    private int _ny;
    private double _dy;
    private double _fy;
    private Clips _clips;
    private float _clipMin;
    private float _clipMax;
    private int _nc = 25;
    private boolean _readableContours = true;
    private Sampling _cs;
    private ArrayList<Contour> _cl;
    private static final byte WEST = 1;
    private static final byte SOUTH = 2;
    private static final byte NOT_WEST = -2;
    private static final byte NOT_SOUTH = -3;

    public ContoursView(float[][] f) {
        this.set(f);
    }

    public ContoursView(Sampling s1, Sampling s2, float[][] f) {
        this.set(s1, s2, f);
    }

    public void set(float[][] f) {
        this.set(new Sampling(f[0].length), new Sampling(f.length), f);
    }

    public void set(Sampling s1, Sampling s2, float[][] f) {
        Check.argument(s1.isUniform(), "s1 is uniform");
        Check.argument(s2.isUniform(), "s2 is uniform");
        Check.argument(ArrayMath.isRegular(f), "f is regular");
        Check.argument(s1.getCount() == f[0].length, "s1 consistent with f");
        Check.argument(s2.getCount() == f.length, "s2 consistent with f");
        this._s1 = s1;
        this._s2 = s2;
        this._f = ArrayMath.copy(f);
        this._clips = new Clips(f);
        this.updateArraySampling();
        this._cs = null;
        this._cl = null;
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateArraySampling();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setLineStyle(Line style) {
        if (this._lineStyle != style) {
            this._lineStyle = style;
            this.repaint();
        }
    }

    public void setLineStyleNegative(Line style) {
        if (this._lineStyleNegative != style) {
            this._lineStyleNegative = style;
            this.repaint();
        }
    }

    public void setLineWidth(float width) {
        if (this._lineWidth != width) {
            this._lineWidth = width;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setLineColor(Color color) {
        this._colorMap.setColorModel(color);
        this.repaint();
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorMap.setColorModel(colorModel);
        this.repaint();
    }

    @Override
    public ColorMap getColorMap() {
        return this._colorMap;
    }

    public void setReadableContours(boolean readableContours) {
        if (this._readableContours != readableContours) {
            this._readableContours = readableContours;
            this._cs = null;
            this._cl = null;
            this.repaint();
        }
    }

    public void setContours(int n) {
        this._nc = n;
        this._cs = null;
        this._cl = null;
        this.repaint();
    }

    public void setContours(float[] c) {
        double[] cd = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            cd[i] = c[i];
        }
        this.setContours(new Sampling(cd));
    }

    public void setContours(Sampling cs) {
        this._readableContours = false;
        this._cs = cs;
        this._cl = null;
        this.repaint();
    }

    public float[] getContours() {
        this.updateContourSampling();
        float[] values = new float[this._cs.getCount()];
        for (int n = 0; n < values.length; ++n) {
            values[n] = this._cl.get((int)n).fc;
        }
        return values;
    }

    public void setClips(float clipMin, float clipMax) {
        this._clips.setClips(clipMin, clipMax);
        this._cs = null;
        this._cl = null;
        this.repaint();
    }

    public float getClipMin() {
        return this._clips.getClipMin();
    }

    public float getClipMax() {
        return this._clips.getClipMax();
    }

    public void setPercentiles(float percMin, float percMax) {
        this._clips.setPercentiles(percMin, percMax);
        this._cs = null;
        this._cl = null;
        this.repaint();
    }

    public float getPercentileMin() {
        return this._clips.getPercentileMin();
    }

    public float getPercentileMax() {
        return this._clips.getPercentileMax();
    }

    public void addColorMapListener(ColorMapListener cml) {
        this._colorMap.addListener(cml);
    }

    public void removeColorMapListener(ColorMapListener cml) {
        this._colorMap.removeListener(cml);
    }

    @Override
    public void paint(Graphics2D g2d) {
        BasicStroke bs;
        this.updateContourSampling();
        this.updateContours();
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        double vx0 = this._fx - 0.5 * this._dx;
        double vx1 = this._fx + this._dx * ((double)this._nx - 0.5);
        double vy0 = this._fy - 0.5 * this._dy;
        double vy1 = this._fy + this._dy * ((double)this._ny - 0.5);
        double ux0 = hp.u(vx0);
        double ux1 = hp.u(vx1);
        double uy0 = vp.u(vy0);
        double uy1 = vp.u(vy1);
        double uxmin = ArrayMath.min(ux0, ux1);
        double uxmax = ArrayMath.max(ux0, ux1);
        double uymin = ArrayMath.min(uy0, uy1);
        double uymax = ArrayMath.max(uy0, uy1);
        int xd = ts.x(uxmin);
        int yd = ts.y(uymin);
        int wd = ts.width(uxmax - uxmin);
        int hd = ts.height(uymax - uymin);
        Rectangle viewRect = new Rectangle(xd, yd, wd, hd);
        Rectangle clipRect = g2d.getClipBounds();
        if (clipRect == null) {
            clipRect = viewRect;
        }
        if ((clipRect = clipRect.intersection(viewRect)).isEmpty()) {
            return;
        }
        float lineWidth = 1.0f;
        Graphics2D gline = (Graphics2D)g2d.create();
        float[] dash = null;
        Line lineStyle = this._lineStyle;
        if (lineStyle == Line.DEFAULT) {
            lineStyle = Line.SOLID;
        }
        if (lineStyle != Line.SOLID) {
            float dotLength = lineWidth;
            float dashLength = 5.0f * lineWidth;
            float gapLength = 5.0f * lineWidth;
            if (lineStyle == Line.DASH) {
                dash = new float[]{dashLength, gapLength};
            } else if (lineStyle == Line.DOT) {
                dash = new float[]{dotLength, gapLength};
            } else if (lineStyle == Line.DASH_DOT) {
                dash = new float[]{dashLength, gapLength, dotLength, gapLength};
            }
        }
        float width = lineWidth;
        if (this._lineWidth != 0.0f) {
            width *= this._lineWidth;
        }
        if (dash != null) {
            int cap = 1;
            int join = 1;
            float miter = 10.0f;
            float phase = 0.0f;
            bs = new BasicStroke(width, cap, join, miter, dash, phase);
        } else {
            bs = new BasicStroke(width);
        }
        gline.setStroke(bs);
        BasicStroke bsneg = null;
        if (this._lineStyleNegative != Line.DEFAULT) {
            dash = null;
            if (this._lineStyleNegative != Line.SOLID) {
                float dotLength = lineWidth;
                float dashLength = 5.0f * lineWidth;
                float gapLength = 5.0f * lineWidth;
                if (this._lineStyleNegative == Line.DASH) {
                    dash = new float[]{dashLength, gapLength};
                } else if (this._lineStyleNegative == Line.DOT) {
                    dash = new float[]{dotLength, gapLength};
                } else if (this._lineStyleNegative == Line.DASH_DOT) {
                    dash = new float[]{dashLength, gapLength, dotLength, gapLength};
                }
            }
            width = lineWidth;
            if (this._lineWidth != 0.0f) {
                width *= this._lineWidth;
            }
            if (dash != null) {
                int cap = 1;
                int join = 1;
                float miter = 10.0f;
                float phase = 0.0f;
                bsneg = new BasicStroke(width, cap, join, miter, dash, phase);
            } else {
                bsneg = new BasicStroke(width);
            }
        }
        IndexColorModel cm = this._colorMap.getColorModel();
        for (int is = 0; is < this._cs.getCount(); ++is) {
            float fc = this._cl.get((int)is).fc;
            ArrayList<float[]> cx1 = this._cl.get((int)is).x1;
            ArrayList<float[]> cx2 = this._cl.get((int)is).x2;
            Iterator<float[]> it1 = cx1.iterator();
            Iterator<float[]> it2 = cx2.iterator();
            if (cm != null) {
                int index = fc < this._clipMin ? 0 : (fc > this._clipMax ? 255 : (int)((fc - this._clipMin) / (this._clipMax - this._clipMin) * 255.0f));
                gline.setColor(new Color(cm.getRGB(index)));
            }
            if (this._lineStyleNegative != Line.DEFAULT) {
                if (fc < 0.0f) {
                    gline.setStroke(bsneg);
                }
                if (fc >= 0.0f) {
                    gline.setStroke(bs);
                }
            }
            while (it1.hasNext()) {
                float[] xc1 = it1.next();
                float[] xc2 = it2.next();
                int n = xc1.length;
                int[] xcon = new int[xc1.length];
                int[] ycon = new int[xc2.length];
                this.computeXY(hp, vp, ts, n, xc1, xc2, xcon, ycon);
                if (gline == null) continue;
                gline.drawPolyline(xcon, ycon, n);
            }
        }
    }

    private void updateClips() {
        float clipMin = this._clips.getClipMin();
        float clipMax = this._clips.getClipMax();
        if (this._clipMin != clipMin || this._clipMax != clipMax) {
            this._clipMin = clipMin;
            this._clipMax = clipMax;
            this._colorMap.setValueRange(clipMin, clipMax);
        }
    }

    private void updateContourSampling() {
        if (this._cs == null) {
            double fc;
            double dc;
            int nc;
            this.updateClips();
            if (this._readableContours) {
                AxisTics at = new AxisTics((double)this._clipMin, (double)this._clipMax, this._nc);
                nc = at.getCountMajor();
                dc = at.getDeltaMajor();
                fc = at.getFirstMajor();
            } else {
                nc = this._nc;
                dc = (this._clipMax - this._clipMin) / (float)(nc + 1);
                fc = this._clipMin;
            }
            double[] cstep = new double[nc];
            cstep[0] = fc + dc;
            for (int count = 1; count < nc; ++count) {
                cstep[count] = cstep[count - 1] + dc;
            }
            this._cs = new Sampling(cstep);
        }
    }

    private void updateArraySampling() {
        int n1 = this._s1.getCount();
        int n2 = this._s2.getCount();
        double d1 = this._s1.getDelta();
        double d2 = this._s2.getDelta();
        double f1 = this._s1.getFirst();
        double f2 = this._s2.getFirst();
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this._transposed = true;
            this._xflipped = false;
            this._yflipped = false;
            this._nx = n2;
            this._dx = d2;
            this._fx = f2;
            this._ny = n1;
            this._dy = d1;
            this._fy = f1;
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this._transposed = false;
            this._xflipped = false;
            this._yflipped = true;
            this._nx = n1;
            this._dx = d1;
            this._fx = f1;
            this._ny = n2;
            this._dy = d2;
            this._fy = f2;
        }
        this.updateBestProjectors();
    }

    private void updateBestProjectors() {
        double tiny;
        double x0 = this._fx;
        double x1 = this._fx + this._dx * (double)(this._nx - 1);
        double y0 = this._fy;
        double y1 = this._fy + this._dy * (double)(this._ny - 1);
        if (this._xflipped) {
            double xt = y0;
            x0 = x1;
            x1 = xt;
        }
        if (this._yflipped) {
            double yt = y0;
            y0 = y1;
            y1 = yt;
        }
        if (x0 == x1) {
            tiny = ArrayMath.max(0.5, 1.1920928955078125E-7 * ArrayMath.abs(x0));
            x0 -= tiny;
            x1 += tiny;
        }
        if (y0 == y1) {
            tiny = ArrayMath.max(0.5, 1.1920928955078125E-7 * ArrayMath.abs(y0));
            y0 -= tiny;
            y1 += tiny;
        }
        double u0 = 0.0;
        double u1 = 1.0;
        if (this._lineWidth > 1.0f) {
            u0 = 0.01;
            u1 = 0.99;
        }
        Projector bhp = new Projector(x0, x1, u0, u1);
        Projector bvp = new Projector(y0, y1, u0, u1);
        this.setBestProjectors(bhp, bvp);
    }

    private void updateContours() {
        if (this._cl == null) {
            int nc = this._cs.getCount();
            this._cl = new ArrayList();
            for (int ic = 0; ic < nc; ++ic) {
                float fc = (float)this._cs.getValue(ic);
                Contour c = ContoursView.makeContour(fc, this._s1, this._s2, this._f);
                this._cl.add(c);
            }
        }
    }

    private void computeXY(Projector hp, Projector vp, Transcaler ts, int n, float[] x1, float[] x2, int[] x, int[] y) {
        float[] yv;
        float[] xv;
        ts = ts.combineWith(hp, vp);
        if (this._transposed) {
            xv = x2;
            yv = x1;
        } else {
            xv = x1;
            yv = x2;
        }
        for (int i = 0; i < n; ++i) {
            x[i] = ts.x(xv[i]);
            y[i] = ts.y(yv[i]);
        }
    }

    private static Contour makeContour(float fc, Sampling s1, Sampling s2, float[][] f) {
        int i;
        FloatList x2;
        FloatList x1;
        float d;
        int i1;
        int i2;
        int n1 = s1.getCount();
        double d1 = s1.getDelta();
        double f1 = s1.getFirst();
        int n2 = s2.getCount();
        double d2 = s2.getDelta();
        double f2 = s2.getFirst();
        int n1m1 = n1 - 1;
        int n2m1 = n2 - 1;
        byte[][] flags = new byte[n2][n1];
        int ni = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                if (i2 < n2m1 && ContoursView.between(fc, f[i2][i1], f[i2 + 1][i1])) {
                    ContoursView.setw(i1, i2, flags);
                    ++ni;
                }
                if (i1 >= n1m1 || !ContoursView.between(fc, f[i2][i1], f[i2][i1 + 1])) continue;
                ContoursView.sets(i1, i2, flags);
                ++ni;
            }
        }
        Contour c = new Contour(fc);
        i2 = n2m1;
        i1 = 0;
        int is = i1 + i2 * n1;
        while (i1 < n1m1 && ni > 0) {
            if (ContoursView.sset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)((float)i1 + d) * d1);
                x2.add(f2 + (double)i2 * d2);
                ContoursView.clrs(i1, i2, flags);
                i = is - n1;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i1;
            ++is;
        }
        i1 = n1m1;
        i2 = 0;
        is = i1 + i2 * n1;
        while (i2 < n2m1 && ni > 0) {
            if (ContoursView.wset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)i1 * d1);
                x2.add(f2 + (double)((float)i2 + d) * d2);
                ContoursView.clrw(i1, i2, flags);
                i = is - 1;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i2;
            is += n1;
        }
        i2 = 0;
        i1 = 0;
        is = i1 + i2 * n1;
        while (i1 < n1m1 && ni > 0) {
            if (ContoursView.sset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)((float)i1 + d) * d1);
                x2.add(f2 + (double)i2 * d2);
                ContoursView.clrs(i1, i2, flags);
                i = is;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i1;
            ++is;
        }
        i1 = 0;
        i2 = 0;
        is = i1 + i2 * n1;
        while (i2 < n2m1 && ni > 0) {
            if (ContoursView.wset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)i1 * d1);
                x2.add(f2 + (double)((float)i2 + d) * d2);
                ContoursView.clrw(i1, i2, flags);
                i = is;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i2;
            is += n1;
        }
        for (i2 = 1; i2 < n2m1 && ni > 0; ++i2) {
            i1 = 0;
            is = i1 + i2 * n1;
            while (i1 < n1m1 && ni > 0) {
                if (ContoursView.sset(i1, i2, flags)) {
                    d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
                    x1 = new FloatList();
                    x2 = new FloatList();
                    x1.add(f1 + (double)((float)i1 + d) * d1);
                    x2.add(f2 + (double)i2 * d2);
                    ContoursView.clrs(i1, i2, flags);
                    i = is;
                    while (i >= 0) {
                        --ni;
                        i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                    }
                    x1.add(x1.a[0]);
                    x2.add(x2.a[0]);
                    c.append(x1, x2);
                }
                ++i1;
                ++is;
            }
        }
        return c;
    }

    private static int connect(int index, float fc, int n1, double d1, double f1, int n2, double d2, double f2, float[][] f, byte[][] flags, FloatList x1, FloatList x2) {
        int i1 = index % n1;
        int i2 = index / n1;
        if (ContoursView.sset(i1, i2 + 1, flags)) {
            float d = ContoursView.delta(fc, f[i2 + 1][i1], f[i2 + 1][i1 + 1]);
            x1.add(f1 + (double)((float)i1 + d) * d1);
            x2.add(f2 + (double)(i2 + 1) * d2);
            ContoursView.clrs(i1, ++i2, flags);
            return i2 < n2 - 1 ? index + n1 : -1;
        }
        if (ContoursView.wset(i1 + 1, i2, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1 + 1], f[i2 + 1][i1 + 1]);
            x1.add(f1 + (double)(i1 + 1) * d1);
            x2.add(f2 + (double)((float)i2 + d) * d2);
            ContoursView.clrw(++i1, i2, flags);
            return i1 < n1 - 1 ? index + 1 : -1;
        }
        if (ContoursView.sset(i1, i2, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
            x1.add(f1 + (double)((float)i1 + d) * d1);
            x2.add(f2 + (double)i2 * d2);
            ContoursView.clrs(i1, i2, flags);
            return i2 > 0 ? index - n1 : -1;
        }
        if (ContoursView.wset(i1, i2, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
            x1.add(f1 + (double)i1 * d1);
            x2.add(f2 + (double)((float)i2 + d) * d2);
            ContoursView.clrw(i1, i2, flags);
            return i1 > 0 ? index - 1 : -1;
        }
        return -1;
    }

    private static void sets(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] | 2);
    }

    private static void setw(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] | 1);
    }

    private static void clrs(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] & 0xFFFFFFFD);
    }

    private static void clrw(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
    }

    private static boolean sset(int i1, int i2, byte[][] flags) {
        return (flags[i2][i1] & 2) != 0;
    }

    private static boolean wset(int i1, int i2, byte[][] flags) {
        return (flags[i2][i1] & 1) != 0;
    }

    private static boolean between(float fc, float f1, float f2) {
        return f1 <= f2 ? f1 <= fc && fc < f2 : f2 <= fc && fc < f1;
    }

    private static float delta(float fc, float f1, float f2) {
        return f1 != f2 ? (fc - f1) / (f2 - f1) : 1.0f;
    }

    private static class FloatList {
        public int n;
        public float[] a = new float[64];

        private FloatList() {
        }

        public void add(double f) {
            if (this.n == this.a.length) {
                float[] t = new float[2 * this.a.length];
                for (int i = 0; i < this.n; ++i) {
                    t[i] = this.a[i];
                }
                this.a = t;
            }
            this.a[this.n++] = (float)f;
        }

        public float[] trim() {
            float[] t = new float[this.n];
            for (int i = 0; i < this.n; ++i) {
                t[i] = this.a[i];
            }
            return t;
        }
    }

    private static class Contour {
        float fc;
        int ns = 0;
        ArrayList<float[]> x1 = new ArrayList();
        ArrayList<float[]> x2 = new ArrayList();

        Contour(float fc) {
            this.fc = fc;
        }

        void append(FloatList x1List, FloatList x2List) {
            ++this.ns;
            this.x1.add(x1List.trim());
            this.x2.add(x2List.trim());
        }
    }

    public static enum Line {
        DEFAULT,
        SOLID,
        DASH,
        DOT,
        DASH_DOT;

    }

    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }
}

