/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.JIT;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.ir.targets.SiteTracker;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class InvokeSite
extends MutableCallSite {
    final Signature signature;
    final Signature fullSignature;
    final int arity;
    protected final String methodName;
    final MethodHandle fallback;
    private final SiteTracker tracker = new SiteTracker();
    private static final AtomicLong SITE_ID = new AtomicLong(1L);
    private final long siteID = SITE_ID.getAndIncrement();
    private final int argOffset;
    protected final String file;
    protected final int line;
    private boolean boundOnce;
    private boolean literalClosure;
    CacheEntry cache = CacheEntry.NULL_CACHE;
    private static final Logger LOG = LoggerFactory.getLogger(InvokeSite.class);
    public final CallType callType;
    private static final MethodHandle ESCAPE_BLOCK = Binder.from(Void.TYPE, Block.class, (Class[])new Class[0]).invokeVirtualQuiet(MethodHandles.lookup(), "escape");
    private static final Map<Signature, MethodHandle> BLOCK_ESCAPES = Collections.synchronizedMap(new HashMap());
    private static final MethodHandle TEST_CLASS = Binder.from(Boolean.TYPE, Object.class, (Class[])new Class[]{Class.class}).invokeStaticQuiet(MethodHandles.lookup(), InvokeSite.class, "testClass");

    public String name() {
        return this.methodName;
    }

    public InvokeSite(MethodType type2, String name2, CallType callType, String file2, int line) {
        this(type2, name2, callType, false, file2, line);
    }

    public InvokeSite(MethodType type2, String name2, CallType callType, boolean literalClosure, String file2, int line) {
        super(type2);
        int arity2;
        Signature startSig;
        this.methodName = name2;
        this.callType = callType;
        this.literalClosure = literalClosure;
        this.file = file2;
        this.line = line;
        if (callType == CallType.SUPER) {
            startSig = JRubyCallSite.STANDARD_SUPER_SIG;
            this.argOffset = 4;
        } else {
            startSig = JRubyCallSite.STANDARD_SITE_SIG;
            this.argOffset = 3;
        }
        if (type2.parameterType(type2.parameterCount() - 1) == Block.class) {
            arity2 = type2.parameterCount() - (this.argOffset + 1);
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i2 = 0; i2 < arity2; ++i2) {
                    startSig = startSig.appendArg("arg" + i2, IRubyObject.class);
                }
            }
            this.fullSignature = this.signature = (startSig = startSig.appendArg("block", Block.class));
        } else {
            arity2 = type2.parameterCount() - this.argOffset;
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i3 = 0; i3 < arity2; ++i3) {
                    startSig = startSig.appendArg("arg" + i3, IRubyObject.class);
                }
            }
            this.signature = startSig;
            this.fullSignature = startSig.appendArg("block", Block.class);
        }
        this.arity = arity2;
        this.fallback = this.prepareBinder(true).invokeVirtualQuiet(Bootstrap.LOOKUP, "invoke");
    }

    public static CallSite bootstrap(InvokeSite site, MethodHandles.Lookup lookup) {
        site.setInitialTarget(site.fallback);
        return site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject invoke(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(entry, caller2)) {
            if (this.testThresholds(selfClass) == CacheAction.FAIL) {
                this.logFail();
                this.bindToFail();
            } else {
                this.logMethodMissing();
            }
            return this.callMethodMissing(entry, this.callType, context, self2, this.methodName, args2, block);
        }
        MethodHandle mh = this.getHandle(self2, selfClass, method);
        if (this.literalClosure) {
            mh = Binder.from((MethodType)mh.type()).tryFinally(InvokeSite.getBlockEscape(this.signature)).invoke(mh);
        }
        this.updateInvocationTarget(mh, self2, selfClass, entry.method, switchPoint);
        if (this.literalClosure) {
            try {
                IRubyObject iRubyObject = method.call(context, self2, (RubyModule)selfClass, this.methodName, args2, block);
                return iRubyObject;
            }
            finally {
                block.escape();
            }
        }
        return method.call(context, self2, (RubyModule)selfClass, this.methodName, args2, block);
    }

    private static MethodHandle getBlockEscape(Signature signature) {
        Signature voidSignature = signature.changeReturn(Void.TYPE);
        MethodHandle escape2 = BLOCK_ESCAPES.get(voidSignature);
        if (escape2 == null) {
            escape2 = SmartBinder.from((Signature)voidSignature).permute(new String[]{"block"}).invoke(ESCAPE_BLOCK).handle();
            BLOCK_ESCAPES.put(voidSignature, escape2);
        }
        return escape2;
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return this.callMethodMissing(entry, this.callType, context, self2, name2, args2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) throws Throwable {
        return this.fail(context, caller2, self2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return this.callMethodMissing(entry, this.callType, context, self2, name2, arg0, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return this.callMethodMissing(entry, this.callType, context, self2, name2, arg0, arg1, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, selfClass, name2, arg0, arg1, arg2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return this.callMethodMissing(entry, this.callType, context, self2, name2, arg0, arg1, arg2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, selfClass, name2, arg0, arg1, arg2, block);
    }

    public Binder prepareBinder(boolean varargs) {
        SmartBinder binder = SmartBinder.from((Signature)this.signature);
        if ((varargs || this.arity > 3) && this.arity != -1) {
            binder = this.arity == 0 ? binder.insert(this.argOffset, "args", (Object)IRubyObject.NULL_ARRAY) : binder.collect("args", "arg[0-9]+");
        }
        if (this.signature.lastArgType() != Block.class) {
            binder = binder.append("block", (Object)Block.NULL_BLOCK);
        }
        binder = binder.insert(0, "site", (Object)this);
        return binder.binder();
    }

    MethodHandle getHandle(IRubyObject self2, RubyClass dispatchClass, DynamicMethod method) throws Throwable {
        boolean blockGiven = this.signature.lastArgType() == Block.class;
        MethodHandle mh = this.buildNewInstanceHandle(method, self2);
        if (mh == null) {
            mh = Bootstrap.buildNativeHandle(this, method, blockGiven);
        }
        if (mh == null) {
            mh = Bootstrap.buildIndyHandle(this, method, method.getImplementationClass());
        }
        if (mh == null) {
            mh = Bootstrap.buildJittedHandle(this, method, blockGiven);
        }
        if (mh == null) {
            mh = Bootstrap.buildAttrHandle(this, method, self2, dispatchClass);
        }
        if (mh == null) {
            mh = Bootstrap.buildGenericHandle(this, method, dispatchClass);
        }
        assert (mh != null) : "we should have a method handle of some sort by now";
        return mh;
    }

    MethodHandle buildNewInstanceHandle(DynamicMethod method, IRubyObject self2) {
        MethodHandle mh = null;
        if (method == self2.getRuntime().getBaseNewMethod()) {
            RubyClass recvClass = (RubyClass)self2;
            CallSite initSite = SelfInvokeSite.bootstrap(MethodHandles.lookup(), "callFunctional:initialize", this.type(), this.literalClosure ? 1 : 0, this.file, this.line);
            MethodHandle initHandle = initSite.dynamicInvoker();
            MethodHandle allocFilter = Binder.from(IRubyObject.class, IRubyObject.class, (Class[])new Class[0]).cast(IRubyObject.class, new Class[]{RubyClass.class}).insert(0, new Class[]{ObjectAllocator.class, Ruby.class}, new Object[]{recvClass.getAllocator(), self2.getRuntime()}).invokeVirtualQuiet(MethodHandles.lookup(), "allocate");
            mh = SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)this.signature).filter("self", allocFilter).fold("dummy", initHandle).permute(new String[]{"self"}).identity().handle();
        }
        return mh;
    }

    MethodHandle updateInvocationTarget(MethodHandle target, IRubyObject self2, RubyModule testClass, DynamicMethod method, SwitchPoint switchPoint) {
        MethodHandle fallback;
        CacheAction cacheAction = this.testThresholds(testClass);
        switch (cacheAction) {
            case FAIL: {
                this.logFail();
                return this.bindToFail();
            }
            case PIC: {
                this.logPic(method);
                fallback = this.getTarget();
                break;
            }
            case REBIND: 
            case BIND: {
                this.logBind(cacheAction);
                fallback = this.fallback;
                break;
            }
            default: {
                throw new RuntimeException("invalid cache action: " + (Object)((Object)cacheAction));
            }
        }
        this.tracker.addType(testClass.id);
        SmartHandle test2 = self2 instanceof RubySymbol || self2 instanceof RubyFixnum || self2 instanceof RubyFloat || self2 instanceof RubyNil || self2 instanceof RubyBoolean.True || self2 instanceof RubyBoolean.False ? SmartBinder.from((Signature)this.signature.asFold(Boolean.TYPE)).permute(new String[]{"self"}).insert(1, "selfJavaType", self2.getClass()).cast(Boolean.TYPE, new Class[]{Object.class, Class.class}).invoke(TEST_CLASS) : SmartBinder.from((Signature)this.signature.changeReturn(Boolean.TYPE)).permute(new String[]{"self"}).insert(0, "selfClass", RubyClass.class, (Object)testClass).invokeStaticQuiet(Bootstrap.LOOKUP, Bootstrap.class, "testType");
        MethodHandle gwt = MethodHandles.guardWithTest(test2.handle(), target, fallback);
        gwt = switchPoint.guardWithTest(gwt, fallback);
        this.setTarget(gwt);
        return target;
    }

    private void logMethodMissing() {
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(this.methodName + "\ttriggered site #" + this.siteID + " method_missing (" + this.file + ":" + this.line + ")", new Object[0]);
        }
    }

    private void logBind(CacheAction action) {
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(this.methodName + "\ttriggered site #" + this.siteID + " " + (Object)((Object)action) + " (" + this.file + ":" + this.line + ")", new Object[0]);
        }
    }

    private void logPic(DynamicMethod method) {
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(this.methodName + "\tadded to PIC " + InvokeSite.logMethod(method), new Object[0]);
        }
    }

    private void logFail() {
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            if (this.tracker.clearCount() > (Integer)Options.INVOKEDYNAMIC_MAXFAIL.load()) {
                LOG.info(this.methodName + "\tat site #" + this.siteID + " failed more than " + Options.INVOKEDYNAMIC_MAXFAIL.load() + " times; bailing out (" + this.file + ":" + this.line + ")", new Object[0]);
            } else if (this.tracker.seenTypesCount() + 1 > (Integer)Options.INVOKEDYNAMIC_MAXPOLY.load()) {
                LOG.info(this.methodName + "\tat site #" + this.siteID + " encountered more than " + Options.INVOKEDYNAMIC_MAXPOLY.load() + " types; bailing out (" + this.file + ":" + this.line + ")", new Object[0]);
            }
        }
    }

    private MethodHandle bindToFail() {
        MethodHandle target = this.prepareBinder(false).invokeVirtualQuiet(MethodHandles.lookup(), "fail");
        this.setTarget(target);
        return target;
    }

    CacheAction testThresholds(RubyModule testClass) {
        if (this.tracker.clearCount() > (Integer)Options.INVOKEDYNAMIC_MAXFAIL.load() || !this.tracker.hasSeenType(testClass.id) && this.tracker.seenTypesCount() + 1 > (Integer)Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            return CacheAction.FAIL;
        }
        if (this.tracker.seenTypesCount() > 0 && this.getTarget() != null && !this.tracker.hasSeenType(testClass.id)) {
            this.tracker.addType(testClass.id);
            return CacheAction.PIC;
        }
        this.tracker.clearTypes();
        this.tracker.addType(testClass.id);
        return this.boundOnce ? CacheAction.REBIND : CacheAction.BIND;
    }

    public RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2) {
        context.callThreadPoll();
        RubyClass selfType = ((RubyBasicObject)self2).getMetaClass();
        return selfType;
    }

    @Override
    public void setTarget(MethodHandle target) {
        super.setTarget(target);
        this.boundOnce = true;
    }

    public void setInitialTarget(MethodHandle target) {
        super.setTarget(target);
    }

    public abstract boolean methodMissing(CacheEntry var1, IRubyObject var2);

    public IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, self2, entry.method.getVisibility(), name2, callType).call(context, self2, (RubyModule)self2.getMetaClass(), name2, args2, block);
    }

    public IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, self2, entry.method.getVisibility(), name2, callType).call(context, self2, (RubyModule)self2.getMetaClass(), name2, arg0, block);
    }

    public IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, self2, entry.method.getVisibility(), name2, callType).call(context, self2, (RubyModule)self2.getMetaClass(), name2, arg0, arg1, block);
    }

    public IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, self2, entry.method.getVisibility(), name2, callType).call(context, self2, self2.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    private static String logMethod(DynamicMethod method) {
        return "[#" + method.getSerialNumber() + " " + method.getImplementationClass() + "]";
    }

    @JIT
    public static boolean testMetaclass(RubyClass metaclass, IRubyObject self2) {
        return metaclass == ((RubyBasicObject)self2).getMetaClass();
    }

    @JIT
    public static boolean testClass(Object object, Class clazz) {
        return object.getClass() == clazz;
    }

    public String toString() {
        return "InvokeSite[name=" + this.name() + ",arity=" + this.arity + ",type=" + this.type() + ",file=" + this.file + ",line=" + this.line + "]";
    }

    static enum CacheAction {
        FAIL,
        BIND,
        REBIND,
        PIC;

    }
}

