/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.ListProperty;
import org.smurn.jply.Property;

class TypeChangingElementReader
implements ElementReader {
    private final ElementReader reader;
    private final ElementType targetType;
    private final List<String> sharedPropertiesNoList;
    private final List<String> sharedPropertiesList;
    private final Map<String, String> propertyNameMap;

    TypeChangingElementReader(ElementReader reader, ElementType targetType) {
        this(reader, targetType, Collections.emptyMap());
    }

    TypeChangingElementReader(ElementReader reader, ElementType targetType, Map<String, String> sourceNames) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        if (targetType == null) {
            throw new NullPointerException("targetType must not be null.");
        }
        if (sourceNames == null) {
            throw new NullPointerException("renames must not be null.");
        }
        this.reader = reader;
        this.targetType = targetType;
        this.propertyNameMap = Collections.unmodifiableMap(new HashMap<String, String>(sourceNames));
        ElementType sourceType = reader.getElementType();
        ArrayList<String> sharedPropertiesNoListTmp = new ArrayList<String>();
        ArrayList<String> sharedPropertiesListTmp = new ArrayList<String>();
        for (Property targetProp : targetType.getProperties()) {
            boolean match = false;
            for (Property sourceProp : sourceType.getProperties()) {
                if (!sourceProp.getName().equals(this.getSourceName(targetProp.getName()))) continue;
                match = true;
                break;
            }
            if (!match) continue;
            if (targetProp instanceof ListProperty) {
                sharedPropertiesListTmp.add(targetProp.getName());
                continue;
            }
            sharedPropertiesNoListTmp.add(targetProp.getName());
        }
        this.sharedPropertiesNoList = Collections.unmodifiableList(sharedPropertiesNoListTmp);
        this.sharedPropertiesList = Collections.unmodifiableList(sharedPropertiesListTmp);
    }

    private String getSourceName(String property) {
        if (this.propertyNameMap.containsKey(property)) {
            return this.propertyNameMap.get(property);
        }
        return property;
    }

    @Override
    public ElementType getElementType() {
        return this.targetType;
    }

    @Override
    public int getCount() {
        return this.reader.getCount();
    }

    @Override
    public Element readElement() throws IOException {
        double[] values;
        Element source = this.reader.readElement();
        if (source == null) {
            return null;
        }
        Element target = new Element(this.targetType);
        for (String property : this.sharedPropertiesNoList) {
            values = source.getDoubleList(this.getSourceName(property));
            if (values.length <= 0) continue;
            target.setDouble(property, values[0]);
        }
        for (String property : this.sharedPropertiesList) {
            values = source.getDoubleList(this.getSourceName(property));
            target.setDoubleList(property, values);
        }
        return target;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean isClosed() {
        return this.reader.isClosed();
    }
}

