/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils;

import net.imglib2.type.numeric.ARGBType;

public class ARGBVector {
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private int alpha = 0;

    public void add(ARGBType color) {
        int colorCode = color.get();
        this.red += ARGBType.red((int)colorCode);
        this.green += ARGBType.green((int)colorCode);
        this.blue += ARGBType.blue((int)colorCode);
        this.alpha += ARGBType.alpha((int)colorCode);
    }

    public void div(int value) {
        this.red /= value;
        this.green /= value;
        this.blue /= value;
        this.alpha /= value;
    }

    public ARGBType get() {
        return new ARGBType(this.getAsint());
    }

    public int getAsint() {
        int r = this.upperBound(this.red);
        int g = this.upperBound(this.green);
        int b = this.upperBound(this.blue);
        int a = this.upperBound(this.alpha);
        return ARGBType.rgba((int)r, (int)g, (int)b, (int)a);
    }

    private int upperBound(int value) {
        return Math.min(255, value);
    }
}

