/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import java.util.ArrayList;
import java.util.List;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.RadiusNeighborSearch;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.type.numeric.RealType;

public class AdaptiveNonMaximalSuppression<T extends RealType<T>>
implements Algorithm,
Benchmark {
    final List<DifferenceOfGaussianPeak<T>> detections;
    double radius;
    long processingTime;
    String errorMessage = "";

    public AdaptiveNonMaximalSuppression(List<DifferenceOfGaussianPeak<T>> detections, double radius) {
        this.detections = detections;
        this.radius = radius;
        this.processingTime = -1L;
    }

    public ArrayList<DifferenceOfGaussianPeak<T>> getClearedList() {
        ArrayList<DifferenceOfGaussianPeak<T>> clearedList = new ArrayList<DifferenceOfGaussianPeak<T>>();
        for (DifferenceOfGaussianPeak<T> peak : this.detections) {
            if (!peak.isValid()) continue;
            clearedList.add(peak);
        }
        return clearedList;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        KDTree<DifferenceOfGaussianPeak<T>> tree = new KDTree<DifferenceOfGaussianPeak<T>>(this.detections);
        RadiusNeighborSearch<DifferenceOfGaussianPeak<DifferenceOfGaussianPeak<T>>> search = new RadiusNeighborSearch<DifferenceOfGaussianPeak<DifferenceOfGaussianPeak<T>>>(tree);
        for (DifferenceOfGaussianPeak<T> det : this.detections) {
            if (!det.isValid()) continue;
            ArrayList<DifferenceOfGaussianPeak<T>> neighbors = search.findNeighborsUnsorted(det, this.radius);
            ArrayList<DifferenceOfGaussianPeak<T>> extrema = new ArrayList<DifferenceOfGaussianPeak<T>>();
            for (DifferenceOfGaussianPeak<T> peak : neighbors) {
                if ((!det.isMax() || !peak.isMax()) && (!det.isMin() || !peak.isMin())) continue;
                extrema.add(peak);
            }
            this.invalidateLowerEntries(extrema, det);
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void invalidateLowerEntries(ArrayList<DifferenceOfGaussianPeak<T>> extrema, DifferenceOfGaussianPeak<T> centralPeak) {
        double centralValue = Math.abs(((RealType)centralPeak.getValue()).getRealDouble());
        for (DifferenceOfGaussianPeak<T> peak : extrema) {
            if (!(Math.abs(((RealType)peak.getValue()).getRealDouble()) < centralValue)) continue;
            peak.setPeakType(DifferenceOfGaussian.SpecialPoint.INVALID);
        }
    }

    @Override
    public boolean checkInput() {
        if (this.detections == null) {
            this.errorMessage = "List<DifferenceOfGaussianPeak<T>> detections is null.";
            return false;
        }
        if (this.detections.size() == 0) {
            this.errorMessage = "List<DifferenceOfGaussianPeak<T>> detections is empty.";
            return false;
        }
        if (Double.isNaN(this.radius)) {
            this.errorMessage = "Radius is NaN.";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }
}

