/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display.imagej;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.RGBALegacyType;

public class RGBALegacyTypeDisplay
extends Display<RGBALegacyType> {
    public RGBALegacyTypeDisplay(Image<RGBALegacyType> img) {
        super(img);
        this.min = 0.0;
        this.max = 255.0;
    }

    protected final float avg(int col) {
        int r = RGBALegacyType.red(col);
        int g = RGBALegacyType.green(col);
        int b = RGBALegacyType.blue(col);
        return 0.3f * (float)r + 0.6f * (float)g + 0.1f * (float)b;
    }

    protected final int max(int col) {
        int r = RGBALegacyType.red(col);
        int g = RGBALegacyType.green(col);
        int b = RGBALegacyType.blue(col);
        return Math.max(Math.max(r, g), b);
    }

    protected final int min(int col) {
        int r = RGBALegacyType.red(col);
        int g = RGBALegacyType.green(col);
        int b = RGBALegacyType.blue(col);
        return Math.min(Math.min(r, g), b);
    }

    @Override
    public void setMinMax() {
        Cursor c = this.img.createCursor();
        RGBALegacyType t = (RGBALegacyType)c.getType();
        if (!c.hasNext()) {
            this.min = 0.0;
            this.max = 255.0;
            return;
        }
        c.fwd();
        this.min = this.min(t.get());
        this.max = this.max(t.get());
        while (c.hasNext()) {
            c.fwd();
            int value = t.get();
            int minValue = this.min(value);
            int maxValue = this.max(value);
            if ((double)maxValue > this.max) {
                this.max = maxValue;
            }
            if (value >= minValue) continue;
            this.min = minValue;
        }
        c.close();
    }

    @Override
    public float get32Bit(RGBALegacyType c) {
        return this.avg(c.get());
    }

    @Override
    public float get32BitNormed(RGBALegacyType c) {
        return this.normFloat(this.avg(c.get()));
    }

    @Override
    public byte get8BitSigned(RGBALegacyType c) {
        return (byte)Math.round(this.normFloat(this.avg(c.get())) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(RGBALegacyType c) {
        return (short)Math.round(this.normFloat(this.avg(c.get())) * 255.0f);
    }

    @Override
    public int get8BitARGB(RGBALegacyType c) {
        return c.get();
    }
}

