/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.StatusEvent;
import loci.common.StatusListener;
import loci.common.StatusReporter;
import loci.common.services.ServiceException;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLServiceImpl;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.basictypecontainer.PlanarAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.container.planar.PlanarContainerFactory;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedIntType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;
import ome.units.quantity.Length;
import ome.units.quantity.Time;

public class ImageOpener
implements StatusReporter {
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String Z = "Z";
    public static final String TIME = "Time";
    public static final String CHANNEL = "Channel";
    private List<StatusListener> listeners = new ArrayList<StatusListener>();

    public <T extends RealType<T>> Image<T> openImage(String id) throws FormatException, IOException {
        return this.openImage(id, new PlanarContainerFactory());
    }

    public <T extends RealType<T>> Image<T> openImage(String id, ContainerFactory containerFactory) throws FormatException, IOException {
        IFormatReader r = this.initializeReader(id);
        T type = ImageOpener.makeType(r.getPixelType());
        ImageFactory<T> imageFactory = new ImageFactory<T>(type, containerFactory);
        return this.openImage(r, imageFactory);
    }

    public <T extends RealType<T>> Image<T> openImage(String id, ImageFactory<T> imageFactory) throws FormatException, IOException {
        IFormatReader r = this.initializeReader(id);
        return this.openImage(r, imageFactory);
    }

    public <T extends RealType<T>> Image<T> openImage(IFormatReader r, ImageFactory<T> imageFactory) throws FormatException, IOException {
        String[] dimTypes = this.getDimTypes(r);
        int[] dimLengths = this.getDimLengths(r);
        String id = r.getCurrentFile();
        File idFile = new File(id);
        String name = idFile.exists() ? idFile.getName() : id;
        name = this.encodeName(name, dimTypes);
        Image<T> img = imageFactory.createImage(dimLengths, name);
        img.setCalibration(this.getCalibration(r, dimLengths));
        PlanarAccess<ArrayDataAccess<?>> planarAccess = ImageOpener.getPlanarAccess(img);
        T inputType = ImageOpener.makeType(r.getPixelType());
        RealType outputType = (RealType)imageFactory.createType();
        boolean compatibleTypes = outputType.getClass().isAssignableFrom(inputType.getClass());
        long startTime = System.currentTimeMillis();
        int planeCount = r.getImageCount();
        if (planarAccess == null || !compatibleTypes) {
            LocalizablePlaneCursor<T> cursor = img.createLocalizablePlaneCursor();
            byte[] plane = null;
            for (int no = 0; no < planeCount; ++no) {
                this.notifyListeners(new StatusEvent(no, planeCount, "Reading plane " + (no + 1) + "/" + planeCount));
                if (plane == null) {
                    plane = r.openBytes(no);
                } else {
                    r.openBytes(no, plane);
                }
                this.populatePlane(r, no, plane, cursor);
            }
            cursor.close();
        } else {
            byte[] plane = null;
            for (int no = 0; no < planeCount; ++no) {
                this.notifyListeners(new StatusEvent(no, planeCount, "Reading plane " + (no + 1) + "/" + planeCount));
                if (plane == null) {
                    plane = r.openBytes(no);
                } else {
                    r.openBytes(no, plane);
                }
                this.populatePlane(r, no, plane, planarAccess);
            }
        }
        r.close();
        long endTime = System.currentTimeMillis();
        float time = (float)(endTime - startTime) / 1000.0f;
        this.notifyListeners(new StatusEvent(planeCount, planeCount, id + ": read " + planeCount + " planes in " + time + "s"));
        return img;
    }

    public static PlanarAccess<ArrayDataAccess<?>> getPlanarAccess(Image<?> im) {
        PlanarAccess planarAccess = null;
        Container<?> container = im.getContainer();
        if (container instanceof PlanarAccess) {
            planarAccess = (PlanarAccess)((Object)container);
        }
        return planarAccess;
    }

    public static <T extends RealType<T>> T makeType(int pixelType) {
        RealTypeImpl type;
        switch (pixelType) {
            case 1: {
                type = new UnsignedByteType();
                break;
            }
            case 0: {
                type = new ByteType();
                break;
            }
            case 3: {
                type = new UnsignedShortType();
                break;
            }
            case 2: {
                type = new ShortType();
                break;
            }
            case 5: {
                type = new UnsignedIntType();
                break;
            }
            case 4: {
                type = new IntType();
                break;
            }
            case 6: {
                type = new FloatType();
                break;
            }
            case 7: {
                type = new DoubleType();
                break;
            }
            default: {
                type = null;
            }
        }
        return (T)type;
    }

    public static ArrayDataAccess<?> makeArray(Object array) {
        ArrayDataAccess<ByteArray> access = array instanceof byte[] ? new ByteArray((byte[])array) : (array instanceof char[] ? new CharArray((char[])array) : (array instanceof double[] ? new DoubleArray((double[])array) : (array instanceof int[] ? new IntArray((int[])array) : (array instanceof float[] ? new FloatArray((float[])array) : (array instanceof short[] ? new ShortArray((short[])array) : (array instanceof long[] ? new LongArray((long[])array) : null))))));
        return access;
    }

    public static String decodeName(String name) {
        int lBracket = name.lastIndexOf(" [");
        return name.substring(0, lBracket);
    }

    public static String[] decodeTypes(String name) {
        int lBracket = name.lastIndexOf(" [");
        if (lBracket < 0) {
            return new String[0];
        }
        int rBracket = name.lastIndexOf("]");
        if (rBracket < lBracket) {
            return new String[0];
        }
        return name.substring(lBracket + 2, rBracket).split(" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(StatusEvent e) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            for (StatusListener l : this.listeners) {
                l.statusUpdated(e);
            }
        }
    }

    private IFormatReader initializeReader(String id) throws FormatException, IOException {
        this.notifyListeners(new StatusEvent("Initializing " + id));
        ImageReader r = null;
        r = new ImageReader();
        r = new ChannelFiller((IFormatReader)r);
        r = new ChannelSeparator((IFormatReader)r);
        try {
            r.setMetadataStore((MetadataStore)new OMEXMLServiceImpl().createOMEXMLMetadata());
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        r.setId(id);
        return r;
    }

    private String[] getDimTypes(IFormatReader r) {
        int sizeX = r.getSizeX();
        int sizeY = r.getSizeY();
        int sizeZ = r.getSizeZ();
        int sizeT = r.getSizeT();
        int sizeC = r.getSizeC();
        String dimOrder = r.getDimensionOrder();
        ArrayList<String> dimTypes = new ArrayList<String>();
        block7: for (char dim : dimOrder.toCharArray()) {
            switch (dim) {
                case 'X': {
                    if (sizeX <= 1) continue block7;
                    dimTypes.add(X);
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 1) continue block7;
                    dimTypes.add(Y);
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1) continue block7;
                    dimTypes.add(Z);
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1) continue block7;
                    dimTypes.add(TIME);
                    continue block7;
                }
                case 'C': {
                    if (sizeC <= 1) continue block7;
                    dimTypes.add(CHANNEL);
                }
            }
        }
        return dimTypes.toArray(new String[0]);
    }

    private float[] getCalibration(IFormatReader r, int[] dimensions) {
        float[] calibration = new float[dimensions.length];
        for (int i = 0; i < calibration.length; ++i) {
            calibration[i] = 1.0f;
        }
        try {
            String dimOrder = r.getDimensionOrder().toUpperCase();
            MetadataRetrieve retrieve = (MetadataRetrieve)r.getMetadataStore();
            int posX = dimOrder.indexOf(88);
            Length cal = retrieve.getPixelsPhysicalSizeX(0);
            if (posX >= 0 && posX < calibration.length && cal != null && cal.value().floatValue() != 0.0f) {
                calibration[posX] = cal.value().floatValue();
            }
            int posY = dimOrder.indexOf(89);
            cal = retrieve.getPixelsPhysicalSizeY(0);
            if (posY >= 0 && posY < calibration.length && cal != null && cal.value().floatValue() != 0.0f) {
                calibration[posY] = cal.value().floatValue();
            }
            int posZ = dimOrder.indexOf(90);
            cal = retrieve.getPixelsPhysicalSizeZ(0);
            if (posZ >= 0 && posZ < calibration.length && cal != null && cal.value().floatValue() != 0.0f) {
                calibration[posZ] = cal.value().floatValue();
            }
            int posT = dimOrder.indexOf(84);
            retrieve.getPixelsTimeIncrement(0);
            Time cal1 = retrieve.getPixelsTimeIncrement(0);
            if (posT >= 0 && posT < calibration.length && cal1 != null && cal1.value().floatValue() != 0.0f) {
                calibration[posT] = cal1.value().floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calibration;
    }

    private int[] getDimLengths(IFormatReader r) {
        int sizeX = r.getSizeX();
        int sizeY = r.getSizeY();
        int sizeZ = r.getSizeZ();
        int sizeT = r.getSizeT();
        int sizeC = r.getSizeC();
        String dimOrder = r.getDimensionOrder();
        ArrayList<Integer> dimLengthsList = new ArrayList<Integer>();
        block7: for (int i = 0; i < dimOrder.length(); ++i) {
            char dim = dimOrder.charAt(i);
            switch (dim) {
                case 'X': {
                    if (sizeX <= 1) continue block7;
                    dimLengthsList.add(sizeX);
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 1) continue block7;
                    dimLengthsList.add(sizeY);
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1) continue block7;
                    dimLengthsList.add(sizeZ);
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1) continue block7;
                    dimLengthsList.add(sizeT);
                    continue block7;
                }
                case 'C': {
                    if (sizeC <= 1) continue block7;
                    dimLengthsList.add(sizeC);
                }
            }
        }
        int[] dimLengths = new int[dimLengthsList.size()];
        for (int i = 0; i < dimLengths.length; ++i) {
            dimLengths[i] = (Integer)dimLengthsList.get(i);
        }
        return dimLengths;
    }

    private void getPosition(IFormatReader r, int no, int[] pos) {
        int sizeX = r.getSizeX();
        int sizeY = r.getSizeY();
        int sizeZ = r.getSizeZ();
        int sizeT = r.getSizeT();
        int sizeC = r.getSizeC();
        String dimOrder = r.getDimensionOrder();
        int[] zct = r.getZCTCoords(no);
        int index = 0;
        block7: for (int i = 0; i < dimOrder.length(); ++i) {
            char dim = dimOrder.charAt(i);
            switch (dim) {
                case 'X': {
                    if (sizeX <= 1) continue block7;
                    ++index;
                    continue block7;
                }
                case 'Y': {
                    if (sizeY <= 1) continue block7;
                    ++index;
                    continue block7;
                }
                case 'Z': {
                    if (sizeZ <= 1) continue block7;
                    pos[index++] = zct[0];
                    continue block7;
                }
                case 'T': {
                    if (sizeT <= 1) continue block7;
                    pos[index++] = zct[2];
                    continue block7;
                }
                case 'C': {
                    if (sizeC <= 1) continue block7;
                    pos[index++] = zct[1];
                }
            }
        }
    }

    private String encodeName(String id, String[] dimTypes) {
        StringBuilder sb = new StringBuilder(id);
        boolean first = true;
        for (String dimType : dimTypes) {
            if (first) {
                sb.append(" [");
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(dimType);
        }
        if (!first) {
            sb.append("]");
        }
        return sb.toString();
    }

    private void populatePlane(IFormatReader r, int no, byte[] plane, PlanarAccess planarAccess) {
        boolean little;
        boolean fp;
        int pixelType = r.getPixelType();
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        Object planeArray = DataTools.makeDataArray((byte[])plane, (int)bpp, (boolean)(fp = FormatTools.isFloatingPoint((int)pixelType)), (boolean)(little = r.isLittleEndian()));
        if (planeArray == plane) {
            byte[] planeCopy = new byte[plane.length];
            System.arraycopy(plane, 0, planeCopy, 0, plane.length);
            planeArray = planeCopy;
        }
        planarAccess.setPlane(no, ImageOpener.makeArray(planeArray));
    }

    private <T extends RealType<T>> void populatePlane(IFormatReader r, int no, byte[] plane, LocalizablePlaneCursor<T> cursor) {
        int sizeX = r.getSizeX();
        int pixelType = r.getPixelType();
        boolean little = r.isLittleEndian();
        int[] dimLengths = this.getDimLengths(r);
        int[] pos = new int[dimLengths.length];
        boolean planeX = false;
        boolean planeY = true;
        this.getPosition(r, no, pos);
        cursor.reset(0, 1, pos);
        while (cursor.hasNext()) {
            cursor.fwd();
            int index = cursor.getPosition(0) + cursor.getPosition(1) * sizeX;
            double value = ImageOpener.decodeWord(plane, index, pixelType, little);
            ((RealType)cursor.getType()).setReal(value);
        }
    }

    private static double decodeWord(byte[] plane, int index, int pixelType, boolean little) {
        double value;
        switch (pixelType) {
            case 1: {
                value = plane[index] & 0xFF;
                break;
            }
            case 0: {
                value = plane[index];
                break;
            }
            case 3: {
                value = DataTools.bytesToShort((byte[])plane, (int)(2 * index), (int)2, (boolean)little) & 0xFFFF;
                break;
            }
            case 2: {
                value = DataTools.bytesToShort((byte[])plane, (int)(2 * index), (int)2, (boolean)little);
                break;
            }
            case 5: {
                value = (long)DataTools.bytesToInt((byte[])plane, (int)(4 * index), (int)4, (boolean)little) & 0xFFFFFFFFL;
                break;
            }
            case 4: {
                value = DataTools.bytesToInt((byte[])plane, (int)(4 * index), (int)4, (boolean)little);
                break;
            }
            case 6: {
                value = DataTools.bytesToFloat((byte[])plane, (int)(4 * index), (int)4, (boolean)little);
                break;
            }
            case 7: {
                value = DataTools.bytesToDouble((byte[])plane, (int)(8 * index), (int)8, (boolean)little);
                break;
            }
            default: {
                value = Double.NaN;
            }
        }
        return value;
    }
}

