/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.floydsteinberg.FloydSteinbergDithering;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class Dither<T extends RealType<T>>
extends Image<BitType> {
    public Dither(Image<T> img) throws Exception {
        super(Dither.process(img).getContainer(), new BitType());
    }

    public Dither(Image<T> img, float ditheringThreshold) throws Exception {
        super(Dither.process(img, ditheringThreshold).getContainer(), new BitType());
    }

    public Dither(IFunction fn) throws Exception {
        this(Compute.inDoubles(fn));
    }

    public Dither(IFunction fn, float ditheringThreshold) throws Exception {
        this(Compute.inDoubles(fn), ditheringThreshold);
    }

    private static final <R extends RealType<R>> Image<BitType> process(Image<R> img, float ditheringThreshold) throws Exception {
        return Dither.process(new FloydSteinbergDithering<R>(img, ditheringThreshold));
    }

    private static final <R extends RealType<R>> Image<BitType> process(Image<R> img) throws Exception {
        return Dither.process(new FloydSteinbergDithering<R>(img));
    }

    private static final <R extends RealType<R>> Image<R> process(OutputAlgorithm<R> oa) throws Exception {
        if (!oa.checkInput() || !oa.process()) {
            throw new Exception("Dither failed: " + oa.getErrorMessage());
        }
        return oa.getResult();
    }
}

