/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.objectweb.asm.Opcodes;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.util.CodegenUtils;

class PyFloatConstant
extends Constant
implements ClassConstants,
Opcodes {
    final double value;

    PyFloatConstant(double value) {
        this.value = value;
    }

    @Override
    void get(Code c) throws IOException {
        c.ldc(this.value);
        c.invokestatic(CodegenUtils.p(Py.class), "newFloat", CodegenUtils.sig(PyFloat.class, Double.TYPE));
    }

    @Override
    void put(Code c) throws IOException {
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof PyFloatConstant) {
            PyFloatConstant pyco = (PyFloatConstant)o;
            return Double.doubleToLongBits(pyco.value) == Double.doubleToLongBits(this.value);
        }
        return false;
    }
}

