/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import net.imglib2.img.AbstractImg;
import net.imglib2.img.NativeImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public abstract class AbstractNativeImg<T extends NativeType<T>, A>
extends AbstractImg<T>
implements NativeImg<T, A> {
    protected final Fraction entitiesPerPixel;
    protected long numEntities;
    protected T linkedType;

    public AbstractNativeImg(long[] dim, Fraction entitiesPerPixel) {
        super(dim);
        this.entitiesPerPixel = entitiesPerPixel;
        this.numEntities = entitiesPerPixel.mulCeil(this.numPixels);
    }

    @Override
    public void setLinkedType(T type) {
        this.linkedType = type;
    }

    @Override
    public T createLinkedType() {
        try {
            return this.linkedType.duplicateTypeOnSameNativeImg();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public T getType() {
        return this.linkedType;
    }
}

