/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.View;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.CompositeFactory;
import net.imglib2.view.composite.CompositeView;

public class CompositeIntervalView<T, C extends Composite<T>>
extends CompositeView<T, C>
implements RandomAccessibleInterval<C>,
View {
    final Interval interval;

    protected static final <T> RandomAccessibleInterval<T> zeroMinN(RandomAccessibleInterval<T> source) {
        long[] min = new long[source.numDimensions()];
        int n = min.length - 1;
        min[n] = source.min(n);
        return Views.offset(source, min);
    }

    public CompositeIntervalView(RandomAccessibleInterval<T> source, CompositeFactory<T, C> compositeFactory) {
        super(CompositeIntervalView.zeroMinN(source), compositeFactory);
        this.interval = source;
    }

    @Override
    public long min(int d) {
        return this.interval.min(d);
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.min(d);
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.min(d), d);
        }
    }

    @Override
    public long max(int d) {
        return this.interval.max(d);
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.max(d);
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.max(d), d);
        }
    }

    @Override
    public double realMin(int d) {
        return this.min(d);
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.min(d);
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        this.min(min);
    }

    @Override
    public double realMax(int d) {
        return this.max(d);
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.max(d);
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        this.max(max);
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.interval.dimension(d);
        }
    }

    @Override
    public long dimension(int d) {
        return this.interval.dimension(d);
    }
}

